/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.interfaces.tools.AddMineableAxe;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.blocks.materials.Materials;

public class BlockRubeusCone
extends BlockBaseNotFull
implements AddMineableAxe {
    private static final VoxelShape SHAPE = BlockRubeusCone.box((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);

    public BlockRubeusCone() {
        super(Materials.makeNetherWood(MapColor.COLOR_CYAN).strength(0.5f).lightLevel(s -> 15).noOcclusion());
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPE;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return world.getBlockState(pos.above()).isFaceSturdy((BlockGetter)world, pos.above(), Direction.DOWN);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (this.canSurvive(state, (LevelReader)world, pos)) {
            return state;
        }
        return Blocks.AIR.defaultBlockState();
    }
}

