/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.registry.NetherBlocks;

public abstract class BlockSmallLantern
extends BlockBaseNotFull {
    private static final VoxelShape SHAPE_NORTH = BlockSmallLantern.box((double)5.0, (double)0.0, (double)8.0, (double)11.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = BlockSmallLantern.box((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)8.0);
    private static final VoxelShape SHAPE_WEST = BlockSmallLantern.box((double)8.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0);
    private static final VoxelShape SHAPE_EAST = BlockSmallLantern.box((double)0.0, (double)0.0, (double)5.0, (double)8.0, (double)16.0, (double)11.0);
    private static final VoxelShape SHAPE_UP = BlockSmallLantern.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0);
    private static final VoxelShape SHAPE_DOWN = BlockSmallLantern.box((double)5.0, (double)3.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final DirectionProperty FACING = BlockStateProperties.FACING;

    protected BlockSmallLantern() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)NetherBlocks.CINCINNASITE_LANTERN).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.DOWN));
        this.setRenderLayer(BNRenderLayer.CUTOUT);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{FACING});
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
            case UP: {
                return SHAPE_UP;
            }
        }
        return SHAPE_DOWN;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Comparable _facing = (Comparable)state.getValues().get(FACING);
        if (_facing == null) {
            return false;
        }
        Direction shape = (Direction)FACING.getValueClass().cast(_facing);
        Direction direction = shape.getOpposite();
        return BlockSmallLantern.canSupportCenter((LevelReader)world, (BlockPos)pos.relative(direction), (Direction)direction.getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return BlocksHelper.rotateHorizontal(state, rotation, (Property<Direction>)FACING);
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return BlocksHelper.mirrorHorizontal(state, mirror, (Property<Direction>)FACING);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (this.canSurvive(state, (LevelReader)world, pos)) {
            return state;
        }
        return Blocks.AIR.defaultBlockState();
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState blockState = this.defaultBlockState();
        Level worldView = ctx.getLevel();
        BlockPos blockPos = ctx.getClickedPos();
        Direction[] directions = ctx.getNearestLookingDirections();
        for (int i = 0; i < directions.length; ++i) {
            Direction direction = directions[i];
            Direction direction2 = direction.getOpposite();
            if (!(blockState = (BlockState)blockState.setValue((Property)FACING, (Comparable)direction2)).canSurvive((LevelReader)worldView, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    public static class Metal
    extends BlockSmallLantern
    implements BehaviourMetal {
    }
}

