/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import de.ambertation.wunderlib.math.Float3;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.registry.NetherBlocks;

public class BlockStatueRespawner
extends BlockBaseNotFull
implements BehaviourMetal {
    private static final VoxelShape SHAPE = BlockStatueRespawner.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape CULL_SHAPE = Shapes.or((VoxelShape)BlockStatueRespawner.box((double)9.0, (double)0.0, (double)4.0, (double)13.0, (double)12.0, (double)8.0), (VoxelShape[])new VoxelShape[]{BlockStatueRespawner.box((double)5.0, (double)0.0, (double)8.0, (double)7.0, (double)6.0, (double)10.0), BlockStatueRespawner.box((double)9.0, (double)0.0, (double)8.0, (double)13.0, (double)12.0, (double)122.0), BlockStatueRespawner.box((double)5.0, (double)0.0, (double)6.0, (double)7.0, (double)6.0, (double)8.0)});
    private static final DustParticleOptions EFFECT = new DustParticleOptions(Float3.X_AXIS.toVector3(), 1.0f);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty TOP = BooleanProperty.create((String)"top");
    private final ItemStack requiredItem;
    private final Component requiredItemCountText;
    private final Component requiredItemNameText;

    public BlockStatueRespawner() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)NetherBlocks.CINCINNASITE_BLOCK).lightLevel(state -> 15).noOcclusion());
        this.setRenderLayer(BNRenderLayer.CUTOUT);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)TOP, (Comparable)Boolean.valueOf(false)));
        this.setDropItself(false);
        Item item = (Item)BuiltInRegistries.ITEM.get(BuiltInRegistries.ITEM.getKey((Object)Items.GLOWSTONE));
        if (item == Items.AIR) {
            item = Items.GLOWSTONE;
        }
        int count = 4;
        this.requiredItem = new ItemStack((ItemLike)item, count);
        this.requiredItemCountText = Component.literal((String)Integer.toString(count));
        this.requiredItemNameText = this.requiredItem.getHoverName();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{FACING, TOP});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPE;
    }

    public VoxelShape getOcclusionShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return CULL_SHAPE;
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() == this.requiredItem.getItem() && stack.getCount() >= this.requiredItem.getCount()) {
            float y;
            float f = y = (Boolean)state.getValue((Property)TOP) != false ? 0.4f : 1.4f;
            if (!player.isCreative()) {
                player.getMainHandItem().shrink(this.requiredItem.getCount());
            }
            for (int i = 0; i < 50; ++i) {
                world.addParticle((ParticleOptions)EFFECT, (double)((float)pos.getX() + world.random.nextFloat()), (double)((float)pos.getY() + y) + (double)world.random.nextFloat() * 0.2, (double)((float)pos.getZ() + world.random.nextFloat()), 0.0, 0.0, 0.0);
            }
            player.displayClientMessage((Component)Component.translatable((String)"message.spawn_set", (Object[])new Object[0]), true);
            if (!world.isClientSide) {
                ((ServerPlayer)player).setRespawnPosition(world.dimension(), pos, player.getYHeadRot(), true, false);
            }
            player.playSound(SoundEvents.TOTEM_USE, 0.7f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        player.displayClientMessage((Component)Component.translatable((String)"message.spawn_help", (Object[])new Object[]{this.requiredItemCountText, this.requiredItemNameText}), true);
        return InteractionResult.SUCCESS;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (((Boolean)state.getValue((Property)TOP)).booleanValue()) {
            return true;
        }
        BlockState up = world.getBlockState(pos.above());
        return up.isAir() || up.getBlock() == this && (Boolean)up.getValue((Property)TOP) != false;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        if (!world.isClientSide()) {
            BlocksHelper.setWithUpdate((LevelAccessor)world, pos.above(), (BlockState)state.setValue((Property)TOP, (Comparable)Boolean.valueOf(true)));
        }
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)TOP)).booleanValue()) {
            return world.getBlockState(pos.below()).getBlock() == this ? state : Blocks.AIR.defaultBlockState();
        }
        return world.getBlockState(pos.above()).getBlock() == this ? state : Blocks.AIR.defaultBlockState();
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return BlocksHelper.rotateHorizontal(state, rotation, (Property<Direction>)FACING);
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return BlocksHelper.mirrorHorizontal(state, mirror, (Property<Direction>)FACING);
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (player.isCreative() && ((Boolean)state.getValue((Property)TOP)).booleanValue() && world.getBlockState(pos.below()).getBlock() == this) {
            world.setBlockAndUpdate(pos.below(), Blocks.AIR.defaultBlockState());
        }
        return super.playerWillDestroy(world, pos, state, player);
    }
}

