/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.blocks.materials.Materials;

public class BlockStem
extends BlockBaseNotFull
implements BehaviourWood {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    private static final EnumMap<Direction.Axis, VoxelShape> OUTLINES = Maps.newEnumMap(Direction.Axis.class);

    public BlockStem(MapColor color) {
        super(Materials.makeNetherWood(color).strength(0.5f).noOcclusion());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)Direction.Axis.Y));
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return OUTLINES.get(state.getValue(AXIS));
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return OUTLINES.get(state.getValue(AXIS));
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.getValue(AXIS)) {
                    case X: {
                        return (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        return (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)ctx.getClickedFace().getAxis());
    }

    static {
        OUTLINES.put(Direction.Axis.X, BlockStem.box((double)0.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0));
        OUTLINES.put(Direction.Axis.Y, BlockStem.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0));
        OUTLINES.put(Direction.Axis.Z, BlockStem.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)16.0));
    }
}

