/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraft.world.phys.BlockHitResult;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.blocks.BaseVineBlock;
import org.betterx.bclib.items.tool.BaseShearsItem;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.wover.block.api.BlockProperties;
import org.betterx.wover.loot.api.BlockLootProvider;
import org.betterx.wover.loot.api.LootLookupProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockWhisperingGourdVine
extends BaseVineBlock.Growing
implements BlockLootProvider {
    public BlockWhisperingGourdVine() {
        super(BehaviourBuilders.createStaticVine((MapColor)MapColor.COLOR_RED).randomTicks(), 6, 1, 16);
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack tool = player.getItemInHand(hand);
        if (BaseShearsItem.isShear((ItemStack)tool) && state.getValue((Property)SHAPE) == BlockProperties.TripleShape.MIDDLE) {
            if (!world.isClientSide) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, pos, (BlockState)state.setValue((Property)SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM));
                world.addFreshEntity((Entity)new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)NetherBlocks.WHISPERING_GOURD)));
                if (world.random.nextBoolean()) {
                    world.addFreshEntity((Entity)new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)NetherBlocks.WHISPERING_GOURD)));
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return super.useItemOn(itemStack, state, world, pos, player, hand, hit);
    }

    @Nullable
    public LootTable.Builder registerBlockLoot(@NotNull ResourceLocation location, @NotNull LootLookupProvider provider, @NotNull ResourceKey<LootTable> tableKey) {
        LootItemCondition.Builder fruityState = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)this).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SHAPE, (Comparable)BlockProperties.TripleShape.TOP)).invert();
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)NetherBlocks.WHISPERING_GOURD.asItem()).when((LootItemCondition.Builder)fruityState.and(provider.shearsOrSilkTouchCondition()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).otherwise(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)this.asItem()).when(ExplosionCondition.survivesExplosion())).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)provider.fortune(), (float[])LootLookupProvider.VANILLA_LEAVES_SAPLING_CHANCES)))));
    }
}

