/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks.complex;

import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import org.betterx.bclib.complexmaterials.ComplexMaterial;
import org.betterx.bclib.complexmaterials.WoodenComplexMaterial;
import org.betterx.bclib.complexmaterials.entry.MaterialSlot;
import org.betterx.bclib.complexmaterials.entry.SlotMap;
import org.betterx.bclib.complexmaterials.set.wood.Bookshelf;
import org.betterx.bclib.complexmaterials.set.wood.Planks;
import org.betterx.bclib.complexmaterials.set.wood.WoodSlots;
import org.betterx.bclib.items.boat.BoatTypeOverride;
import org.betterx.betternether.blocks.BlockReedsBlock;
import org.betterx.betternether.blocks.complex.ReedBookshelfBlock;
import org.betterx.betternether.blocks.complex.RoofMaterial;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.recipe.api.CraftingRecipeBuilder;
import org.betterx.wover.recipe.api.RecipeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetherReedMaterial
extends RoofMaterial<NetherReedMaterial> {
    public NetherReedMaterial() {
        super("nether_reed", MapColor.COLOR_CYAN, MapColor.COLOR_CYAN);
        this.setFurnitureCloth(NetherBlocks.NETHER_BRICK_TILE_LARGE);
    }

    @Override
    protected SlotMap<WoodenComplexMaterial> createMaterialSlots() {
        return super.createMaterialSlots().remove(WoodSlots.LOG).remove(WoodSlots.BARK).remove(WoodSlots.STRIPPED_LOG).remove(WoodSlots.STRIPPED_BARK).replace((MaterialSlot)new Planks(){

            @NotNull
            protected Block createBlock(WoodenComplexMaterial parentMaterial, BlockBehaviour.Properties settings) {
                return new BlockReedsBlock();
            }

            @Nullable
            protected void makeRecipe(RecipeOutput context, ComplexMaterial parentMaterial, ResourceLocation id) {
                CraftingRecipeBuilder craftingRecipeBuilder1 = RecipeBuilder.crafting((ResourceLocation)id, (ItemLike)parentMaterial.getBlock(WoodSlots.PLANKS));
                CraftingRecipeBuilder craftingRecipeBuilder2 = craftingRecipeBuilder1.outputCount(1);
                CraftingRecipeBuilder craftingRecipeBuilder = craftingRecipeBuilder2.shape(new String[]{"##", "##"}).addMaterial('#', new ItemLike[]{NetherReedMaterial.this.getStem()});
                CraftingRecipeBuilder craftingRecipeBuilderBaseRecipeBuilder = craftingRecipeBuilder.group("planks");
                ((CraftingRecipeBuilder)craftingRecipeBuilderBaseRecipeBuilder.category(RecipeCategory.BUILDING_BLOCKS)).build(context);
            }
        }).replace((MaterialSlot)new Bookshelf(this){

            @NotNull
            protected Block createBlock(WoodenComplexMaterial parentMaterial, BlockBehaviour.Properties settings) {
                return new ReedBookshelfBlock(parentMaterial.getBlock(WoodSlots.PLANKS));
            }
        });
    }

    @Nullable
    public <M extends ComplexMaterial> Block getBlock(MaterialSlot<M> key) {
        if (key.suffix.equals(WoodSlots.STRIPPED_LOG.suffix)) {
            return this.getStem();
        }
        return super.getBlock(key);
    }

    public Block getStem() {
        return NetherBlocks.NETHER_REED_STEM;
    }

    public BoatTypeOverride supplyBoatType() {
        return BoatTypeOverride.create((ModCore)this.C, (String)this.getBaseName(), (Block)this.getBlock(WoodSlots.PLANKS), (boolean)true);
    }
}

