/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.client.block;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.util.Pair;
import org.betterx.betternether.BetterNether;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;

public class BNModels {
    private static final Map<String, ModelTemplate> TEMPLATES = new HashMap<String, ModelTemplate>();
    public static final ResourceLocation CROP_BLOCK_MODEL_LOCATION = BetterNether.C.mk("block/crop_block");
    public static final ResourceLocation JUNGLE_PLANT_MODEL_LOCATION = BetterNether.C.mk("block/jungle_plant");
    public static final ResourceLocation GRASS_FAN_MODEL_LOCATION = BetterNether.C.mk("block/grass_fan");
    public static final ResourceLocation STAIRS_WITH_TOP_MODEL_LOCATION = BetterNether.C.mk("block/stairs_with_top");
    public static final ModelTemplate STAIRS_WITH_TOP_MODEL = new ModelTemplate(Optional.of(STAIRS_WITH_TOP_MODEL_LOCATION), Optional.empty(), new TextureSlot[]{TextureSlot.TOP, TextureSlot.BOTTOM});

    public static void createComplex(WoverBlockModelGenerators generators, Block bl, List<ModelSource> sources) {
        List<Pair> models = sources.stream().map(s -> {
            Optional parent = s.parent() == null ? Optional.empty() : Optional.of(s.parent());
            Optional suffix = s.suffix() == null || s.suffix().trim().isEmpty() ? Optional.empty() : Optional.of(s.suffix());
            TextureSlot[] slots = (TextureSlot[])s.textures().stream().map(TextureSource::slot).toArray(TextureSlot[]::new);
            TextureMapping mapping = new TextureMapping();
            s.textures.forEach(t -> mapping.put(t.slot(), t.texture()));
            ModelTemplate template = new ModelTemplate(parent, suffix, slots);
            return new Pair(s, (Object)template.create(bl, mapping, generators.modelOutput()));
        }).toList();
        List<ResourceLocation> allModels = models.stream().map(p -> (ResourceLocation)p.second).toList();
        Variant[] variants = (Variant[])models.stream().flatMap(m -> ((ModelSource)m.first).variants().stream().map(f -> f.apply((ResourceLocation)m.second, allModels))).toArray(Variant[]::new);
        generators.acceptBlockState((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)bl, (Variant[])variants));
        Item item = bl.asItem();
        ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)item), TextureMapping.layer0((ResourceLocation)sources.get((int)0).textures.get((int)0).texture), generators.modelOutput());
    }

    public static ModelTemplate getCropBlockModelTemplate(String suffix) {
        return TEMPLATES.computeIfAbsent(CROP_BLOCK_MODEL_LOCATION.toString() + suffix, s -> new ModelTemplate(Optional.of(CROP_BLOCK_MODEL_LOCATION), suffix == null || suffix.trim().isEmpty() ? Optional.empty() : Optional.of(suffix), new TextureSlot[]{TextureSlot.TEXTURE}));
    }

    public static ModelTemplate getCropCrossBlockModelTemplate(String suffix) {
        return TEMPLATES.computeIfAbsent(WoverBlockModelGenerators.CROSS.toString() + suffix, s -> new ModelTemplate(Optional.of(WoverBlockModelGenerators.CROSS), suffix == null || suffix.trim().isEmpty() ? Optional.empty() : Optional.of(suffix), new TextureSlot[]{TextureSlot.CROSS}));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void provideGrassBlockModels(WoverBlockModelGenerators generators, Block bl, String baseName, int count) {
        ArrayList<ModelSource> variants = new ArrayList<ModelSource>(2 * count);
        for (int i = 1; i <= count; ++i) {
            ResourceLocation texture = BetterNether.C.mk("block/" + baseName + "_" + i);
            variants.add(ModelSource.of(WoverBlockModelGenerators.CROSS, "_" + i, List.of((id, all) -> Variant.variant().with(VariantProperties.MODEL, (Object)id)), TextureSource.of(TextureSlot.CROSS, texture)));
            variants.add(ModelSource.of(CROP_BLOCK_MODEL_LOCATION, "_" + (count + i), List.of((id, all) -> Variant.variant().with(VariantProperties.MODEL, (Object)id)), TextureSource.of(TextureSlot.TEXTURE, texture)));
        }
        BNModels.createComplex(generators, bl, variants);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void provideSimpleMultiStateBlock(WoverBlockModelGenerators generators, Block bl, String ... suffixes) {
        String baseName = ModelLocationUtils.getModelLocation((Block)bl).getPath();
        ArrayList<ModelSource> variants = new ArrayList<ModelSource>(suffixes.length);
        for (int i = 1; i <= suffixes.length; ++i) {
            ResourceLocation texture = BetterNether.C.mk(baseName + suffixes[i - 1]);
            variants.add(ModelSource.of(WoverBlockModelGenerators.CUBE_ALL, suffixes[i - 1], List.of((id, all) -> Variant.variant().with(VariantProperties.MODEL, (Object)id)), TextureSource.of(TextureSlot.ALL, texture)));
        }
        BNModels.createComplex(generators, bl, variants);
    }

    public record ModelSource(ResourceLocation parent, String suffix, List<VariantSupplier> variants, List<TextureSource> textures) {
        public static ModelSource of(ResourceLocation parent, String suffix, List<VariantSupplier> variants, TextureSource ... textures) {
            return new ModelSource(parent, suffix, variants, Arrays.asList(textures));
        }
    }

    public record TextureSource(TextureSlot slot, ResourceLocation texture) {
        public static TextureSource of(TextureSlot slot, ResourceLocation texture) {
            return new TextureSource(slot, texture);
        }
    }

    public static interface VariantSupplier {
        public Variant apply(ResourceLocation var1, List<ResourceLocation> var2);
    }
}

