/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.entity;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.betterx.bclib.entity.DespawnableAnimal;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.registry.NetherEntities;
import org.betterx.betternether.registry.NetherTags;
import org.betterx.betternether.registry.SoundsRegistry;
import org.betterx.ui.ColorUtil;
import org.jetbrains.annotations.NotNull;

public class EntityFirefly
extends DespawnableAnimal
implements FlyingAnimal {
    private static final Vec3i[] SEARCH;
    private static final EntityDataAccessor<Integer> COLOR;
    private boolean mustSit = false;

    public EntityFirefly(EntityType<? extends EntityFirefly> type, Level world) {
        super(type, world);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.lookControl = new FreflyLookControl(this, (Mob)this);
        this.setPathfindingMalus(PathType.LAVA, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
        this.xpReward = 1;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COLOR, (Object)this.makeColor(this.random.nextFloat(), this.random.nextFloat() * 0.5f + 0.25f, 1.0f));
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 1.0).add(Attributes.FLYING_SPEED, 0.6).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FOLLOW_RANGE, 48.0);
    }

    protected PathNavigation createNavigation(final Level world) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation(this, (Mob)this, world){

            public boolean isStableDestination(BlockPos pos) {
                boolean valid;
                BlockState state = this.level.getBlockState(pos.below());
                boolean bl = valid = !state.isAir() && !world.getFluidState(pos.below()).is(FluidTags.LAVA);
                if (valid) {
                    state = this.level.getBlockState(pos);
                    valid = state.isAir() || !state.blocksMotion();
                    valid = valid && state.getBlock() != NetherBlocks.EGG_PLANT;
                    valid = valid && !state.blocksMotion();
                }
                return valid;
            }

            public void tick() {
                super.tick();
            }
        };
        birdNavigation.setCanOpenDoors(false);
        birdNavigation.setCanFloat(false);
        birdNavigation.setCanPassDoors(true);
        return birdNavigation;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new SittingGoal());
        this.goalSelector.addGoal(5, (Goal)new MoveToFlowersGoal());
        this.goalSelector.addGoal(6, (Goal)new WanderAroundGoal());
        this.goalSelector.addGoal(7, (Goal)new MoveRandomGoal());
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader worldView) {
        return worldView.getBlockState(pos).isAir() ? 10.0f : 0.0f;
    }

    public boolean isFood(ItemStack stack) {
        return stack.getItem() == Items.GLOWSTONE_DUST;
    }

    protected boolean isFlapping() {
        return true;
    }

    protected void jumpInLiquid(TagKey<Fluid> fluid) {
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.01, 0.0));
    }

    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, @NotNull DamageSource damageSource) {
        return false;
    }

    protected void checkFallDamage(double heightDifference, boolean onGround, @NotNull BlockState landedState, @NotNull BlockPos landedPosition) {
    }

    public boolean isNoGravity() {
        return true;
    }

    public int getColor() {
        return (Integer)this.entityData.get(COLOR);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("color", this.getColor());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        int color = -1;
        if (tag.contains("color")) {
            color = tag.getInt("color");
        } else if (tag.contains("ColorRed") && tag.contains("ColorGreen") && tag.contains("ColorBlue")) {
            float r = tag.getFloat("ColorRed");
            float g = tag.getFloat("ColorGreen");
            float b = tag.getFloat("ColorBlue");
            color = ColorUtil.color((int)((int)(r * 255.0f)), (int)((int)(g * 255.0f)), (int)((int)(g * 255.0f)));
        }
        this.entityData.set(COLOR, (Object)color);
    }

    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob mate) {
        return (AgeableMob)NetherEntities.FIREFLY.type().create((Level)world);
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    private void checkMovement() {
        Vec3 vel = this.getDeltaMovement();
        if (Math.abs(vel.x) > 0.1 || Math.abs(vel.z) > 0.1) {
            double d = Math.abs(this.xo - this.getX());
            if ((d += Math.abs(this.zo - this.getZ())) < 0.1) {
                this.navigation.stop();
            }
        }
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)SoundsRegistry.MOB_FIREFLY_FLY.value();
    }

    protected float getSoundVolume() {
        return MHelper.randRange(0.1f, 0.3f, this.random);
    }

    private int makeColor(float hue, float saturation, float brightness) {
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        float f3 = (hue - (float)Math.floor(hue)) * 6.0f;
        float f4 = f3 - (float)Math.floor(f3);
        float f5 = brightness * (1.0f - saturation);
        float f6 = brightness * (1.0f - saturation * f4);
        float f7 = brightness * (1.0f - saturation * (1.0f - f4));
        switch ((int)f3) {
            case 0: {
                red = (byte)(brightness * 255.0f + 0.5f);
                green = (byte)(f7 * 255.0f + 0.5f);
                blue = (byte)(f5 * 255.0f + 0.5f);
                break;
            }
            case 1: {
                red = (byte)(f6 * 255.0f + 0.5f);
                green = (byte)(brightness * 255.0f + 0.5f);
                blue = (byte)(f5 * 255.0f + 0.5f);
                break;
            }
            case 2: {
                red = (byte)(f5 * 255.0f + 0.5f);
                green = (byte)(brightness * 255.0f + 0.5f);
                blue = (byte)(f7 * 255.0f + 0.5f);
                break;
            }
            case 3: {
                red = (byte)(f5 * 255.0f + 0.5f);
                green = (byte)(f6 * 255.0f + 0.5f);
                blue = (byte)(brightness * 255.0f + 0.5f);
                break;
            }
            case 4: {
                red = (byte)(f7 * 255.0f + 0.5f);
                green = (byte)(f5 * 255.0f + 0.5f);
                blue = (byte)(brightness * 255.0f + 0.5f);
                break;
            }
            case 5: {
                red = (byte)(brightness * 255.0f + 0.5f);
                green = (byte)(f5 * 255.0f + 0.5f);
                blue = (byte)(f6 * 255.0f + 0.5f);
            }
        }
        return ColorUtil.color((int)((int)red), (int)((int)green), (int)((int)blue));
    }

    public int getMaxSpawnClusterSize() {
        return 5;
    }

    public static boolean canSpawn(EntityType<? extends EntityFirefly> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        if (pos.getY() < world.dimensionType().minY()) {
            return false;
        }
        int h = BlocksHelper.downRay(world, pos, 10);
        if (h > 8) {
            return false;
        }
        for (int i = 1; i <= h; ++i) {
            if (!org.betterx.bclib.util.BlocksHelper.isLava((BlockState)world.getBlockState(pos.below(i)))) continue;
            return false;
        }
        return true;
    }

    public boolean isPushable() {
        return false;
    }

    static {
        COLOR = SynchedEntityData.defineId(EntityFirefly.class, (EntityDataSerializer)EntityDataSerializers.INT);
        ArrayList<Vec3i> points = new ArrayList<Vec3i>();
        int radius = 6;
        int r2 = radius * radius;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    if (x * x + y * y + z * z > r2) continue;
                    points.add(new Vec3i(x, y, z));
                }
            }
        }
        points.sort(new Comparator<Vec3i>(){

            @Override
            public int compare(Vec3i v1, Vec3i v2) {
                int d1 = v1.getX() * v1.getX() + v1.getY() * v1.getY() + v1.getZ() * v1.getZ();
                int d2 = v2.getX() * v2.getX() + v2.getY() * v2.getY() + v2.getZ() * v2.getZ();
                return d1 - d2;
            }
        });
        SEARCH = points.toArray(new Vec3i[0]);
    }

    class FreflyLookControl
    extends LookControl {
        FreflyLookControl(EntityFirefly this$0, Mob entity) {
            super(entity);
        }

        protected boolean resetXRotOnTick() {
            return true;
        }
    }

    class SittingGoal
    extends Goal {
        int timer;
        int ammount;

        SittingGoal() {
        }

        public boolean canUse() {
            if (EntityFirefly.this.mustSit && EntityFirefly.this.navigation.isDone()) {
                BlockPos pos = new BlockPos((int)EntityFirefly.this.getX(), (int)EntityFirefly.this.getY(), (int)EntityFirefly.this.getZ());
                BlockState state = EntityFirefly.this.level().getBlockState(pos.below());
                return !state.isAir() && !state.liquid();
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.timer < this.ammount;
        }

        public void start() {
            this.timer = 0;
            this.ammount = EntityFirefly.this.random.nextInt(21) + 20;
            EntityFirefly.this.mustSit = false;
            EntityFirefly.this.setDeltaMovement(0.0, -0.1, 0.0);
            super.start();
        }

        public void stop() {
            EntityFirefly.this.setDeltaMovement(0.0, 0.1, 0.0);
            super.stop();
        }

        public void tick() {
            ++this.timer;
            super.tick();
        }
    }

    class MoveToFlowersGoal
    extends Goal {
        MoveToFlowersGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return EntityFirefly.this.navigation.isDone() && EntityFirefly.this.random.nextInt(30) == 0;
        }

        public boolean canContinueToUse() {
            return EntityFirefly.this.navigation.isInProgress();
        }

        public void start() {
            BlockPos pos = this.getFlowerLocation();
            if (pos != null) {
                Path path = EntityFirefly.this.navigation.createPath(new BlockPos((Vec3i)pos), 1);
                EntityFirefly.this.navigation.moveTo(path, 1.0);
            }
            super.start();
        }

        public void stop() {
            if (this.isFlower(EntityFirefly.this.getInBlockState())) {
                EntityFirefly.this.mustSit = true;
            }
            super.stop();
        }

        private BlockPos getFlowerLocation() {
            Level w = EntityFirefly.this.level();
            BlockPos.MutableBlockPos bpos = new BlockPos.MutableBlockPos();
            for (Vec3i offset : SEARCH) {
                bpos.set(EntityFirefly.this.getX() + (double)offset.getX(), EntityFirefly.this.getY() + (double)offset.getY(), EntityFirefly.this.getZ() + (double)offset.getZ());
                if (!this.isFlower(w.getBlockState((BlockPos)bpos))) continue;
                return bpos;
            }
            return null;
        }

        private boolean isFlower(BlockState state) {
            return state.is(NetherTags.FIREFLY_FLOWERS);
        }

        public void tick() {
            EntityFirefly.this.checkMovement();
            super.tick();
        }
    }

    class WanderAroundGoal
    extends Goal {
        WanderAroundGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return EntityFirefly.this.navigation.isDone() && EntityFirefly.this.random.nextInt(10) == 0;
        }

        public boolean canContinueToUse() {
            return EntityFirefly.this.navigation.isInProgress();
        }

        public void start() {
            BlockPos pos = this.getRandomLocation();
            Path path = EntityFirefly.this.navigation.createPath(pos, 1);
            if (path != null) {
                EntityFirefly.this.navigation.moveTo(path, 1.0);
            } else {
                EntityFirefly.this.setDeltaMovement(0.0, -0.2, 0.0);
            }
            super.start();
        }

        private BlockPos getRandomLocation() {
            Level w = EntityFirefly.this.level();
            BlockPos.MutableBlockPos bpos = new BlockPos.MutableBlockPos();
            bpos.set(EntityFirefly.this.getX(), EntityFirefly.this.getY(), EntityFirefly.this.getZ());
            if (w.isEmptyBlock(bpos.below(2)) && w.isEmptyBlock(bpos.below())) {
                int y = bpos.getY() - 1;
                while (w.isEmptyBlock(bpos.below(2)) && y > 0) {
                    bpos.setY(y--);
                }
                return bpos;
            }
            Vec3 angle = EntityFirefly.this.getViewVector(0.0f);
            Vec3 airTarget = HoverRandomPos.getPos((PathfinderMob)EntityFirefly.this, (int)8, (int)7, (double)angle.x, (double)angle.z, (float)1.5707964f, (int)2, (int)1);
            if (airTarget == null) {
                airTarget = HoverRandomPos.getPos((PathfinderMob)EntityFirefly.this, (int)16, (int)10, (double)angle.x, (double)angle.z, (float)1.5707964f, (int)3, (int)1);
            }
            if (airTarget == null) {
                bpos.setX(bpos.getX() + this.randomRange(8));
                bpos.setZ(bpos.getZ() + this.randomRange(8));
                bpos.setY(bpos.getY() + this.randomRange(2));
                return bpos;
            }
            bpos.set(airTarget.x(), airTarget.y(), airTarget.z());
            return bpos;
        }

        private int randomRange(int side) {
            RandomSource random = EntityFirefly.this.random;
            return random.nextInt(side + 1) - (side >> 1);
        }

        public void tick() {
            EntityFirefly.this.checkMovement();
            super.tick();
        }
    }

    class MoveRandomGoal
    extends Goal {
        int timer;
        int ammount;

        MoveRandomGoal() {
        }

        public boolean canUse() {
            return EntityFirefly.this.navigation.isDone() && EntityFirefly.this.random.nextInt(20) == 0;
        }

        public boolean canContinueToUse() {
            return this.timer < this.ammount;
        }

        public void start() {
            this.timer = 0;
            this.ammount = EntityFirefly.this.random.nextInt(30) + 10;
            Vec3 velocity = new Vec3(EntityFirefly.this.random.nextDouble(), EntityFirefly.this.random.nextDouble(), EntityFirefly.this.random.nextDouble());
            if (velocity.lengthSqr() == 0.0) {
                velocity = new Vec3(1.0, 0.0, 0.0);
            }
            EntityFirefly.this.setDeltaMovement(velocity.normalize().scale((double)EntityFirefly.this.getFlyingSpeed()));
            super.start();
        }

        public void tick() {
            ++this.timer;
            super.tick();
        }
    }
}

