/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.entity;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class EntityJungleSkeleton
extends Skeleton {
    public EntityJungleSkeleton(EntityType<? extends Skeleton> entityType, Level world) {
        super(entityType, world);
    }

    public void aiStep() {
        this.updateSwingTime();
        this.updateNoActionTime();
        super.aiStep();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        entityData = super.finalizeSpawn(level, difficulty, spawnReason, entityData);
        RandomSource randomSource = level.getRandom();
        super.populateDefaultEquipmentSlots(randomSource, difficulty);
        this.setItemSlot(EquipmentSlot.MAINHAND, this.getHandItem());
        this.setItemSlot(EquipmentSlot.OFFHAND, this.getRandomOffhandItem());
        this.populateDefaultEquipmentEnchantments(level, randomSource, difficulty);
        this.reassessWeaponGoal();
        this.setCanPickUpLoot(this.random.nextFloat() < 0.55f * difficulty.getSpecialMultiplier());
        if (this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            LocalDate localDate = LocalDate.now();
            int i = localDate.get(ChronoField.DAY_OF_MONTH);
            int j = localDate.get(ChronoField.MONTH_OF_YEAR);
            if (j == 10 && i == 31 && this.random.nextFloat() < 0.25f) {
                this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)(this.random.nextFloat() < 0.1f ? Blocks.JACK_O_LANTERN : Blocks.CARVED_PUMPKIN)));
                this.armorDropChances[EquipmentSlot.HEAD.getIndex()] = 0.0f;
            }
        }
        return entityData;
    }

    private ItemStack getHandItem() {
        int n = this.random.nextInt(3);
        switch (n) {
            default: {
                return new ItemStack((ItemLike)(this.random.nextBoolean() ? Items.WOODEN_SWORD : Items.STONE_SWORD));
            }
            case 1: {
                return new ItemStack((ItemLike)Items.BOW);
            }
            case 2: 
        }
        return new ItemStack((ItemLike)Items.AIR);
    }

    private ItemStack getRandomOffhandItem() {
        return this.random.nextInt(8) == 0 ? new ItemStack((ItemLike)Items.SHIELD) : new ItemStack((ItemLike)Items.AIR);
    }
}

