/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.entity;

import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.betternether.entity.EntityNaga;

public class EntityNagaProjectile
extends FlyingMob {
    private static final int MAX_LIFE_TIME = 60;
    private int lifeTime = 0;

    public EntityNagaProjectile(EntityType<? extends EntityNagaProjectile> type, Level world) {
        super(type, world);
        this.xpReward = 0;
    }

    public void setParams(LivingEntity owner, Entity target) {
        this.setPos(this.getX(), this.getEyeY() - (double)this.getBbHeight(), this.getZ());
        Vec3 dir = target.position().add(0.0, (double)target.getBbHeight() * 0.25, 0.0).subtract(this.position()).normalize().scale(2.0);
        this.setDeltaMovement(dir);
        this.xo = this.getX() - dir.x;
        this.yo = this.getY() - dir.y;
        this.zo = this.getZ() - dir.z;
    }

    public boolean isNoGravity() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderAtSqrDistance(double distance) {
        return distance < 128.0;
    }

    public void tick() {
        super.tick();
        this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getX() + this.random.nextGaussian() * 0.2, this.getY() + this.random.nextGaussian() * 0.2, this.getZ() + this.random.nextGaussian() * 0.2, 0.0, 0.0, 0.0);
        this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX() + this.random.nextGaussian() * 0.2, this.getY() + this.random.nextGaussian() * 0.2, this.getZ() + this.random.nextGaussian() * 0.2, 0.0, 0.0, 0.0);
        HitResult hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, entity -> entity.isAlive() && entity instanceof LivingEntity);
        if (hitResult.getType() != HitResult.Type.MISS) {
            this.onCollision(hitResult);
        }
        ++this.lifeTime;
        if (this.lifeTime > 60) {
            this.effectKill();
        }
        if (this.isSame(this.xo, this.getX()) && this.isSame(this.yo, this.getY()) && this.isSame(this.zo, this.getZ())) {
            this.effectKill();
        }
    }

    private boolean isSame(double a, double b) {
        return Math.abs(a - b) < 0.1;
    }

    protected void onCollision(HitResult hitResult) {
        Entity entity;
        HitResult.Type type = hitResult.getType();
        if (type == HitResult.Type.BLOCK) {
            for (int i = 0; i < 10; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getX() + this.random.nextGaussian() * 0.5, this.getY() + this.random.nextGaussian() * 0.5, this.getZ() + this.random.nextGaussian() * 0.5, this.random.nextGaussian() * 0.2, this.random.nextGaussian() * 0.2, this.random.nextGaussian() * 0.2);
            }
            this.effectKill();
        } else if (type == HitResult.Type.ENTITY && (entity = ((EntityHitResult)hitResult).getEntity()) != this && entity instanceof LivingEntity && !(entity instanceof EntityNaga)) {
            LivingEntity living = (LivingEntity)entity;
            if (!living.hasEffect(MobEffects.WITHER)) {
                living.addEffect(new MobEffectInstance(MobEffects.WITHER, 200, 1));
                living.hurt(living.damageSources().generic(), 1.0f);
            }
            this.effectKill();
        }
    }

    private void effectKill() {
        for (int i = 0; i < 10; ++i) {
            this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)-1), this.getX() + this.random.nextGaussian() * 0.5, this.getY() + this.random.nextGaussian() * 0.5, this.getZ() + this.random.nextGaussian() * 0.5, 0.1, 0.1, 0.1);
        }
        this.kill();
    }

    public boolean canBeAffected(MobEffectInstance effect) {
        return false;
    }

    public boolean isSilent() {
        return true;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("life", this.lifeTime);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("life")) {
            this.lifeTime = tag.getInt("life");
        }
    }
}

