/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.entity.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import org.betterx.betternether.entity.EntityFlyingPig;

public class ModelEntityFlyingPig
extends AgeableListModel<EntityFlyingPig> {
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightWing;
    private final ModelPart leftWing;
    private final ModelPart rightWingTip;
    private final ModelPart leftWingTip;
    private final ModelPart tail;
    private final ModelPart legA;
    private final ModelPart legB;

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition modelPartData_HEAD = modelPartData.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        modelPartData_HEAD.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(32, 4).addBox(0.0f, 0.0f, 0.0f, 5.0f, 5.0f, 1.0f), PartPose.offset((float)-7.0f, (float)-7.0f, (float)-2.0f));
        modelPartData_HEAD.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(32, 4).mirror(true).addBox(0.0f, 0.0f, 0.0f, 5.0f, 5.0f, 1.0f), PartPose.offset((float)2.0f, (float)-7.0f, (float)-2.0f));
        modelPartData_HEAD.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(32, 0).addBox(0.0f, 0.0f, 0.0f, 4.0f, 3.0f, 1.0f), PartPose.offset((float)-2.0f, (float)-1.0f, (float)-5.0f));
        PartDefinition modelPartData_BODY = modelPartData.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-5.0f, 3.0f, -4.0f, 10.0f, 14.0f, 8.0f), PartPose.ZERO);
        PartDefinition modelPartData_RW = modelPartData_BODY.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(36, 10).addBox(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 0.0f), PartPose.offset((float)5.0f, (float)2.5f, (float)0.0f));
        modelPartData_RW.addOrReplaceChild("right_wing_tip", CubeListBuilder.create().texOffs(36, 26).addBox(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 0.0f), PartPose.offset((float)16.0f, (float)0.0f, (float)0.0f));
        PartDefinition modelPartData_LW = modelPartData_BODY.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(36, 10).mirror(true).addBox(-16.0f, 0.0f, 0.0f, 16.0f, 16.0f, 0.0f), PartPose.offset((float)-5.0f, (float)2.5f, (float)0.0f));
        modelPartData_LW.addOrReplaceChild("left_wing_tip", CubeListBuilder.create().texOffs(36, 26).mirror(true).addBox(-16.0f, 0.0f, 0.0f, 16.0f, 16.0f, 0.0f), PartPose.offset((float)-16.0f, (float)0.0f, (float)0.0f));
        modelPartData_BODY.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 40).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 8.0f, 0.0f), PartPose.offset((float)0.0f, (float)17.0f, (float)0.0f));
        modelPartData_BODY.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 48).addBox(0.0f, 0.0f, 0.0f, 3.0f, 6.0f, 3.0f), PartPose.offset((float)1.5f, (float)15.0f, (float)-4.0f));
        modelPartData_BODY.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 48).addBox(0.0f, 0.0f, 0.0f, 3.0f, 6.0f, 3.0f), PartPose.offset((float)-4.5f, (float)15.0f, (float)-4.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)128, (int)64);
    }

    public ModelEntityFlyingPig(ModelPart root) {
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.tail = this.body.getChild("tail");
        this.rightWing = this.body.getChild("right_wing");
        this.rightWingTip = this.rightWing.getChild("right_wing_tip");
        this.legA = this.body.getChild("right_leg");
        this.leftWing = this.body.getChild("left_wing");
        this.leftWingTip = this.leftWing.getChild("left_wing_tip");
        this.legB = this.body.getChild("left_leg");
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body);
    }

    public void setupAnim(EntityFlyingPig entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        if (entity.isRoosting()) {
            this.head.xRot = headPitch * ((float)Math.PI / 180);
            this.head.yRot = (float)Math.PI - headYaw * ((float)Math.PI / 180);
            this.head.zRot = (float)Math.PI;
            this.body.xRot = (float)Math.PI;
            this.rightWing.xRot = 0.0f;
            this.rightWing.yRot = -1.2566371f;
            this.rightWingTip.yRot = 2.8f;
            this.leftWing.xRot = this.rightWing.xRot;
            this.leftWing.yRot = -this.rightWing.yRot;
            this.leftWingTip.yRot = -this.rightWingTip.yRot;
            this.head.setPos(0.0f, 25.0f, 0.0f);
            this.body.setPos(0.0f, 24.0f, 0.0f);
            this.legA.xRot = 0.0f;
            this.legB.xRot = 0.0f;
            this.tail.xRot = 0.1f;
            this.legA.setPos(1.5f, 15.0f, -3.0f);
            this.legB.setPos(-4.5f, 15.0f, -3.0f);
        } else {
            this.head.xRot = headPitch * ((float)Math.PI / 180);
            this.head.yRot = headYaw * ((float)Math.PI / 180);
            this.head.zRot = 0.0f;
            this.body.xRot = 0.7853982f + Mth.cos((float)(animationProgress * 0.1f)) * 0.15f;
            this.body.yRot = 0.0f;
            this.rightWing.yRot = Mth.cos((float)(animationProgress * 0.4f)) * (float)Math.PI * 0.25f;
            this.leftWing.yRot = -this.rightWing.yRot;
            this.rightWingTip.yRot = this.rightWing.yRot * 0.75f;
            this.leftWingTip.yRot = -this.rightWing.yRot * 0.75f;
            this.tail.xRot = Mth.cos((float)(animationProgress * 0.3f)) * 0.25f;
            this.legA.xRot = -this.body.xRot + Mth.sin((float)(animationProgress * 0.05f)) * 0.1f;
            this.legB.xRot = -this.body.xRot + Mth.cos((float)(animationProgress * 0.05f)) * 0.1f;
            this.head.setPos(0.0f, 8.0f, 0.0f);
            this.body.setPos(0.0f, 8.0f, 0.0f);
            this.legA.setPos(1.5f, 15.0f, -4.0f);
            this.legB.setPos(-4.5f, 15.0f, -4.0f);
        }
    }
}

