/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.entity.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import org.betterx.betternether.entity.EntityHydrogenJellyfish;

public class ModelEntityHydrogenJellyfish
extends AgeableListModel<EntityHydrogenJellyfish> {
    public static final String BODY_TOP = "body_top";
    private static final double HALF_PI = 1.5707963267948966;
    private static final int LEGS = 8;
    private final ModelPart body;
    private final ModelPart[] legs_1;
    private final ModelPart[] legs_2;
    private final ModelPart[] legs_3;
    private final ModelPart[] wings;

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition bodyPart = modelPartData.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-14.0f, 0.0f, -14.0f, 28.0f, 18.0f, 28.0f), PartPose.offset((float)0.0f, (float)-48.0f, (float)0.0f));
        bodyPart.addOrReplaceChild(BODY_TOP, CubeListBuilder.create().texOffs(0, 46).addBox(-10.0f, 0.0f, -10.0f, 20.0f, 6.0f, 20.0f), PartPose.offset((float)0.0f, (float)-6.0f, (float)0.0f));
        for (int i = 0; i < 8; ++i) {
            int li = i * 3;
            float angle = (float)((double)i * Math.PI * 2.0 / 8.0);
            float x = (float)Math.sin(angle) * 10.0f;
            float z = (float)Math.cos(angle) * 10.0f;
            PartDefinition modelPartData_LEG_1 = bodyPart.addOrReplaceChild("leg_1_" + i, CubeListBuilder.create().texOffs(60, 46).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 14.0f, 6.0f), PartPose.offsetAndRotation((float)x, (float)18.0f, (float)z, (float)0.0f, (float)angle, (float)0.0f));
            modelPartData_LEG_1.addOrReplaceChild("leg_det_" + li, CubeListBuilder.create().texOffs(97, 46).addBox(-8.0f, 0.0f, 0.0f, 16.0f, 14.0f, 0.0f).texOffs(97, 30).addBox(0.0f, 0.0f, -8.0f, 0.0f, 14.0f, 16.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)angle, (float)0.0f));
            PartDefinition modelPartData_LEG_2 = modelPartData_LEG_1.addOrReplaceChild("leg_2_" + i, CubeListBuilder.create().texOffs(0, 72).addBox(-2.0f, -24.0f, -2.0f, 4.0f, 28.0f, 4.0f), PartPose.offset((float)0.0f, (float)14.0f, (float)0.0f));
            modelPartData_LEG_2.addOrReplaceChild("leg_det_" + ++li, CubeListBuilder.create().texOffs(98, 60).addBox(-7.0f, -24.0f, 0.0f, 14.0f, 28.0f, 0.0f).texOffs(98, 48).addBox(0.0f, -24.0f, -7.0f, 0.0f, 28.0f, 14.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(45.0)), (float)0.0f));
            PartDefinition modelPartData_LEG_3 = modelPartData_LEG_2.addOrReplaceChild("leg_3_" + i, CubeListBuilder.create().texOffs(16, 72).addBox(-1.0f, -24.0f, -1.0f, 2.0f, 28.0f, 2.0f), PartPose.offset((float)0.0f, (float)-28.0f, (float)0.0f));
            modelPartData_LEG_3.addOrReplaceChild("leg_det_" + ++li, CubeListBuilder.create().texOffs(99, 88).addBox(-6.0f, -28.0f, 0.0f, 12.0f, 32.0f, 0.0f).texOffs(99, 76).addBox(0.0f, -28.0f, -6.0f, 0.0f, 32.0f, 12.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(45.0)), (float)0.0f));
            x = (float)Math.sin(angle);
            z = (float)Math.cos(angle);
            x = Math.signum(x) * (float)Math.pow(Math.abs(x), 0.25);
            z = Math.signum(z) * (float)Math.pow(Math.abs(z), 0.25);
            bodyPart.addOrReplaceChild("wing_" + i, CubeListBuilder.create().texOffs(60, 4).addBox(-12.0f, 0.0f, 0.0f, 24.0f, 0.0f, 24.0f), PartPose.offsetAndRotation((float)(x *= 12.0f), (float)(12 - (i & 1) * 6), (float)(z *= 12.0f), (float)0.0f, (float)angle, (float)0.0f));
        }
        return LayerDefinition.create((MeshDefinition)modelData, (int)128, (int)128);
    }

    public ModelEntityHydrogenJellyfish(ModelPart root) {
        this.body = root.getChild("body");
        this.legs_1 = new ModelPart[8];
        this.legs_2 = new ModelPart[8];
        this.legs_3 = new ModelPart[8];
        this.wings = new ModelPart[8];
        for (int i = 0; i < 8; ++i) {
            this.legs_1[i] = this.body.getChild("leg_1_" + i);
            this.legs_2[i] = this.legs_1[i].getChild("leg_2_" + i);
            this.legs_3[i] = this.legs_2[i].getChild("leg_3_" + i);
            this.wings[i] = this.body.getChild("wing_" + i);
        }
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body);
    }

    public void setupAnim(EntityHydrogenJellyfish entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        double sinIn;
        int i;
        double time = (double)animationProgress * 0.03;
        this.body.setPos(0.0f, (float)Math.sin(time) * 8.0f - 42.0f, 0.0f);
        double sin1 = Math.sin(time);
        double sin2 = Math.sin(time + 1.5707963267948966);
        for (i = 0; i < 8; ++i) {
            sinIn = (i & 1) == 0 ? sin1 : sin2;
            double rot = 10 + (i + 1 & 1) * 10;
            this.legs_1[i].xRot = (float)Math.toRadians(rot + (sinIn *= 10.0) + 10.0);
            this.legs_2[i].xRot = (float)Math.toRadians(180.0 - rot + sinIn + 5.0);
            this.legs_3[i].xRot = (float)Math.toRadians(sinIn);
        }
        time = (double)System.currentTimeMillis() * 6.0E-4;
        sin1 = Math.sin(time);
        sin2 = Math.sin(time + 1.5707963267948966);
        for (i = 0; i < 8; ++i) {
            sinIn = (i & 1) == 0 ? sin1 : sin2;
            this.wings[i].xRot = (float)Math.toRadians(sinIn * 20.0 - 20.0);
        }
    }
}

