/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.entity.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;
import org.betterx.betternether.entity.EntitySkull;

public class ModelSkull
extends AgeableListModel<EntitySkull> {
    private final ModelPart head;
    private float pitch;

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        modelPartData.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.offset((float)0.0f, (float)20.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)32, (int)16);
    }

    public ModelSkull(ModelPart root) {
        this.head = root.getChild("head");
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of();
    }

    public void prepareMobModel(EntitySkull livingEntity, float f, float g, float h) {
        this.pitch = livingEntity.getSwimAmount(h);
        super.prepareMobModel((Entity)livingEntity, f, g, h);
    }

    public void setupAnim(EntitySkull entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        boolean rollTooBig = entity.getFallFlyingTicks() > 4;
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.head.xRot = rollTooBig ? -0.7853982f : (this.pitch > 0.0f ? this.lerpAngle(this.head.xRot, headPitch * ((float)Math.PI / 180), this.pitch) : headPitch * ((float)Math.PI / 180));
    }

    protected float lerpAngle(float from, float to, float position) {
        float angle = (to - from) % ((float)Math.PI * 2);
        if (angle < (float)(-Math.PI)) {
            angle += (float)Math.PI * 2;
        }
        if (angle >= (float)Math.PI) {
            angle -= (float)Math.PI * 2;
        }
        return from + position * angle;
    }
}

