/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.entity.render;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.preprocessor.GlslPreprocessor;
import com.mojang.blaze3d.shaders.Program;
import com.mojang.blaze3d.shaders.Shader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Set;
import net.minecraft.FileUtil;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.apache.commons.io.IOUtils;

class DebugShader
extends ShaderInstance {
    private static Program vertexShader;
    private static Program fragmentShader;

    private static String doInit(ResourceProvider factory, String baseName) {
        try {
            System.out.println("Reloading Shader");
            vertexShader = DebugShader.getOrCreate(factory, Program.Type.VERTEX, "bn_debug");
            fragmentShader = DebugShader.getOrCreate(factory, Program.Type.FRAGMENT, "bn_debug");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return baseName;
    }

    public DebugShader(ResourceProvider factory) throws IOException {
        super(factory, DebugShader.doInit(factory, "rendertype_eyes"), DefaultVertexFormat.NEW_ENTITY);
    }

    public Program getFragmentProgram() {
        return fragmentShader;
    }

    public Program getVertexProgram() {
        return vertexShader;
    }

    public void attachToProgram() {
        this.getFragmentProgram().attachToShader((Shader)this);
        this.getVertexProgram().attachToShader((Shader)this);
    }

    private static Program getOrCreate(final ResourceProvider factory, Program.Type type, String name) throws IOException {
        System.out.println("Loading " + name + type.getExtension());
        String workingDirAbs = Paths.get("", new String[0]).toAbsolutePath().toString();
        String shaderFile = workingDirAbs + "/" + name + type.getExtension();
        String dummyName = "shaders/core/" + name + type.getExtension();
        final String basePath = FileUtil.getFullResourcePath((String)dummyName);
        FileInputStream file = new FileInputStream(new File(shaderFile));
        Program program = Program.compileShader((Program.Type)type, (String)name, (InputStream)file, (String)"betternether", (GlslPreprocessor)new GlslPreprocessor(){
            private final Set<String> visitedImports = Sets.newHashSet();

            public String applyImport(boolean inline, String name) {
                String inludePath = inline ? basePath : "shaders/include/";
                name = FileUtil.normalizeResourcePath((String)(inludePath + name));
                if (!this.visitedImports.add(name)) {
                    return null;
                }
                ResourceLocation identifier = ResourceLocation.withDefaultNamespace((String)name);
                try {
                    String content;
                    Resource resource = factory.getResource(identifier).orElse(null);
                    try (InputStream is = resource.open();){
                        content = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    }
                    return content;
                }
                catch (IOException var9) {
                    System.err.println("Could not open GLSL import " + name + ": " + var9.getMessage());
                    return "#error " + var9.getMessage();
                }
            }
        });
        return program;
    }
}

