/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.betterx.betternether.entity.EntityFirefly;
import org.betterx.betternether.entity.model.ModelEntityFirefly;
import org.betterx.betternether.entity.render.RenderPhaseAccessor;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

class FireflyGlowFeatureRenderer
extends RenderLayer<EntityFirefly, AgeableListModel<EntityFirefly>> {
    private static final int LIT = 0xF000F0;

    public FireflyGlowFeatureRenderer(RenderLayerParent<EntityFirefly, AgeableListModel<EntityFirefly>> featureRendererContext) {
        super(featureRendererContext);
    }

    public void render(PoseStack matrices, MultiBufferSource vertices, int light, EntityFirefly livingEntity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        EntityModel model = this.getParentModel();
        if (model instanceof ModelEntityFirefly) {
            ResourceLocation identifier = this.getTextureLocation((Entity)livingEntity);
            RenderType renderLayer = RenderPhaseAccessor.getFirefly(identifier);
            VertexConsumer vertexConsumer = vertices.getBuffer(renderLayer);
            int color = livingEntity.getColor();
            this.addViewAlignedGlow(matrices, vertexConsumer, color);
            ((ModelEntityFirefly)model).getGlowPart().render(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY, color);
            ((ModelEntityFirefly)model).getGlowPart().render(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY, color);
        }
    }

    private void addViewAlignedGlow(PoseStack matrices, VertexConsumer vertexConsumer, int color) {
        matrices.pushPose();
        matrices.translate(0.0, 1.25, 0.0);
        Matrix3f normalMatrix = matrices.last().normal();
        normalMatrix.transpose();
        matrices.mulPose(normalMatrix.transpose(new Matrix3f()).getNormalizedRotation(new Quaternionf()));
        PoseStack.Pose entry = matrices.last();
        Matrix4f matrix4f = entry.pose();
        Matrix3f matrix3f = entry.normal();
        FireflyGlowFeatureRenderer.addVertex(matrix4f, entry, vertexConsumer, -1.0f, -1.0f, 0.0f, 0.5f, color);
        FireflyGlowFeatureRenderer.addVertex(matrix4f, entry, vertexConsumer, 1.0f, -1.0f, 1.0f, 0.5f, color);
        FireflyGlowFeatureRenderer.addVertex(matrix4f, entry, vertexConsumer, 1.0f, 1.0f, 1.0f, 1.0f, color);
        FireflyGlowFeatureRenderer.addVertex(matrix4f, entry, vertexConsumer, -1.0f, 1.0f, 0.0f, 1.0f, color);
        matrices.popPose();
    }

    public static void addVertex(Matrix4f matrix4f, PoseStack.Pose matrix3f, VertexConsumer vertexConsumer, float posX, float posY, float u, float v, int color) {
        vertexConsumer.addVertex(matrix4f, posX, posY, 0.0f).setColor(color).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
    }
}

