/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.entity.EntityNagaProjectile;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RenderNagaProjectile
extends EntityRenderer<EntityNagaProjectile> {
    private static final ResourceLocation TEXTURE = BetterNether.C.mk("textures/entity/naga_projectile.png");
    private static final RenderType LAYER = RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE);

    public RenderNagaProjectile(EntityRendererProvider.Context context) {
        super(context);
    }

    public ResourceLocation getTextureLocation(EntityNagaProjectile entity) {
        return TEXTURE;
    }

    public void render(EntityNagaProjectile dragonFireballEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        int frame = (int)(System.currentTimeMillis() / 150L) & 3;
        float start = (float)frame * 0.25f;
        float end = start + 0.25f;
        matrixStack.pushPose();
        matrixStack.scale(2.0f, 2.0f, 2.0f);
        matrixStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        PoseStack.Pose entry = matrixStack.last();
        Matrix4f matrix4f = entry.pose();
        Matrix3f matrix3f = entry.normal();
        VertexConsumer vertexConsumer = vertexConsumerProvider.getBuffer(LAYER);
        RenderNagaProjectile.vertex(vertexConsumer, matrix4f, entry, i, 0.0f, 0, 0.0f, end);
        RenderNagaProjectile.vertex(vertexConsumer, matrix4f, entry, i, 1.0f, 0, 1.0f, end);
        RenderNagaProjectile.vertex(vertexConsumer, matrix4f, entry, i, 1.0f, 1, 1.0f, start);
        RenderNagaProjectile.vertex(vertexConsumer, matrix4f, entry, i, 0.0f, 1, 0.0f, start);
        matrixStack.popPose();
        super.render((Entity)dragonFireballEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }

    private static void vertex(VertexConsumer vertexConsumer, Matrix4f matrix4f, PoseStack.Pose pose, int i, float f, int j, float u, float v) {
        vertexConsumer.addVertex(matrix4f, f - 0.5f, (float)j - 0.25f, 0.0f).setColor(255, 255, 255, 255).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(i).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }
}

