/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.integrations;

import java.lang.reflect.Constructor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import org.apache.logging.log4j.LogManager;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.registry.NetherItems;
import org.betterx.wover.core.api.ModCore;

public class VanillaExcavatorsIntegration {
    private static boolean hasExcavators = BetterNether.VANILLA_EXCAVATORS.isLoaded();
    private static Constructor<?> excavatorConstructor;

    public static Item makeExcavator(Tier material, int attackDamage, float attackSpeed) {
        if (!hasExcavators) {
            if (ModCore.isDatagen()) {
                return new Item(NetherItems.defaultSettings());
            }
            return Items.AIR;
        }
        try {
            return (Item)excavatorConstructor.newInstance(material, attackDamage, Float.valueOf(attackSpeed), NetherItems.defaultSettings());
        }
        catch (Exception e) {
            e.printStackTrace();
            return Items.AIR;
        }
    }

    public static boolean hasExcavators() {
        return hasExcavators;
    }

    static {
        try {
            if (hasExcavators) {
                LogManager.getLogger().info("[BetterNether] Enabled Vanilla Excavators Integration");
                Class<?> itemClass = Class.forName("draylar.magna.item.ExcavatorItem");
                if (itemClass != null) {
                    for (Constructor<?> c : itemClass.getConstructors()) {
                        if (c.getParameterCount() != 4) continue;
                        excavatorConstructor = c;
                        break;
                    }
                }
                hasExcavators = excavatorConstructor != null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

