/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.integrations;

import java.lang.reflect.Constructor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import org.apache.logging.log4j.LogManager;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.registry.NetherItems;
import org.betterx.wover.core.api.ModCore;

public class VanillaHammersIntegration {
    private static boolean hasHammers = BetterNether.VANILLA_HAMMERS.isLoaded();
    private static Constructor<?> hammerConstructor;

    public static Item makeHammer(Tier material, int attackDamage, float attackSpeed) {
        if (!hasHammers) {
            if (ModCore.isDatagen()) {
                return new Item(NetherItems.defaultSettings());
            }
            return Items.AIR;
        }
        try {
            return (Item)hammerConstructor.newInstance(material, attackDamage, Float.valueOf(attackSpeed), NetherItems.defaultSettings());
        }
        catch (Exception e) {
            e.printStackTrace();
            return Items.AIR;
        }
    }

    public static boolean hasHammers() {
        return hasHammers;
    }

    static {
        try {
            if (hasHammers) {
                LogManager.getLogger().info("[BetterNether] Enabled Vanilla Hammers Integration");
                Class<?> hammerItemClass = Class.forName("draylar.magna.item.HammerItem");
                if (hammerItemClass != null) {
                    for (Constructor<?> c : hammerItemClass.getConstructors()) {
                        if (c.getParameterCount() != 4) continue;
                        hammerConstructor = c;
                        break;
                    }
                }
                hasHammers = hammerConstructor != null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

