/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.integrations.emi;

import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.integrations.emi.EMIPlugin;
import org.betterx.wover.core.api.Logger;

public class EMIForgeRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final EmiIngredient input;
    private final EmiStack output;
    private final RecipeHolder<SmeltingRecipe> recipe;
    private final int speedup;

    public EMIForgeRecipe(RecipeHolder<SmeltingRecipe> recipe, int speedup) {
        this.id = ResourceLocation.fromNamespaceAndPath((String)"emi", (String)(recipe.id().getNamespace() + "/" + recipe.id().getPath() + "/forge"));
        this.input = EmiIngredient.of((Ingredient)((Ingredient)((SmeltingRecipe)recipe.value()).getIngredients().get(0)));
        this.output = EmiStack.of((ItemStack)((SmeltingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
        this.recipe = recipe;
        this.speedup = speedup;
    }

    static void addAllRecipes(EmiRegistry emiRegistry, RecipeManager manager) {
        org.betterx.bclib.integration.emi.EMIPlugin.addAllRecipes((EmiRegistry)emiRegistry, (RecipeManager)manager, (Logger)BetterNether.C.LOG, (RecipeType)RecipeType.SMELTING, recipe -> new EMIForgeRecipe((RecipeHolder<SmeltingRecipe>)recipe, 2));
    }

    public EmiRecipeCategory getCategory() {
        return EMIPlugin.getForgeCategory();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.input);
    }

    public List<EmiStack> getOutputs() {
        return List.of(this.output);
    }

    public int getDisplayWidth() {
        return 82;
    }

    public int getDisplayHeight() {
        return 38;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addFillingArrow(24, 5, 50 * ((SmeltingRecipe)this.recipe.value()).getCookingTime()).tooltip((mx, my) -> List.of(ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)"emi.cooking.time", (Object[])new Object[]{Float.valueOf((float)(((SmeltingRecipe)this.recipe.value()).getCookingTime() / this.speedup) / 20.0f)}).getVisualOrderText())));
        widgets.addTexture(EmiTexture.EMPTY_FLAME, 1, 24);
        widgets.addAnimatedTexture(EmiTexture.FULL_FLAME, 1, 24, 4000 / this.speedup, false, true, true);
        widgets.addText(Component.translatable((String)"emi.cooking.experience", (Object[])new Object[]{Float.valueOf(((SmeltingRecipe)this.recipe.value()).getExperience())}).getVisualOrderText(), 26, 28, -1, true);
        widgets.addSlot(this.input, 0, 4);
        widgets.addSlot((EmiIngredient)this.output, 56, 0).large(true).recipeContext((EmiRecipe)this);
    }
}

