/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.items;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BNBlockProperties;
import org.betterx.betternether.blocks.BlockStalagnateBowl;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.registry.NetherItems;

public class ItemBowlFood
extends Item {
    private final BNBlockProperties.FoodShape bowlFood;

    public ItemBowlFood(FoodProperties component, BNBlockProperties.FoodShape food) {
        super(new Item.Properties().food(component).stacksTo(16));
        food.setItem(this);
        this.bowlFood = food;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos().relative(context.getClickedFace());
        if (context.getPlayer().isShiftKeyDown() && world.isEmptyBlock(pos) && NetherBlocks.MAT_STALAGNATE.getBowl().defaultBlockState().canSurvive((LevelReader)world, pos)) {
            if (!world.isClientSide()) {
                BlockState state = (BlockState)NetherBlocks.MAT_STALAGNATE.getBowl().defaultBlockState().setValue(BlockStalagnateBowl.FOOD, (Comparable)((Object)this.bowlFood));
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, pos, state);
            }
            if (!context.getPlayer().isCreative()) {
                context.getPlayer().getMainHandItem().shrink(1);
            }
            world.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.25, (double)pos.getZ() + 0.5, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 0.8f, 1.0f, true);
            return InteractionResult.CONSUME;
        }
        return super.useOn(context);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        Player player;
        if (stack.getCount() == 1) {
            super.finishUsingItem(stack, world, user);
            return new ItemStack((ItemLike)NetherItems.STALAGNATE_BOWL, 1);
        }
        if (user instanceof Player && !(player = (Player)user).isCreative()) {
            player.addItem(new ItemStack((ItemLike)NetherItems.STALAGNATE_BOWL));
        }
        return super.finishUsingItem(stack, world, user);
    }
}

