/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.items;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantments;
import org.betterx.bclib.items.tool.BasePickaxeItem;
import org.betterx.betternether.items.materials.BNToolMaterial;
import org.betterx.betternether.registry.NetherEnchantments;
import org.betterx.betternether.registry.NetherTags;
import org.betterx.wover.common.item.api.ItemWithCustomStack;
import org.betterx.wover.enchantment.api.EnchantmentUtils;
import org.betterx.wover.item.api.ItemTagProvider;
import org.betterx.wover.tag.api.event.context.ItemTagBootstrapContext;

public class NetherPickaxe
extends BasePickaxeItem
implements ItemWithCustomStack,
ItemTagProvider {
    public NetherPickaxe(Tier material, Item.Properties settings) {
        super(material, settings);
    }

    public void setupItemStack(ItemStack stack, HolderLookup.Provider provider) {
        provider.lookup(Registries.ENCHANTMENT).ifPresent(lookup -> {
            int obsidianLevel = 0;
            if (this.getTier() == BNToolMaterial.CINCINNASITE_DIAMOND) {
                obsidianLevel = 2;
            } else if (this.getTier() == BNToolMaterial.NETHER_RUBY) {
                obsidianLevel = 1;
            } else if (this.getTier() == BNToolMaterial.FLAMING_RUBY) {
                obsidianLevel = 3;
                EnchantmentUtils.enchantInWorld((ItemStack)stack, (ResourceKey)NetherEnchantments.RUBY_FIRE.key(), (int)1, (HolderLookup.RegistryLookup)lookup);
                EnchantmentUtils.enchantInWorld((ItemStack)stack, (ResourceKey)Enchantments.MENDING, (int)1, (HolderLookup.RegistryLookup)lookup);
            }
            if (obsidianLevel > 0) {
                EnchantmentUtils.enchantInWorld((ItemStack)stack, (ResourceKey)NetherEnchantments.OBSIDIAN_BREAKER.key(), (int)obsidianLevel, (HolderLookup.RegistryLookup)lookup);
            }
        });
    }

    public void registerItemTags(ResourceLocation location, ItemTagBootstrapContext context) {
        context.add(NetherTags.NETHER_PICKAXES, (Object[])new Item[]{this});
    }
}

