/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.loot;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import org.betterx.bclib.interfaces.LootPoolAccessor;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.registry.NetherTemplates;

public class BNLoot {
    public static final ResourceKey<LootTable> CITY_LOOT = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)BetterNether.C.id("chests/city"));
    public static final ResourceKey<LootTable> CITY_LOOT_COMMON = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)BetterNether.C.id("chests/city_common"));
    public static final ResourceKey<LootTable> CITY_LOOT_SURPRISE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)BetterNether.C.id("chests/city_surprise"));
    public static final ResourceKey<LootTable> LIBRARY_LOOT = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)BetterNether.C.id("chests/library"));
    public static final ResourceKey<LootTable> WITHER_TOWER_LOOT = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)BetterNether.C.id("chests/wither_tower"));
    public static final ResourceKey<LootTable> WITHER_TOWER_BONUS_LOOT = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)BetterNether.C.id("chests/wither_tower_bonus"));
    public static final ResourceKey<LootTable> GHAST_HIVE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)BetterNether.C.id("chests/ghast_hive"));
    public static final ResourceKey<LootTable> FIREFLY = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)BetterNether.C.id("entities/firefly"));
    public static final ResourceKey<LootTable> FLYING_PIG = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)BetterNether.C.id("entities/flying_pig"));
    public static final ResourceKey<LootTable> JUNGLE_SKELETON = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)BetterNether.C.id("entities/jungle_skeleton"));
    public static final ResourceKey<LootTable> NAGA = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)BetterNether.C.id("entities/naga"));
    public static final ResourceKey<LootTable> SKULL = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)BetterNether.C.id("entities/skull"));

    public static void register() {
        NeoForge.EVENT_BUS.addListener(BNLoot::onLootTableLoad);
    }

    private static void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation id = event.getName();
        LootTable table = event.getTable();
        if (BuiltInLootTables.RUINED_PORTAL.equals(id) || BuiltInLootTables.NETHER_BRIDGE.equals(id)) {
            table.addPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)4.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherBlocks.BLUE_OBSIDIAN.asItem()).setWeight(1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(9)).build());
            table.addPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(9)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherTemplates.NETHER_BOWL_SMITHING_TEMPLATE).setWeight(1)).build());
        } else if (BuiltInLootTables.BASTION_BRIDGE.equals(id) || BuiltInLootTables.BASTION_HOGLIN_STABLE.equals(id) || BuiltInLootTables.BASTION_TREASURE.equals(id)) {
            table.addPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherBlocks.BLUE_CRYING_OBSIDIAN.asItem()).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)8.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherBlocks.BLUE_WEEPING_OBSIDIAN.asItem()).setWeight(1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherBlocks.WEEPING_OBSIDIAN.asItem()).setWeight(1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)))).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(50)).build());
            table.addPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(99)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherTemplates.NETHER_BOWL_SMITHING_TEMPLATE).setWeight(1)).build());
        } else if (BuiltInLootTables.BASTION_OTHER.equals(id)) {
            table.addPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherBlocks.BLUE_OBSIDIAN.asItem()).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)4.0f, (float)6.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherBlocks.BLUE_CRYING_OBSIDIAN.asItem()).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)5.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherBlocks.BLUE_WEEPING_OBSIDIAN.asItem()).setWeight(1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherBlocks.WEEPING_OBSIDIAN.asItem()).setWeight(1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(50)).build());
            table.addPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(9)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherTemplates.NETHER_BOWL_SMITHING_TEMPLATE).setWeight(1)).build());
        } else if (BuiltInLootTables.PIGLIN_BARTERING.equals(id)) {
            ArrayList list = Lists.newArrayList();
            list.add(LootItem.lootTableItem((ItemLike)NetherBlocks.BLUE_OBSIDIAN.asItem()).setWeight(40).build());
            list.add(LootItem.lootTableItem((ItemLike)NetherBlocks.BLUE_CRYING_OBSIDIAN.asItem()).setWeight(40).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).build());
            list.add(LootItem.lootTableItem((ItemLike)NetherBlocks.BLUE_WEEPING_OBSIDIAN.asItem()).setWeight(20).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).build());
            list.add(LootItem.lootTableItem((ItemLike)NetherBlocks.WEEPING_OBSIDIAN.asItem()).setWeight(20).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).build());
            if (!BNLoot.addToPool(table, 0, list)) {
                BetterNether.C.log.error("Unable to build bartering table");
            }
        }
    }

    private static boolean addToPool(LootTable table, int index, ArrayList<LootPoolEntryContainer> newEntries) {
        try {
            for (Field f : table.getClass().getDeclaredFields()) {
                List pools;
                if (!List.class.isAssignableFrom(f.getType())) continue;
                f.setAccessible(true);
                List list = (List)f.get(table);
                if (list == null || list.isEmpty() || !(list.get(0) instanceof LootPool) || (pools = list).size() <= index) continue;
                LootPool pool = (LootPool)pools.get(index);
                LootPoolAccessor acc = (LootPoolAccessor)pool;
                pools.set(index, acc.bcl_mergeEntries(newEntries));
                return true;
            }
        }
        catch (Exception e) {
            BetterNether.C.log.error("Unable to build bartering table", e);
        }
        return false;
    }
}

