/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.mixin.client;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.LavaFluid;
import org.betterx.betternether.BetterNether;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LavaFluid.class}, remap=false)
public class LavaFluidMixin {
    @Inject(method={"animateTick"}, at={@At(value="HEAD")})
    private void displayTick(Level world, BlockPos blockPos, FluidState fluidState, RandomSource random, CallbackInfo info) {
        FluidState state;
        if (BetterNether.hasLavafallParticles() && !fluidState.isSource() && ((state = world.getFluidState(blockPos.below())).isEmpty() || state.isSource()) && !(state = world.getFluidState(blockPos.above(3))).isEmpty() && !state.isSource()) {
            for (int i = 0; i < 10; ++i) {
                this.spawnParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, world, random, blockPos);
                this.spawnParticle((ParticleOptions)ParticleTypes.SMOKE, world, random, blockPos);
                this.spawnParticle((ParticleOptions)ParticleTypes.LAVA, world, random, blockPos);
            }
        }
    }

    @Unique
    private void spawnParticle(ParticleOptions effect, Level world, RandomSource random, BlockPos pos) {
        double angle = random.nextDouble() * Math.PI * 2.0;
        world.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pos.getX() + random.nextDouble(), (double)pos.getY() + random.nextDouble(), (double)pos.getZ() + random.nextDouble(), Math.sin(angle) * 0.1, 0.0, Math.cos(angle) * 0.1);
    }
}

