/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.mixin.common;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.betternether.blocks.BNObsidian;
import org.betterx.betternether.registry.NetherBlocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LightningRodBlock.class}, remap=false)
public class LightningRodBlockMixin {
    @Unique
    private static final Direction[] bn_update_directions = new Direction[]{Direction.WEST, Direction.EAST, Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH};

    @Inject(method={"onLightningStrike"}, at={@At(value="TAIL")}, remap=false)
    void bn_onLightningStrike(BlockState blockState, Level level, BlockPos blockPos, CallbackInfo ci) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Direction dir : bn_update_directions) {
            mutableBlockPos.setWithOffset((Vec3i)blockPos, dir);
            BlockState state = level.getBlockState((BlockPos)mutableBlockPos);
            if (state.is(Blocks.OBSIDIAN)) {
                BNObsidian.onLightningUpdate(level, (BlockPos)mutableBlockPos, Blocks.CRYING_OBSIDIAN);
                continue;
            }
            if (!state.is(Blocks.CRYING_OBSIDIAN)) continue;
            BNObsidian.onLightningUpdate(level, (BlockPos)mutableBlockPos, NetherBlocks.WEEPING_OBSIDIAN);
        }
    }
}

