/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.mixin.common;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ComplexItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MapItem.class}, remap=false)
public abstract class MapMixin
extends ComplexItem {
    public MapMixin(Item.Properties settings) {
        super(settings);
    }

    @Shadow
    private BlockState getCorrectStateForFluidBlock(Level world, BlockState state, BlockPos pos) {
        return state;
    }

    @Inject(method={"update"}, at={@At(value="HEAD")}, cancellable=true)
    private void bn_update(Level level, Entity entity, MapItemSavedData state, CallbackInfo info) {
        if (level.dimensionType().hasCeiling() && level.dimension() == state.dimension && entity instanceof Player) {
            int scale = 1 << state.scale;
            int sx = state.centerX;
            int sz = state.centerZ;
            int px = Mth.floor((double)(entity.getX() - (double)sx)) / scale + 64;
            int pz = Mth.floor((double)(entity.getZ() - (double)sz)) / scale + 64;
            int stepWidth = 128 / scale;
            if (level.dimensionType().hasCeiling()) {
                stepWidth /= 2;
            }
            MapItemSavedData.HoldingPlayer holdingPlayer = state.getHoldingPlayer((Player)entity);
            ++holdingPlayer.step;
            BlockPos.MutableBlockPos POS = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos POS2 = new BlockPos.MutableBlockPos();
            boolean bl = false;
            for (int xx = px - stepWidth + 1; xx < px + stepWidth; ++xx) {
                if ((xx & 0xF) != (holdingPlayer.step & 0xF) && !bl) continue;
                bl = false;
                double d = 0.0;
                for (int zz = pz - stepWidth - 1; zz < pz + stepWidth; ++zz) {
                    double f;
                    if (xx < 0 || zz < -1 || xx >= 128 || zz >= 128) continue;
                    int q = Mth.square((int)(xx - px)) + Mth.square((int)(zz - pz));
                    boolean bl2 = q > (stepWidth - 2) * (stepWidth - 2);
                    int x = (sx / scale + xx - 64) * scale;
                    int z = (sz / scale + zz - 64) * scale;
                    LinkedHashMultiset multiset = LinkedHashMultiset.create();
                    LevelChunk levelChunk = level.getChunk(SectionPos.blockToSectionCoord((int)x), SectionPos.blockToSectionCoord((int)z));
                    if (levelChunk.isEmpty()) continue;
                    int w = 0;
                    double height = 0.0;
                    for (int bx = 0; bx < scale; ++bx) {
                        for (int bz = 0; bz < scale; ++bz) {
                            BlockState blockState;
                            POS.set(x + bx, 0, z + bz);
                            int testY = levelChunk.getHeight(Heightmap.Types.WORLD_SURFACE, POS.getX(), POS.getZ()) + 1;
                            if (testY <= level.getMinBuildHeight() + 1) {
                                blockState = Blocks.BEDROCK.defaultBlockState();
                            } else {
                                do {
                                    POS.setY(--testY);
                                } while ((blockState = levelChunk.getBlockState((BlockPos)POS)).is(Blocks.BEDROCK) || blockState.getMapColor((BlockGetter)level, (BlockPos)POS) != MapColor.NONE && testY > level.getMinBuildHeight());
                                do {
                                    POS.setY(--testY);
                                } while ((blockState = levelChunk.getBlockState((BlockPos)POS)).getMapColor((BlockGetter)level, (BlockPos)POS) == MapColor.NONE && testY > level.getMinBuildHeight());
                                if (testY > level.getMinBuildHeight() && !blockState.getFluidState().isEmpty()) {
                                    BlockState blockState2;
                                    int ab = testY - 1;
                                    POS2.set((Vec3i)POS);
                                    do {
                                        POS2.setY(ab--);
                                        blockState2 = levelChunk.getBlockState((BlockPos)POS2);
                                        ++w;
                                    } while (ab > level.getMinBuildHeight() && !blockState2.getFluidState().isEmpty());
                                    blockState = this.getCorrectStateForFluidBlock(level, blockState, (BlockPos)POS);
                                }
                            }
                            state.checkBanners((BlockGetter)level, POS.getX(), POS.getZ());
                            height += (double)testY / (double)(scale * scale);
                            multiset.add((Object)blockState.getMapColor((BlockGetter)level, (BlockPos)POS));
                        }
                    }
                    MapColor mapColor = (MapColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)MapColor.NONE);
                    MapColor.Brightness brightness = mapColor == MapColor.WATER ? ((f = (double)(w /= scale * scale) * 0.1 + (double)(xx + zz & 1) * 0.2) < 0.5 ? MapColor.Brightness.HIGH : (f > 0.9 ? MapColor.Brightness.LOW : MapColor.Brightness.NORMAL)) : ((f = (height - d) * 4.0 / (double)(scale + 4) + ((double)(xx + zz & 1) - 0.5) * 0.4) > 0.6 ? MapColor.Brightness.HIGH : (f < -0.6 ? MapColor.Brightness.LOW : MapColor.Brightness.NORMAL));
                    d = height;
                    if (zz < 0 || q >= stepWidth * stepWidth || bl2 && (xx + zz & 1) == 0) continue;
                    bl |= state.updateColor(xx, zz, mapColor.getPackedId(brightness));
                }
            }
            info.cancel();
        }
    }
}

