/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.mixin.common;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.registry.NetherBlocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={NetherWartBlock.class}, remap=false)
public abstract class NetherWartMixin
extends BushBlock {
    protected NetherWartMixin(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Inject(method={"mayPlaceOn"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true, remap=false)
    private void canStay(BlockState floor, BlockGetter view, BlockPos pos, CallbackInfoReturnable<Boolean> info) {
        if (floor.getBlock() == NetherBlocks.FARMLAND) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(method={"randomTick"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void bn_randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random, CallbackInfo info) {
        super.randomTick(state, world, pos, random);
        int i = (Integer)state.getValue((Property)NetherWartBlock.AGE);
        if (i < 3) {
            int chance;
            int n = chance = BlocksHelper.isFertile(world.getBlockState(pos.below())) ? 3 : 10;
            if (random.nextInt(chance) == 0) {
                state = (BlockState)state.setValue((Property)NetherWartBlock.AGE, (Comparable)Integer.valueOf(i + 1));
                world.setBlock(pos, state, 2);
            }
        }
        info.cancel();
    }
}

