/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.portals;

import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class BNPortalShape {
    private static final Direction[] DIR_X = new Direction[]{Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST};
    private static final Direction[] DIR_Z = new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH};
    public static final int MAX_SEARCH_DIST = 21;
    private final LevelAccessor levelAccessor;
    private final BlockPos blockPos;
    private final Direction.Axis axis;
    BlockPos.MutableBlockPos min;
    BlockPos.MutableBlockPos max;
    private final boolean valid;
    private final List<BlockPos> portalBlocks = new LinkedList<BlockPos>();
    private int numPortalBlocks = 0;
    private static final BlockPos[] stack = new BlockPos[63];

    public BNPortalShape(LevelAccessor levelAccessor, BlockPos blockPos, Direction.Axis axis) {
        this.levelAccessor = levelAccessor;
        this.blockPos = blockPos;
        this.axis = axis;
        this.valid = axis.equals((Object)Direction.Axis.X) ? this.getPortalBlocks(blockPos, DIR_X) : this.getPortalBlocks(blockPos, DIR_Z);
    }

    private boolean getPortalBlocks(BlockPos blockPos, Direction[] directions) {
        this.portalBlocks.clear();
        BlockState[][] states = new BlockState[42][42];
        byte[][] mask = new byte[42][42];
        this.min = blockPos.mutable();
        this.max = blockPos.mutable();
        boolean nextStackPos = false;
        Stack<BlockPos> todo = new Stack<BlockPos>();
        todo.add(blockPos);
        while (!todo.isEmpty()) {
            BlockPos p = (BlockPos)todo.pop();
            BlockState tstate = this.levelAccessor.getBlockState(p);
            if (tstate.is(Blocks.NETHER_PORTAL)) {
                ++this.numPortalBlocks;
            }
            this.portalBlocks.add(p);
            if (p.getX() < this.min.getX()) {
                this.min.setX(p.getX());
            }
            if (p.getY() < this.min.getY()) {
                this.min.setY(p.getY());
            }
            if (p.getZ() < this.min.getZ()) {
                this.min.setZ(p.getZ());
            }
            if (p.getX() > this.max.getX()) {
                this.max.setX(p.getX());
            }
            if (p.getY() > this.max.getY()) {
                this.max.setY(p.getY());
            }
            if (p.getZ() > this.max.getZ()) {
                this.max.setZ(p.getZ());
            }
            for (Direction d : directions) {
                BlockPos pp = p.relative(d, 1);
                if (this.portalBlocks.contains(pp)) continue;
                if (Math.abs(pp.getX() - blockPos.getX()) > 21 || Math.abs(pp.getZ() - blockPos.getZ()) > 21 || Math.abs(pp.getY() - blockPos.getY()) > 21) {
                    this.portalBlocks.clear();
                    return false;
                }
                BlockState state = this.levelAccessor.getBlockState(pp);
                if (BNPortalShape.isEmpty(state)) {
                    todo.add(pp);
                    continue;
                }
                if (BNPortalShape.isFrame(state)) continue;
                this.portalBlocks.clear();
                return false;
            }
        }
        return true;
    }

    public BlockPos calculateBottomLeft(BlockPos blockPos) {
        return this.valid ? this.min : null;
    }

    public int calculateWidth() {
        if (this.axis == Direction.Axis.X) {
            return this.valid ? this.max.getX() - this.min.getX() : 0;
        }
        if (this.axis == Direction.Axis.Z) {
            return this.valid ? this.max.getZ() - this.min.getZ() : 0;
        }
        return 0;
    }

    public int calculateHeight() {
        if (this.axis == Direction.Axis.X) {
            return this.valid ? this.max.getY() - this.min.getY() : 0;
        }
        if (this.axis == Direction.Axis.Z) {
            return this.valid ? this.max.getY() - this.min.getY() : 0;
        }
        return 0;
    }

    private static boolean isFrame(BlockState blockState) {
        return blockState.is(Blocks.OBSIDIAN) || blockState.is(CommonBlockTags.NETHER_PORTAL_FRAME);
    }

    private static boolean isEmpty(BlockState blockState) {
        return blockState.isAir() || blockState.is(BlockTags.FIRE) || blockState.is(Blocks.NETHER_PORTAL);
    }

    public boolean isValid() {
        return this.valid;
    }

    public void createPortalBlocks() {
        BlockState blockState = (BlockState)Blocks.NETHER_PORTAL.defaultBlockState().setValue((Property)NetherPortalBlock.AXIS, (Comparable)this.axis);
        this.portalBlocks.forEach(p -> this.levelAccessor.setBlock(p, blockState, 18));
    }

    public boolean isComplete() {
        return this.valid && this.numPortalBlocks == this.portalBlocks.size();
    }
}

