/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.registry;

import net.minecraft.client.model.geom.ModelLayerLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.entity.model.ModelEntityFirefly;
import org.betterx.betternether.entity.model.ModelEntityFlyingPig;
import org.betterx.betternether.entity.model.ModelEntityHydrogenJellyfish;
import org.betterx.betternether.entity.model.ModelJungleSkeleton;
import org.betterx.betternether.entity.model.ModelNaga;
import org.betterx.betternether.entity.model.ModelSkull;
import org.betterx.betternether.entity.render.RenderFirefly;
import org.betterx.betternether.entity.render.RenderFlyingPig;
import org.betterx.betternether.entity.render.RenderHydrogenJellyfish;
import org.betterx.betternether.entity.render.RenderJungleSkeleton;
import org.betterx.betternether.entity.render.RenderNaga;
import org.betterx.betternether.entity.render.RenderNagaProjectile;
import org.betterx.betternether.entity.render.RenderSkull;
import org.betterx.betternether.registry.NetherEntities;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(modid="betternether", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class EntityRenderRegistry {
    private static final String DEFAULT_LAYER = "main";
    public static final ModelLayerLocation FIREFLY_MODEL = EntityRenderRegistry.registerMain("firefly");
    public static final ModelLayerLocation NAGA_MODEL = EntityRenderRegistry.registerMain("naga");
    public static final ModelLayerLocation JUNGLE_SKELETON_MODEL = EntityRenderRegistry.registerMain("jungle_skeleton");
    public static final ModelLayerLocation FLYING_PIG_MODEL = EntityRenderRegistry.registerMain("flying_pig");
    public static final ModelLayerLocation HYDROGEN_JELLYFISH_MODEL = EntityRenderRegistry.registerMain("hydrogen_jelly");
    public static final ModelLayerLocation SKULL_MODEL = EntityRenderRegistry.registerMain("skull");

    public static ModelLayerLocation registerMain(String id) {
        return new ModelLayerLocation(BetterNether.C.mk(id), DEFAULT_LAYER);
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(NetherEntities.FIREFLY.type(), RenderFirefly::new);
        event.registerEntityRenderer(NetherEntities.HYDROGEN_JELLYFISH.type(), RenderHydrogenJellyfish::new);
        event.registerEntityRenderer(NetherEntities.NAGA.type(), RenderNaga::new);
        event.registerEntityRenderer(NetherEntities.NAGA_PROJECTILE, RenderNagaProjectile::new);
        event.registerEntityRenderer(NetherEntities.FLYING_PIG.type(), RenderFlyingPig::new);
        event.registerEntityRenderer(NetherEntities.JUNGLE_SKELETON.type(), RenderJungleSkeleton::new);
        event.registerEntityRenderer(NetherEntities.SKULL.type(), RenderSkull::new);
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(FIREFLY_MODEL, ModelEntityFirefly::getTexturedModelData);
        event.registerLayerDefinition(NAGA_MODEL, ModelNaga::getTexturedModelData);
        event.registerLayerDefinition(JUNGLE_SKELETON_MODEL, ModelJungleSkeleton::createBodyLayer);
        event.registerLayerDefinition(FLYING_PIG_MODEL, ModelEntityFlyingPig::getTexturedModelData);
        event.registerLayerDefinition(HYDROGEN_JELLYFISH_MODEL, ModelEntityHydrogenJellyfish::getTexturedModelData);
        event.registerLayerDefinition(SKULL_MODEL, ModelSkull::getTexturedModelData);
    }
}

