/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.registry;

import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.items.DebugDataItem;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.blocks.BNBlockProperties;
import org.betterx.betternether.integrations.VanillaExcavatorsIntegration;
import org.betterx.betternether.integrations.VanillaHammersIntegration;
import org.betterx.betternether.items.ItemBlackApple;
import org.betterx.betternether.items.ItemBowlFood;
import org.betterx.betternether.items.complex.DiamondSet;
import org.betterx.betternether.items.complex.NetherSet;
import org.betterx.betternether.items.materials.BNArmorTiers;
import org.betterx.betternether.items.materials.BNToolMaterial;
import org.betterx.betternether.items.materials.BNToolTiers;
import org.betterx.betternether.loot.BNLoot;
import org.betterx.betternether.registry.NetherTemplates;
import org.betterx.wover.complex.api.equipment.ArmorSlot;
import org.betterx.wover.complex.api.equipment.ToolSlot;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.item.api.ItemRegistry;
import org.betterx.wover.item.api.smithing.SmithingTemplates;
import org.betterx.wover.state.api.WorldState;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class NetherItems {
    public static Item BLACK_APPLE;
    public static Item STALAGNATE_BOWL;
    public static Item STALAGNATE_BOWL_WART;
    public static Item STALAGNATE_BOWL_MUSHROOM;
    public static Item STALAGNATE_BOWL_APPLE;
    public static Item HOOK_MUSHROOM_COOKED;
    public static Item CINCINNASITE;
    public static Item CINCINNASITE_INGOT;
    public static Item NETHER_RUBY;
    public static NetherSet CINCINNASITE_SET;
    public static NetherSet NETHER_RUBY_SET;
    public static DiamondSet CINCINNASITE_DIAMOND_SET;
    public static NetherSet FLAMING_RUBY_SET;
    public static Item CINCINNASITE_HAMMER;
    public static Item CINCINNASITE_HAMMER_DIAMOND;
    public static Item NETHER_RUBY_HAMMER;
    public static Item CINCINNASITE_EXCAVATOR;
    public static Item CINCINNASITE_EXCAVATOR_DIAMOND;
    public static Item NETHER_RUBY_EXCAVATOR;
    public static Item GLOWSTONE_PILE;
    public static Item LAPIS_PILE;
    public static Item AGAVE_LEAF;
    public static Item AGAVE_MEDICINE;
    public static Item HERBAL_MEDICINE;
    private static ItemRegistry ITEMS_REGISTRY;
    private static boolean itemsRegistered;

    private NetherItems() {
    }

    @NotNull
    public static ItemRegistry getItemRegistry() {
        if (ITEMS_REGISTRY == null) {
            ITEMS_REGISTRY = ItemRegistry.forMod((ModCore)BetterNether.C);
            ITEMS_REGISTRY.setInitializer(NetherItems::registerItems);
        }
        return ITEMS_REGISTRY;
    }

    public static Stream<Item> getModItems() {
        return NetherItems.getItemRegistry().allItems();
    }

    public static Item registerShears(String name, Item item) {
        if (item != Items.AIR) {
            return NetherItems.getItemRegistry().registerAsTool(name, item, new TagKey[0]);
        }
        return item;
    }

    public static Item registerTool(String name, Item item, TagKey<Item> ... tags) {
        if (item != Items.AIR) {
            NetherItems.getItemRegistry().registerAsTool(name, item, tags);
        }
        return item;
    }

    public static Item registerItem(String name, Item item, TagKey<Item> ... tags) {
        if (item != Items.AIR) {
            NetherItems.getItemRegistry().register(name, item, tags);
        }
        return item;
    }

    public static Item registerFood(String name, int hunger, float saturationMultiplier) {
        return NetherItems.registerItem(name, new Item(NetherItems.defaultSettings().food(new FoodProperties.Builder().nutrition(hunger).saturationModifier(saturationMultiplier).build())), new TagKey[0]);
    }

    public static Item registerMedicine(String name, int ticks, int power, boolean bowl) {
        if (bowl) {
            Item item = new Item(NetherItems.defaultSettings().stacksTo(16).food(new FoodProperties.Builder().effect(new MobEffectInstance(MobEffects.REGENERATION, ticks, power), 1.0f).build())){

                public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
                    Player player;
                    if (stack.getCount() == 1) {
                        super.finishUsingItem(stack, world, user);
                        return new ItemStack((ItemLike)STALAGNATE_BOWL, stack.getCount());
                    }
                    if (user instanceof Player && !(player = (Player)user).isCreative()) {
                        player.addItem(new ItemStack((ItemLike)STALAGNATE_BOWL));
                    }
                    return super.finishUsingItem(stack, world, user);
                }
            };
            return NetherItems.registerItem(name, item, new TagKey[0]);
        }
        return NetherItems.registerItem(name, new Item(NetherItems.defaultSettings().food(new FoodProperties.Builder().effect(new MobEffectInstance(MobEffects.REGENERATION, ticks, power), 1.0f).build())), new TagKey[0]);
    }

    public static Item.Properties defaultSettings() {
        return new Item.Properties();
    }

    public static Item.Properties createDefaultNetherArmorSettings(ArmorItem.Type type, int durability) {
        return NetherItems.defaultSettings().fireResistant().durability(type.getDurability(durability));
    }

    public static Item.Properties createDefaultNetherToolSettings(Tier material, float attackDamage, float attackSpeed) {
        return NetherItems.defaultSettings().fireResistant().attributes(DiggerItem.createAttributes((Tier)material, (float)attackDamage, (float)attackSpeed));
    }

    public static Item.Properties createDefaultNetherSwordSettings(Tier material, float attackDamage, float attackSpeed) {
        return NetherItems.defaultSettings().fireResistant().attributes(SwordItem.createAttributes((Tier)material, (int)((int)attackDamage), (float)attackSpeed));
    }

    private static void registerSmithingTemplates() {
        NetherTemplates.NETHER_BOWL_SMITHING_TEMPLATE = NetherItems.getItemRegistry().registerSmithingTemplateItem("bowl_upgrade", List.of(NetherTemplates.EMPTY_SLOT_BOWL), List.of(SmithingTemplates.EMPTY_SLOT_INGOT));
        NetherTemplates.FLAMING_RUBY_TEMPLATE = NetherItems.getItemRegistry().registerSmithingTemplateItem("flaming_ruby_upgrade", SmithingTemplates.ARMOR_AND_TOOLS, List.of(NetherTemplates.EMPTY_SLOT_BLOCK));
        NetherTemplates.CINCINNASITE_DIAMOND_TEMPLATE = NetherItems.getItemRegistry().registerSmithingTemplateItem("cincinnasite_diamond_upgrade", List.of(SmithingTemplates.EMPTY_SLOT_DIAMOND), List.of(SmithingTemplates.EMPTY_SLOT_INGOT));
    }

    public static Item makeEgg(String name, EntityType<? extends Mob> type, int background, int dots) {
        SpawnEggItem egg = new SpawnEggItem(type, background, dots, NetherItems.defaultSettings());
        return NetherItems.getItemRegistry().registerEgg(name, egg, new TagKey[0]);
    }

    public static Item registerNetherItem(String name, Item item) {
        return NetherItems.getItemRegistry().register(name, item, new TagKey[0]);
    }

    private static CompoundTag buildItem(int count, Item item, ResourceKey<Enchantment> ... enchantments) {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
        CompoundTag tag = new CompoundTag();
        tag.putString("id", id.toString());
        tag.putByte("Count", (byte)count);
        if (enchantments.length > 0 && WorldState.registryAccess() != null) {
            ListTag chants = new ListTag();
            Registry enchReg = WorldState.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
            tag.put("Enchantments", (Tag)chants);
            for (ResourceKey<Enchantment> e : enchantments) {
                Enchantment ench = (Enchantment)enchReg.get(e);
                CompoundTag eTag = new CompoundTag();
                eTag.putInt("lvl", ench.getMaxLevel());
                eTag.putString("id", e.location().toString());
                chants.add((Object)eTag);
            }
        }
        return tag;
    }

    @NotNull
    private static CompoundTag buildCitySpawnerData() {
        ListTag handItems = new ListTag();
        handItems.add((Object)NetherItems.buildItem(1, CINCINNASITE_DIAMOND_SET.get(ToolSlot.SWORD_SLOT), new ResourceKey[0]));
        handItems.add((Object)NetherItems.buildItem(1, Items.SHIELD, new ResourceKey[0]));
        ListTag armorItems = new ListTag();
        armorItems.add((Object)NetherItems.buildItem(1, CINCINNASITE_SET.get(ArmorSlot.BOOTS_SLOT), Enchantments.PROTECTION));
        armorItems.add((Object)NetherItems.buildItem(1, CINCINNASITE_SET.get(ArmorSlot.LEGGINGS_SLOT), Enchantments.PROTECTION));
        armorItems.add((Object)NetherItems.buildItem(1, CINCINNASITE_SET.get(ArmorSlot.CHESTPLATE_SLOT), Enchantments.PROTECTION, Enchantments.THORNS));
        armorItems.add((Object)NetherItems.buildItem(1, CINCINNASITE_SET.get(ArmorSlot.HELMET_SLOT), Enchantments.PROTECTION));
        ListTag handDropChance = new ListTag();
        handDropChance.add((Object)FloatTag.valueOf((float)0.0f));
        handDropChance.add((Object)FloatTag.valueOf((float)0.0f));
        ListTag armorDropChance = new ListTag();
        armorDropChance.add((Object)FloatTag.valueOf((float)0.0f));
        armorDropChance.add((Object)FloatTag.valueOf((float)0.0f));
        armorDropChance.add((Object)FloatTag.valueOf((float)0.0f));
        armorDropChance.add((Object)FloatTag.valueOf((float)0.0f));
        CompoundTag entity = new CompoundTag();
        entity.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.WITHER_SKELETON).toString());
        entity.putBoolean("PersistenceRequired", true);
        entity.put("HandItems", (Tag)handItems);
        entity.put("ArmorItems", (Tag)armorItems);
        entity.put("HandDropChances", (Tag)handDropChance);
        entity.put("ArmorDropChances", (Tag)armorDropChance);
        CompoundTag skyLightLimit = new CompoundTag();
        skyLightLimit.putByte("max_inclusive", (byte)13);
        CompoundTag blockLightLimit = new CompoundTag();
        skyLightLimit.putByte("max_inclusive", (byte)13);
        CompoundTag customSpawnRules = new CompoundTag();
        customSpawnRules.put("sky_light_limit", (Tag)skyLightLimit);
        customSpawnRules.put("block_light_limit", (Tag)blockLightLimit);
        CompoundTag spawnData = new CompoundTag();
        spawnData.put("entity", (Tag)entity);
        spawnData.put("custom_spawn_rules", (Tag)customSpawnRules);
        CompoundTag root = new CompoundTag();
        root.putShort("SpawnRange", (short)4);
        root.putShort("SpawnCount", (short)8);
        root.putShort("MaxNearbyEntities", (short)18);
        root.putShort("Delay", (short)499);
        root.putShort("MinSpawnDelay", (short)300);
        root.putShort("MaxSpawnDelay", (short)1600);
        root.putShort("RequiredPlayerRange", (short)20);
        root.put("SpawnData", (Tag)spawnData);
        return root;
    }

    @ApiStatus.Internal
    public static void register() {
        NetherItems.getItemRegistry();
    }

    private static void registerItems() {
        if (itemsRegistered) {
            return;
        }
        itemsRegistered = true;
        NetherItems.registerSmithingTemplates();
        BLACK_APPLE = NetherItems.registerItem("black_apple", new ItemBlackApple(), new TagKey[0]);
        STALAGNATE_BOWL = NetherItems.registerItem("stalagnate_bowl", new ItemBowlFood(null, BNBlockProperties.FoodShape.NONE), new TagKey[0]);
        STALAGNATE_BOWL_WART = NetherItems.registerItem("stalagnate_bowl_wart", new ItemBowlFood(Foods.COOKED_CHICKEN, BNBlockProperties.FoodShape.WART), new TagKey[0]);
        STALAGNATE_BOWL_MUSHROOM = NetherItems.registerItem("stalagnate_bowl_mushroom", new ItemBowlFood(Foods.MUSHROOM_STEW, BNBlockProperties.FoodShape.MUSHROOM), new TagKey[0]);
        STALAGNATE_BOWL_APPLE = NetherItems.registerItem("stalagnate_bowl_apple", new ItemBowlFood(Foods.APPLE, BNBlockProperties.FoodShape.APPLE), new TagKey[0]);
        HOOK_MUSHROOM_COOKED = NetherItems.registerFood("hook_mushroom_cooked", 4, 0.4f);
        CINCINNASITE = NetherItems.registerItem("cincinnasite", new Item(NetherItems.defaultSettings()), new TagKey[0]);
        CINCINNASITE_INGOT = NetherItems.registerItem("cincinnasite_ingot", new Item(NetherItems.defaultSettings()), new TagKey[0]);
        NETHER_RUBY = NetherItems.registerItem("nether_ruby", new Item(NetherItems.defaultSettings()), new TagKey[0]);
        CINCINNASITE_SET = new NetherSet("cincinnasite", BNToolTiers.CINCINNASITE, BNArmorTiers.CINCINNASITE, true);
        NETHER_RUBY_SET = new NetherSet("nether_ruby", BNToolTiers.NETHER_RUBY, BNArmorTiers.NETHER_RUBY, false);
        CINCINNASITE_DIAMOND_SET = new DiamondSet(CINCINNASITE_SET);
        FLAMING_RUBY_SET = new NetherSet("flaming_ruby", BNToolTiers.FLAMING_RUBY, BNArmorTiers.FLAMING_RUBY, false, NETHER_RUBY_SET);
        CINCINNASITE_HAMMER = NetherItems.registerItem("cincinnasite_hammer", VanillaHammersIntegration.makeHammer(BNToolMaterial.CINCINNASITE, 4, -2.0f), new TagKey[0]);
        CINCINNASITE_HAMMER_DIAMOND = NetherItems.registerItem("cincinnasite_hammer_diamond", VanillaHammersIntegration.makeHammer(BNToolMaterial.CINCINNASITE_DIAMOND, 5, -2.0f), new TagKey[0]);
        NETHER_RUBY_HAMMER = NetherItems.registerItem("nether_ruby_hammer", VanillaHammersIntegration.makeHammer(BNToolMaterial.NETHER_RUBY, 5, -2.0f), new TagKey[0]);
        CINCINNASITE_EXCAVATOR = NetherItems.registerItem("cincinnasite_excavator", VanillaExcavatorsIntegration.makeExcavator(BNToolMaterial.CINCINNASITE, 4, -1.6f), new TagKey[0]);
        CINCINNASITE_EXCAVATOR_DIAMOND = NetherItems.registerItem("cincinnasite_excavator_diamond", VanillaExcavatorsIntegration.makeExcavator(BNToolMaterial.CINCINNASITE_DIAMOND, 5, -2.0f), new TagKey[0]);
        NETHER_RUBY_EXCAVATOR = NetherItems.registerItem("nether_ruby_excavator", VanillaExcavatorsIntegration.makeExcavator(BNToolMaterial.NETHER_RUBY, 5, -2.0f), new TagKey[0]);
        GLOWSTONE_PILE = NetherItems.registerItem("glowstone_pile", new Item(NetherItems.defaultSettings()), new TagKey[0]);
        LAPIS_PILE = NetherItems.registerItem("lapis_pile", new Item(NetherItems.defaultSettings()), new TagKey[0]);
        AGAVE_LEAF = NetherItems.registerItem("agave_leaf", new Item(NetherItems.defaultSettings()), new TagKey[0]);
        AGAVE_MEDICINE = NetherItems.registerMedicine("agave_medicine", 40, 2, true);
        HERBAL_MEDICINE = NetherItems.registerMedicine("herbal_medicine", 10, 5, true);
        if (BCLib.isDevEnvironment()) {
            BetterNether.C.log.warn("Generating Debug Helpers");
            NetherItems.registerNetherItem("debug/city_loot", (Item)DebugDataItem.forLootTable(BNLoot.CITY_LOOT, (Item)Items.IRON_INGOT));
            NetherItems.registerNetherItem("debug/city_loot_common", (Item)DebugDataItem.forLootTable(BNLoot.CITY_LOOT_COMMON, (Item)Items.GOLD_INGOT));
            NetherItems.registerNetherItem("debug/city_loot_surprise", (Item)DebugDataItem.forLootTable(BNLoot.CITY_LOOT_SURPRISE, (Item)Items.DIAMOND));
            NetherItems.registerNetherItem("debug/wither_tower_loot", (Item)DebugDataItem.forLootTable(BNLoot.WITHER_TOWER_LOOT, (Item)CINCINNASITE_INGOT));
            NetherItems.registerNetherItem("debug/wither_tower_bonus_loot", (Item)DebugDataItem.forLootTable(BNLoot.WITHER_TOWER_BONUS_LOOT, (Item)NETHER_RUBY));
            NetherItems.registerNetherItem("debug/city_spawner", (Item)DebugDataItem.forSpawner(NetherItems::buildCitySpawnerData, (Item)Items.SPECTRAL_ARROW));
        }
    }

    static {
        NetherItems.getItemRegistry();
    }
}

