/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world;

import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.betterx.betternether.registry.NetherEntities;
import org.betterx.betternether.world.biomes.util.NetherBiomeBuilder;
import org.betterx.wover.biome.api.builder.BiomeSurfaceRuleBuilder;
import org.betterx.wover.surface.impl.BaseSurfaceRuleBuilder;

public abstract class NetherBiomeConfig {
    public static final SurfaceRules.RuleSource NETHERRACK = SurfaceRules.state((BlockState)Blocks.NETHERRACK.defaultBlockState());
    public static final SurfaceRules.RuleSource BEDROCK_BOTTOM = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NetherBiomeBuilder.BEDROCK_BOTTOM, (SurfaceRules.RuleSource)NetherBiomeBuilder.BEDROCK);
    public static final SurfaceRules.RuleSource BEDROCK_TOP = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)NetherBiomeBuilder.BEDROCK_TOP), (SurfaceRules.RuleSource)NetherBiomeBuilder.BEDROCK);

    protected NetherBiomeConfig() {
    }

    public ResourceKey<Biome> subBiomeOf() {
        return null;
    }

    public ResourceKey<Biome> withEdgeBiome() {
        return null;
    }

    public boolean hasVanillaFeatures() {
        return true;
    }

    public boolean hasVanillaOres() {
        return true;
    }

    public boolean hasStalactites() {
        return false;
    }

    public boolean hasDefaultOres() {
        return true;
    }

    public boolean hasNetherCity() {
        return true;
    }

    public boolean hasVanillaStructures() {
        return true;
    }

    public boolean hasBNStructures() {
        return true;
    }

    public boolean hasBNFeatures() {
        return true;
    }

    public <M extends Mob> int spawnWeight(NetherEntities.KnownSpawnTypes type) {
        int res = type.weight;
        switch (type) {
            case JUNGLE_SKELETON: 
            case FLYING_PIG: 
            case HOGLIN: 
            case PIGLIN_BRUTE: {
                res = 0;
            }
        }
        return res;
    }

    public abstract void addCustomBuildData(NetherBiomeBuilder var1);

    public void surface(BiomeSurfaceRuleBuilder<NetherBiomeBuilder> builder) {
        ((BiomeSurfaceRuleBuilder)((BiomeSurfaceRuleBuilder)builder.rule(BEDROCK_TOP, BaseSurfaceRuleBuilder.STEEP_SURFACE_PRIORITY + 2)).rule(BEDROCK_BOTTOM, BaseSurfaceRuleBuilder.STEEP_SURFACE_PRIORITY + 1)).rule(NETHERRACK, BaseSurfaceRuleBuilder.FILLER_PRIORITY - 1);
    }
}

