/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.blocks.BlockPlantWall;
import org.betterx.betternether.noise.OpenSimplexNoise;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.ContextFeature;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;
import org.betterx.betternether.world.structures.plants.LegacyStructureAnchorTree;

public class AnchorTreeFeature
extends ContextFeature<NoneFeatureConfiguration> {
    protected static final OpenSimplexNoise NOISE = new OpenSimplexNoise(2145L);
    private static final Supplier<Block[]> WALL_PLANTS = () -> new Block[]{NetherBlocks.JUNGLE_MOSS, NetherBlocks.JUNGLE_MOSS, NetherBlocks.WALL_MUSHROOM_BROWN, NetherBlocks.WALL_MUSHROOM_RED};
    private final LegacyStructureAnchorTree legacyStructure = new LegacyStructureAnchorTree();

    public AnchorTreeFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public static Block[] wallPlants() {
        return WALL_PLANTS.get();
    }

    private static int toMiddle(int val) {
        return val + (7 - (val & 0xF));
    }

    @Override
    protected boolean place(ServerLevelAccessor world, BlockPos pos, RandomSource random, NoneFeatureConfiguration config, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        pos = new BlockPos(AnchorTreeFeature.toMiddle(pos.getX()), pos.getY(), AnchorTreeFeature.toMiddle(pos.getZ()));
        BlockPos down = pos.below(BlocksHelper.downRay((LevelAccessor)world, pos, MAX_HEIGHT));
        if (this.canGenerate(pos)) {
            this.grow(world, pos, down, random, MAX_HEIGHT, context);
            return true;
        }
        return false;
    }

    private boolean canGenerate(BlockPos pos) {
        return true;
    }

    private void grow(ServerLevelAccessor level, BlockPos up, BlockPos down, RandomSource random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        float scale_factor = (float)MAX_HEIGHT / 128.0f;
        int HEIGHT_64 = (int)((double)MAX_HEIGHT / 4.0 + (double)MHelper.nextFloat(random, 32.0f));
        int HEIGHT_45 = (int)(20.0f + MHelper.nextFloat(random, 20.0f * scale_factor));
        int HEIGHT_90 = (int)((double)MAX_HEIGHT / 2.0 + (double)MHelper.nextFloat(random, 15.0f * scale_factor));
        int SEGMENT_LENGTH = (int)((15.0f + MHelper.nextFloat(random, 5.0f * scale_factor)) * scale_factor);
        if (up.getY() - down.getY() < 30) {
            return;
        }
        int pd = BlocksHelper.downRay((LevelAccessor)level, down, MAX_HEIGHT) + 1;
        for (int i = 0; i < 5; ++i) {
            Block block = level.getBlockState(down.below(pd + i)).getBlock();
            if (block != Blocks.NETHER_BRICKS && block != NetherBlocks.NETHER_BRICK_TILE_LARGE && block != NetherBlocks.NETHER_BRICK_TILE_SMALL) continue;
            return;
        }
        BlockPos trunkTop = this.lerp(down, up, 0.6);
        BlockPos trunkBottom = this.lerp(down, up, 0.3);
        int count = (trunkTop.getY() - trunkBottom.getY()) / 7;
        if (count < 2) {
            count = 2;
        }
        List<BlockPos> blocks = this.line(trunkBottom, trunkTop, count, random, 2.5);
        context.BLOCKS.clear();
        count = Math.min(7, Math.max(3, (up.getY() - down.getY()) / (int)(10.0f * scale_factor) - 1));
        double radius = Math.min(7.0, Math.max(3.5, (double)((up.getY() - down.getY()) / 15)));
        this.drawLine(level, blocks, radius + 0.5 * (double)scale_factor, MAX_HEIGHT, context);
        this.buildBigCircle(level, up, trunkTop, SEGMENT_LENGTH, count, 2, random.nextDouble() * Math.PI * 2.0, radius, random, MAX_HEIGHT, context);
        this.buildBigCircle(level, up, trunkBottom, -SEGMENT_LENGTH, count, 2, random.nextDouble() * Math.PI * 2.0, radius, random, MAX_HEIGHT, context);
        int offset = random.nextInt(4);
        int minBuildHeight = level.getMinBuildHeight() + 1;
        BoundingBox blockBox = BlocksHelper.decorationBounds((LevelAccessor)level, up, minBuildHeight, MAX_HEIGHT - 2);
        for (BlockPos bpos : context.BLOCKS) {
            BlockState state;
            if (!blockBox.isInside((Vec3i)bpos) || !BlocksHelper.isNetherGround(state = level.getBlockState(bpos)) && !state.canBeReplaced()) continue;
            boolean blockUp = true;
            blockUp = context.BLOCKS.contains(bpos.above());
            if (blockUp && context.BLOCKS.contains(bpos.below())) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)level, bpos, NetherBlocks.MAT_ANCHOR_TREE.getLog().defaultBlockState());
            } else {
                BlocksHelper.setWithoutUpdate((LevelAccessor)level, bpos, NetherBlocks.MAT_ANCHOR_TREE.getBark().defaultBlockState());
            }
            if (bpos.getY() > HEIGHT_45 && bpos.getY() < HEIGHT_90 && (bpos.getY() & 3) == offset && NOISE.eval((double)bpos.getX() * 0.1, (double)bpos.getY() * 0.1, (double)bpos.getZ() * 0.1) > 0.0) {
                if (random.nextInt((int)(32.0f * scale_factor)) == 0 && !context.BLOCKS.contains(bpos.north())) {
                    AnchorTreeFeature.makeMushroom(level, bpos.north(), random.nextDouble() * 3.0 + 1.5, blockBox);
                }
                if (random.nextInt((int)(32.0f * scale_factor)) == 0 && !context.BLOCKS.contains(bpos.south())) {
                    AnchorTreeFeature.makeMushroom(level, bpos.south(), random.nextDouble() * 3.0 + 1.5, blockBox);
                }
                if (random.nextInt((int)(32.0f * scale_factor)) == 0 && !context.BLOCKS.contains(bpos.east())) {
                    AnchorTreeFeature.makeMushroom(level, bpos.east(), random.nextDouble() * 3.0 + 1.5, blockBox);
                }
                if (random.nextInt((int)(32.0f * scale_factor)) == 0 && !context.BLOCKS.contains(bpos.west())) {
                    AnchorTreeFeature.makeMushroom(level, bpos.west(), random.nextDouble() * 3.0 + 1.5, blockBox);
                }
            }
            if (bpos.getY() <= HEIGHT_64) continue;
            if (!blockUp && level.getBlockState(bpos.above()).canBeReplaced()) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)level, bpos.above(), NetherBlocks.MOSS_COVER.defaultBlockState());
            }
            if (!(NOISE.eval((double)bpos.getX() * 0.05, (double)bpos.getY() * 0.05, (double)bpos.getZ() * 0.05) > 0.0)) continue;
            Block[] wallPlants = AnchorTreeFeature.wallPlants();
            state = wallPlants[random.nextInt(wallPlants.length)].defaultBlockState();
            BlockPos _pos = bpos.north();
            if (random.nextInt(8) == 0 && !context.BLOCKS.contains(_pos) && level.isEmptyBlock(_pos) && _pos.getZ() >= blockBox.minZ()) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)level, _pos, (BlockState)state.setValue((Property)BlockPlantWall.FACING, (Comparable)Direction.NORTH));
            }
            _pos = bpos.south();
            if (random.nextInt(8) == 0 && !context.BLOCKS.contains(_pos) && level.isEmptyBlock(_pos) && _pos.getZ() <= blockBox.maxZ()) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)level, _pos, (BlockState)state.setValue((Property)BlockPlantWall.FACING, (Comparable)Direction.SOUTH));
            }
            _pos = bpos.east();
            if (random.nextInt(8) == 0 && !context.BLOCKS.contains(_pos) && level.isEmptyBlock(_pos) && _pos.getX() <= blockBox.maxX()) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)level, _pos, (BlockState)state.setValue((Property)BlockPlantWall.FACING, (Comparable)Direction.EAST));
            }
            _pos = bpos.west();
            if (random.nextInt(8) != 0 || context.BLOCKS.contains(_pos) || !level.isEmptyBlock(_pos) || _pos.getX() < blockBox.minX()) continue;
            BlocksHelper.setWithoutUpdate((LevelAccessor)level, _pos, (BlockState)state.setValue((Property)BlockPlantWall.FACING, (Comparable)Direction.WEST));
        }
    }

    private void buildBigCircle(ServerLevelAccessor level, BlockPos seedPos, BlockPos pos, int length, int count, int iteration, double angle, double size, RandomSource random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        if (iteration < 0) {
            return;
        }
        List<List<BlockPos>> lines = this.circleLinesEnds(level, seedPos, pos, angle, count, length, (double)Math.abs(length) * 0.7, random, iteration == 0, MAX_HEIGHT);
        double sizeSmall = size * 0.8;
        length = (int)((double)length * 0.8);
        angle += Math.PI * 4 / (double)count;
        angle += random.nextDouble() * angle * 0.75;
        for (List<BlockPos> line : lines) {
            this.drawLine(level, line, size, MAX_HEIGHT, context);
            this.buildBigCircle(level, seedPos, line.get(1), length, count, iteration - 1, angle, sizeSmall, random, MAX_HEIGHT, context);
        }
    }

    private void drawLine(ServerLevelAccessor level, List<BlockPos> blocks, double radius, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        for (int i = 0; i < blocks.size() - 1; ++i) {
            double max;
            BlockPos a = blocks.get(i);
            BlockPos b = blocks.get(i + 1);
            if (b.getY() < a.getY()) {
                BlockPos c = b;
                b = a;
                a = c;
            }
            if ((max = (double)(b.getY() - a.getY())) < 1.0) {
                max = 1.0;
            }
            for (int y = a.getY(); y <= b.getY(); ++y) {
                this.cylinder(this.lerpCos(a, b, y, (double)(y - a.getY()) / max), radius, MAX_HEIGHT, context);
            }
        }
    }

    private BlockPos lerp(BlockPos start, BlockPos end, double mix) {
        double x = Mth.lerp((double)mix, (double)start.getX(), (double)end.getX());
        double y = Mth.lerp((double)mix, (double)start.getY(), (double)end.getY());
        double z = Mth.lerp((double)mix, (double)start.getZ(), (double)end.getZ());
        return new BlockPos((int)x, (int)y, (int)z);
    }

    private BlockPos lerpCos(BlockPos start, BlockPos end, int y, double mix) {
        double v = this.lcos(mix);
        double x = Mth.lerp((double)v, (double)start.getX(), (double)end.getX());
        double z = Mth.lerp((double)v, (double)start.getZ(), (double)end.getZ());
        return new BlockPos((int)x, y, (int)z);
    }

    private double lcos(double mix) {
        return Mth.clamp((double)(0.5 - Math.cos(mix * Math.PI) * 0.5), (double)0.0, (double)1.0);
    }

    private List<BlockPos> line(BlockPos start, BlockPos end, int count, RandomSource random, double range) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>(count);
        int max = count - 1;
        result.add(start);
        for (int i = 1; i < max; ++i) {
            double delta = (double)i / (double)max;
            double x = Mth.lerp((double)delta, (double)start.getX(), (double)end.getX()) + random.nextGaussian() * range;
            double y = Mth.lerp((double)delta, (double)start.getY(), (double)end.getY());
            double z = Mth.lerp((double)delta, (double)start.getZ(), (double)end.getZ()) + random.nextGaussian() * range;
            result.add(new BlockPos((int)x, (int)y, (int)z));
        }
        result.add(end);
        return result;
    }

    private void cylinder(BlockPos pos, double radius, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        int x1 = MHelper.floor((double)pos.getX() - radius);
        int z1 = MHelper.floor((double)pos.getZ() - radius);
        int x2 = MHelper.floor((double)pos.getX() + radius + 1.0);
        int z2 = MHelper.floor((double)pos.getZ() + radius + 1.0);
        radius *= radius;
        for (int x = x1; x <= x2; ++x) {
            int px2 = x - pos.getX();
            px2 *= px2;
            for (int z = z1; z <= z2; ++z) {
                int pz2 = z - pos.getZ();
                if (!((double)(px2 + (pz2 *= pz2)) <= radius * (NOISE.eval((double)x * 0.5, (double)pos.getY() * 0.5, (double)z * 0.5) * 0.25 + 0.75)) || pos.getY() <= 2 || pos.getY() >= MAX_HEIGHT - 2) continue;
                context.BLOCKS.add(new BlockPos(x, pos.getY(), z));
            }
        }
    }

    private List<List<BlockPos>> circleLinesEnds(ServerLevelAccessor level, BlockPos seedPos, BlockPos pos, double startAngle, int count, int length, double inRadius, RandomSource random, boolean findSurface, int MAX_HEIGHT) {
        int MAX_DIST = 16;
        ArrayList<List<BlockPos>> result = new ArrayList<List<BlockPos>>(count);
        double angle = Math.PI * 2 / (double)count;
        for (int i = 0; i < count; ++i) {
            double z;
            double radius = inRadius * (MHelper.nextDouble(random, 0.25) + 0.8);
            double x = (double)pos.getX() + Math.sin(startAngle) * radius;
            if (x - (double)seedPos.getX() > 16.0) {
                x = seedPos.getX() + 16 - random.nextInt(10);
            }
            if (x - (double)seedPos.getX() < -16.0) {
                x = seedPos.getX() - 16 + random.nextInt(10);
            }
            if ((z = (double)pos.getZ() + Math.cos(startAngle) * radius) - (double)seedPos.getZ() > 16.0) {
                z = seedPos.getZ() + 16 - random.nextInt(10);
            }
            if (z - (double)seedPos.getZ() < -16.0) {
                z = seedPos.getZ() - 16 + random.nextInt(10);
            }
            BlockPos end = new BlockPos((int)x, (int)((double)(pos.getY() + length) + (double)length * random.nextDouble() * 0.5), (int)z);
            ArrayList<BlockPos> elem = new ArrayList<BlockPos>(2);
            elem.add(pos);
            elem.add(end);
            result.add(elem);
            if (findSurface && end.getY() > 2 && end.getY() < MAX_HEIGHT - 2) {
                int dist;
                int n = dist = length < 0 ? -BlocksHelper.downRay((LevelAccessor)level, end, Math.abs(length * 2)) : BlocksHelper.upRay((LevelAccessor)level, end, Math.abs(length * 2));
                if (dist > 0) {
                    if (Math.abs((double)seedPos.getX() - x) > 16.0 || Math.abs((double)seedPos.getZ() - z) > 16.0) {
                        radius = 2.0;
                    }
                    result.addAll(this.circleLinesEnds(level, seedPos, end, MHelper.nextFloat(random, 360.0f), radius < 5.0 ? 1 : count % 2 + 1, dist, radius / 2.0, random, findSurface, MAX_HEIGHT));
                }
            }
            startAngle += angle;
        }
        return result;
    }

    protected static void makeMushroom(ServerLevelAccessor world, BlockPos pos, double radius, BoundingBox bounds) {
        if (!world.getBlockState(pos).canBeReplaced()) {
            return;
        }
        int x1 = MHelper.floor((double)pos.getX() - radius);
        int z1 = MHelper.floor((double)pos.getZ() - radius);
        int x2 = MHelper.floor((double)pos.getX() + radius + 1.0);
        int z2 = MHelper.floor((double)pos.getZ() + radius + 1.0);
        radius *= radius;
        ArrayList<BlockPos> placed = new ArrayList<BlockPos>((int)(radius * 4.0));
        for (int x = x1; x <= x2; ++x) {
            int px2 = x - pos.getX();
            px2 *= px2;
            for (int z = z1; z <= z2; ++z) {
                BlockPos p;
                int pz2 = z - pos.getZ();
                if (!((double)(px2 + (pz2 *= pz2)) <= radius) || !world.getBlockState(p = new BlockPos(x, pos.getY(), z)).canBeReplaced() || !bounds.isInside((Vec3i)p)) continue;
                placed.add(p);
            }
        }
        for (BlockPos p : placed) {
            boolean north = world.getBlockState(p.north()).getBlock() != NetherBlocks.GIANT_LUCIS;
            boolean south = world.getBlockState(p.south()).getBlock() != NetherBlocks.GIANT_LUCIS;
            boolean east = world.getBlockState(p.east()).getBlock() != NetherBlocks.GIANT_LUCIS;
            boolean west = world.getBlockState(p.west()).getBlock() != NetherBlocks.GIANT_LUCIS;
            BlockState state = NetherBlocks.GIANT_LUCIS.defaultBlockState();
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, p, (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)HugeMushroomBlock.NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)HugeMushroomBlock.SOUTH, (Comparable)Boolean.valueOf(south))).setValue((Property)HugeMushroomBlock.EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)HugeMushroomBlock.WEST, (Comparable)Boolean.valueOf(west)));
        }
    }
}

