/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.noise.OpenSimplexNoise;
import org.betterx.betternether.world.features.NetherSurfaceFeature;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public class CrystalFeature
extends NetherSurfaceFeature {
    private static final ResourceLocation[] PALETTE_IDS = new ResourceLocation[]{BetterNether.C.id("obsidian_glass"), BuiltInRegistries.BLOCK.getKey((Object)Blocks.OBSIDIAN), BetterNether.C.id("blue_obsidian_glass"), BetterNether.C.id("blue_obsidian")};
    private static final ResourceLocation BLUE_WEEPING_OBSIDIAN_ID = BetterNether.C.id("blue_weeping_obsidian");
    private static final ResourceLocation WEEPING_OBSIDIAN_ID = BetterNether.C.id("weeping_obsidian");
    private static final ResourceLocation BLUE_CRYING_OBSIDIAN_ID = BetterNether.C.id("blue_crying_obsidian");
    private static final double SQRT05 = Math.sqrt(0.5);
    private static final float MAX_ANGLE_X = (float)Math.toRadians(45.0);
    private static final float MAX_ANGLE_Y = (float)Math.PI * 2;
    private static final float MAX_ANGLE_Z = (float)Math.toRadians(30.0);
    private static final OpenSimplexNoise NOISE = new OpenSimplexNoise(0L);

    @Override
    protected void generate(ServerLevelAccessor world, BlockPos pos, RandomSource random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        BlockPos.MutableBlockPos POS = context.POS;
        float scale_factor = ((float)MAX_HEIGHT / 128.0f - 1.0f) * 0.5f + 1.0f;
        int index = random.nextInt(PALETTE_IDS.length >> 1);
        boolean isBlue = index == 1;
        double a = random.nextDouble();
        double radius = 2.0 + a * a * 5.0 * (double)scale_factor;
        int sideXZ = (int)Math.ceil(radius * 2.0);
        int sideY = (int)Math.ceil(radius * 3.0);
        float angleX = random.nextFloat() * MAX_ANGLE_X;
        float angleY = random.nextFloat() * ((float)Math.PI * 2);
        float angleZ = (random.nextFloat() * 2.0f - 1.0f) * MAX_ANGLE_Z;
        for (int y = -sideY; y <= sideY; ++y) {
            for (int x = -sideXZ; x <= sideXZ; ++x) {
                for (int z = -sideXZ; z <= sideXZ; ++z) {
                    Vec3 v = new Vec3((double)x, (double)y, (double)z).zRot(angleZ).xRot(angleX).yRot(angleY);
                    double d = this.depth(v.x, v.y, v.z, radius);
                    if (!(d <= 0.0)) continue;
                    POS.setX(pos.getX() + x);
                    POS.setY(pos.getY() + y);
                    POS.setZ(pos.getZ() + z);
                    if (POS.getY() <= 0 || POS.getY() >= MAX_HEIGHT - 2) continue;
                    BlockState state = d <= -0.3 ? (random.nextInt(12) == 0 ? (isBlue ? CrystalFeature.blockFromId(BLUE_WEEPING_OBSIDIAN_ID, Blocks.OBSIDIAN) : CrystalFeature.blockFromId(WEEPING_OBSIDIAN_ID, Blocks.OBSIDIAN)).defaultBlockState() : this.getState(index, v)) : (d <= -0.15 ? (random.nextInt(9) == 0 ? (isBlue ? CrystalFeature.blockFromId(BLUE_CRYING_OBSIDIAN_ID, Blocks.CRYING_OBSIDIAN) : Blocks.CRYING_OBSIDIAN).defaultBlockState() : this.getState(index, v)) : (this.isNotEdge(v.x, v.y, v.z, radius) ? (random.nextInt(20) == 0 ? Blocks.GLOWSTONE.defaultBlockState() : this.getState(index, v)) : (random.nextInt(50) == 0 ? (random.nextInt(4) == 0 ? (isBlue ? CrystalFeature.blockFromId(BLUE_WEEPING_OBSIDIAN_ID, Blocks.OBSIDIAN) : CrystalFeature.blockFromId(WEEPING_OBSIDIAN_ID, Blocks.OBSIDIAN)).defaultBlockState() : (isBlue ? CrystalFeature.blockFromId(BLUE_CRYING_OBSIDIAN_ID, Blocks.CRYING_OBSIDIAN) : Blocks.CRYING_OBSIDIAN).defaultBlockState()) : this.getState(index, v))));
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)POS, state);
                }
            }
        }
    }

    private double depth(double x, double y, double z, double size) {
        return this.dodecahedronSDF(x / size, y / size * 0.3, z / size);
    }

    private boolean isInside(double x, double y, double z, double size) {
        return this.dodecahedronSDF(x / size, y / size * 0.3, z / size) <= 0.0;
    }

    private boolean isNotEdge(double x, double y, double z, double size) {
        return this.isInside(x + 1.0, y, z, size) && this.isInside(x - 1.0, y, z, size) && this.isInside(x, y + 1.0, z, size) && this.isInside(x, y - 1.0, z, size) && this.isInside(x, y, z + 1.0, size) && this.isInside(x, y, z - 1.0, size);
    }

    private double dodecahedronSDF(double x, double y, double z) {
        x = Math.abs(x);
        y = Math.abs(y);
        z = Math.abs(z);
        return (Math.max(Math.max(x + y, y + z), z + x) - 1.0) * SQRT05;
    }

    private double rigidNoise(Vec3 pos, double scale) {
        double val = NOISE.eval(pos.x * scale, pos.y * scale, pos.z * scale);
        return Math.abs(val);
    }

    private BlockState getState(int index, Vec3 pos) {
        int subindex = this.rigidNoise(pos, 0.2) > 0.2 ? 0 : 1;
        int blockIndex = index << 1 | subindex;
        return CrystalFeature.paletteState(blockIndex);
    }

    private static BlockState paletteState(int index) {
        ResourceLocation id = PALETTE_IDS[index];
        Block block = (Block)BuiltInRegistries.BLOCK.get(id);
        if (block == Blocks.AIR) {
            block = Blocks.OBSIDIAN;
        }
        return block.defaultBlockState();
    }

    private static Block blockFromId(ResourceLocation id, Block fallback) {
        Block block = (Block)BuiltInRegistries.BLOCK.get(id);
        return block == Blocks.AIR ? fallback : block;
    }
}

