/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BlockMushroomFir;
import org.betterx.betternether.blocks.BlockNetherMycelium;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.ContextFeature;
import org.betterx.betternether.world.features.NetherThreadDataStorage;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;
import org.betterx.wover.feature.api.features.GrowableFeature;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class MushroomFirFeature
extends ContextFeature<NoneFeatureConfiguration>
implements GrowableFeature<NoneFeatureConfiguration> {
    private static final Map<BlockMushroomFir.MushroomFirShape, BlockState> STATE_CACHE = new EnumMap<BlockMushroomFir.MushroomFirShape, BlockState>(BlockMushroomFir.MushroomFirShape.class);

    private static BlockState state(BlockMushroomFir.MushroomFirShape shape) {
        return STATE_CACHE.computeIfAbsent(shape, s -> (BlockState)NetherBlocks.MAT_MUSHROOM_FIR.getTrunk().defaultBlockState().setValue(BlockMushroomFir.SHAPE, (Comparable)((Object)s)));
    }

    private static BlockState blueMycelium() {
        return (BlockState)NetherBlocks.NETHER_MYCELIUM.defaultBlockState().setValue((Property)BlockNetherMycelium.IS_BLUE, (Comparable)Boolean.valueOf(true));
    }

    public MushroomFirFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    @Override
    protected boolean place(ServerLevelAccessor level, BlockPos pos, RandomSource random, NoneFeatureConfiguration config, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        if (!level.getBlockState(pos.below()).is(CommonBlockTags.MYCELIUM)) {
            return false;
        }
        float scale_factor = (float)MAX_HEIGHT / 128.0f;
        if (level.getBlockState(pos.below()).getBlock() == NetherBlocks.NETHER_MYCELIUM) {
            return this.grow(level, pos, random, scale_factor, context);
        }
        return false;
    }

    protected boolean grow(ServerLevelAccessor level, BlockPos pos, RandomSource random, float scale_factor, StructureGeneratorThreadContext context) {
        BlockPos branch;
        int y;
        int y2;
        int RANDOM_BOUND = (int)(5.0f * scale_factor);
        int h = 3 + random.nextInt(RANDOM_BOUND);
        for (int y3 = 1; y3 < h; ++y3) {
            if (level.isEmptyBlock(pos.above(y3))) continue;
            h = y3;
            break;
        }
        if (h < 3) {
            return false;
        }
        BlocksHelper.setWithUpdate((LevelAccessor)level, pos, MushroomFirFeature.state(BlockMushroomFir.MushroomFirShape.BOTTOM));
        int h2 = h + 1 >> 1;
        h += pos.getY();
        h2 += pos.getY();
        context.POS.set((Vec3i)pos);
        for (y2 = pos.getY() + 1; y2 < h2; ++y2) {
            context.POS.setY(y2);
            BlocksHelper.setWithUpdate((LevelAccessor)level, (BlockPos)context.POS, MushroomFirFeature.state(BlockMushroomFir.MushroomFirShape.MIDDLE));
        }
        for (y2 = h2; y2 < h; ++y2) {
            context.POS.setY(y2);
            BlocksHelper.setWithUpdate((LevelAccessor)level, (BlockPos)context.POS, MushroomFirFeature.state(BlockMushroomFir.MushroomFirShape.TOP));
        }
        int h3 = h2 + h >> 1;
        for (y = h2 - 1; y < h3; ++y) {
            context.POS.setY(y);
            if (random.nextBoolean() && level.isEmptyBlock(branch = context.POS.north())) {
                BlocksHelper.setWithUpdate((LevelAccessor)level, branch, MushroomFirFeature.state(BlockMushroomFir.MushroomFirShape.SIDE_BIG_S));
            }
            if (random.nextBoolean() && level.isEmptyBlock(branch = context.POS.south())) {
                BlocksHelper.setWithUpdate((LevelAccessor)level, branch, MushroomFirFeature.state(BlockMushroomFir.MushroomFirShape.SIDE_BIG_N));
            }
            if (random.nextBoolean() && level.isEmptyBlock(branch = context.POS.east())) {
                BlocksHelper.setWithUpdate((LevelAccessor)level, branch, MushroomFirFeature.state(BlockMushroomFir.MushroomFirShape.SIDE_BIG_W));
            }
            if (!random.nextBoolean() || !level.isEmptyBlock(branch = context.POS.west())) continue;
            BlocksHelper.setWithUpdate((LevelAccessor)level, branch, MushroomFirFeature.state(BlockMushroomFir.MushroomFirShape.SIDE_BIG_E));
        }
        for (y = h3; y < h; ++y) {
            context.POS.setY(y);
            if (random.nextBoolean() && level.isEmptyBlock(branch = context.POS.north())) {
                BlocksHelper.setWithUpdate((LevelAccessor)level, branch, MushroomFirFeature.state(BlockMushroomFir.MushroomFirShape.SIDE_SMALL_S));
            }
            if (random.nextBoolean() && level.isEmptyBlock(branch = context.POS.south())) {
                BlocksHelper.setWithUpdate((LevelAccessor)level, branch, MushroomFirFeature.state(BlockMushroomFir.MushroomFirShape.SIDE_SMALL_N));
            }
            if (random.nextBoolean() && level.isEmptyBlock(branch = context.POS.east())) {
                BlocksHelper.setWithUpdate((LevelAccessor)level, branch, MushroomFirFeature.state(BlockMushroomFir.MushroomFirShape.SIDE_SMALL_W));
            }
            if (!random.nextBoolean() || !level.isEmptyBlock(branch = context.POS.west())) continue;
            BlocksHelper.setWithUpdate((LevelAccessor)level, branch, MushroomFirFeature.state(BlockMushroomFir.MushroomFirShape.SIDE_SMALL_E));
        }
        context.POS.setY(h);
        if (level.isEmptyBlock((BlockPos)context.POS)) {
            BlocksHelper.setWithUpdate((LevelAccessor)level, (BlockPos)context.POS, MushroomFirFeature.state(BlockMushroomFir.MushroomFirShape.END));
        }
        BlocksHelper.cover((LevelAccessor)level, pos.below(), NetherBlocks.NETHER_MYCELIUM, MushroomFirFeature.blueMycelium(), 5, random);
        return true;
    }

    public boolean grow(ServerLevelAccessor level, BlockPos pos, RandomSource random, NoneFeatureConfiguration configuration) {
        return this.grow(level, pos, random, 1.0f, NetherThreadDataStorage.generatorForThread().context);
    }
}

