/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.betterx.bclib.complexmaterials.set.wood.WoodSlots;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.blocks.BNBlockProperties;
import org.betterx.betternether.blocks.BlockPlantWall;
import org.betterx.betternether.blocks.BlockWillowBranch;
import org.betterx.betternether.blocks.BlockWillowLeaves;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.NetherThreadDataStorage;
import org.betterx.betternether.world.features.NonOverlappingFeature;
import org.betterx.betternether.world.features.configs.NaturalTreeConfiguration;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;
import org.betterx.wover.feature.api.features.GrowableFeature;

public class OldWillowTree
extends NonOverlappingFeature<NaturalTreeConfiguration>
implements GrowableFeature<NaturalTreeConfiguration> {
    private static final float[] CURVE_X = new float[]{9.0f, 7.0f, 1.5f, 0.5f, 3.0f, 7.0f};
    private static final float[] CURVE_Y = new float[]{20.0f, 17.0f, 12.0f, 4.0f, 0.0f, -2.0f};
    private static final Supplier<Block[]> WALL_PLANTS = () -> new Block[]{NetherBlocks.WALL_MOSS, NetherBlocks.WALL_MOSS, NetherBlocks.WALL_MUSHROOM_BROWN, NetherBlocks.WALL_MUSHROOM_RED};

    public OldWillowTree() {
        super(NaturalTreeConfiguration.CODEC);
    }

    @Override
    protected boolean grow(ServerLevelAccessor world, BlockPos pos, RandomSource random, NaturalTreeConfiguration config, StructureGeneratorThreadContext context) {
        world.setBlock(pos, Blocks.AIR.defaultBlockState(), 0);
        float scale = MHelper.randRange(0.7f, 1.3f, random);
        int minCount = scale < 1.0f ? 3 : 4;
        int maxCount = scale < 1.0f ? 5 : 7;
        int count = MHelper.randRange(minCount, maxCount, random);
        BoundingBox blockBox = BlocksHelper.decorationBounds((LevelAccessor)world, pos);
        for (int n = 0; n < count; ++n) {
            float branchSize = MHelper.randRange(0.5f, 1.0f, random) * scale;
            float angle = (float)n * ((float)Math.PI * 2) / (float)count;
            float radius = CURVE_X[0] * branchSize;
            int x1 = Math.round((float)pos.getX() + radius * (float)Math.cos(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            int y1 = Math.round((float)pos.getY() + CURVE_Y[0] * branchSize + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            int z1 = Math.round((float)pos.getZ() + radius * (float)Math.sin(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            float crownR = 10.0f * branchSize;
            if (crownR < 1.5f) {
                crownR = 1.5f;
            }
            this.crown((LevelAccessor)world, new BlockPos(x1, y1 + 1, z1), crownR, random, blockBox);
            boolean generate = true;
            for (int i = 1; i < CURVE_X.length && generate; ++i) {
                radius = CURVE_X[i] * branchSize;
                int x2 = Math.round((float)pos.getX() + radius * (float)Math.cos(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
                int y2 = Math.round((float)pos.getY() + CURVE_Y[i] * branchSize + (CURVE_Y[i] > 0.0f ? MHelper.randRange(-2.0f, 2.0f, random) * branchSize : 0.0f));
                int z2 = Math.round((float)pos.getZ() + radius * (float)Math.sin(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
                if (CURVE_Y[i] <= 0.0f && !this.isGround(world.getBlockState((BlockPos)context.POS.set(x2, y2, z2)))) {
                    boolean noGround = true;
                    for (int d = 1; d < 3; ++d) {
                        if (!this.isGround(world.getBlockState((BlockPos)context.POS.set(x2, y2 - d, z2)))) continue;
                        y2 -= d;
                        noGround = false;
                        break;
                    }
                    if (noGround) {
                        x2 = pos.getX();
                        y2 = pos.getY();
                        generate = false;
                    }
                }
                this.line((LevelAccessor)world, x1, y1, z1, x2, y2, z2, pos.getY(), context);
                x1 = x2;
                y1 = y2;
                z1 = z2;
            }
        }
        for (BlockPos bpos : context.BLOCKS) {
            BlockState state;
            if (!blockBox.isInside((Vec3i)bpos) || !BlocksHelper.isNetherGround(state = world.getBlockState(bpos)) && !state.canBeReplaced()) continue;
            if (!context.BLOCKS.contains(bpos.above()) || !context.BLOCKS.contains(bpos.below())) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, bpos, NetherBlocks.MAT_WILLOW.getBlock(WoodSlots.BARK).defaultBlockState());
            } else {
                BlocksHelper.setWithUpdate((LevelAccessor)world, bpos, NetherBlocks.MAT_WILLOW.getBlock(WoodSlots.LOG).defaultBlockState());
            }
            if (random.nextInt(8) != 0) continue;
            Block[] wallPlants = WALL_PLANTS.get();
            state = wallPlants[random.nextInt(wallPlants.length)].defaultBlockState();
            if (random.nextInt(8) == 0 && !context.BLOCKS.contains(bpos.north()) && world.isEmptyBlock(bpos.north())) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, bpos.north(), (BlockState)state.setValue((Property)BlockPlantWall.FACING, (Comparable)Direction.NORTH));
            }
            if (random.nextInt(8) == 0 && !context.BLOCKS.contains(bpos.south()) && world.isEmptyBlock(bpos.south())) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, bpos.south(), (BlockState)state.setValue((Property)BlockPlantWall.FACING, (Comparable)Direction.SOUTH));
            }
            if (random.nextInt(8) == 0 && !context.BLOCKS.contains(bpos.east()) && world.isEmptyBlock(bpos.east())) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, bpos.east(), (BlockState)state.setValue((Property)BlockPlantWall.FACING, (Comparable)Direction.EAST));
            }
            if (random.nextInt(8) != 0 || context.BLOCKS.contains(bpos.west()) || !world.isEmptyBlock(bpos.west())) continue;
            BlocksHelper.setWithUpdate((LevelAccessor)world, bpos.west(), (BlockState)state.setValue((Property)BlockPlantWall.FACING, (Comparable)Direction.WEST));
        }
        context.BLOCKS.clear();
        return true;
    }

    @Override
    protected boolean place(ServerLevelAccessor world, BlockPos pos, RandomSource random, NaturalTreeConfiguration config, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        int length = BlocksHelper.upRay((LevelAccessor)world, pos, 27);
        if (length >= 25) {
            return super.place(world, pos, random, config, MAX_HEIGHT, context);
        }
        return false;
    }

    @Override
    protected boolean isStructure(BlockState state) {
        return state.getBlock() == NetherBlocks.MAT_RUBEUS.getLog();
    }

    @Override
    protected boolean isGround(BlockState state) {
        return BlocksHelper.isNetherGround(state);
    }

    private void line(LevelAccessor world, int x1, int y1, int z1, int x2, int y2, int z2, int startY, StructureGeneratorThreadContext context) {
        BlockPos.MutableBlockPos POS = new BlockPos.MutableBlockPos();
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int mx = Math.max(Math.max(Math.abs(dx), Math.abs(dy)), Math.abs(dz));
        float fdx = (float)dx / (float)mx;
        float fdy = (float)dy / (float)mx;
        float fdz = (float)dz / (float)mx;
        float px = x1;
        float py = y1;
        float pz = z1;
        BlockPos pos = POS.set(x1, y1, z1).immutable();
        context.BLOCKS.add(pos);
        pos = POS.set(x2, y2, z2).immutable();
        context.BLOCKS.add(pos);
        for (int i = 0; i < mx; ++i) {
            POS.set(Math.round(px += fdx), Math.round(py += fdy), Math.round(pz += fdz));
            double delta = POS.getY() - startY;
            this.sphere((BlockPos)POS, Mth.clamp((double)(2.3 - Math.abs(delta) * (delta > 0.0 ? 0.1 : 0.3)), (double)0.5, (double)2.3), context);
        }
    }

    private void sphere(BlockPos pos, double radius, StructureGeneratorThreadContext context) {
        int x1 = MHelper.floor((double)pos.getX() - radius);
        int y1 = MHelper.floor((double)pos.getY() - radius);
        int z1 = MHelper.floor((double)pos.getZ() - radius);
        int x2 = MHelper.floor((double)pos.getX() + radius + 1.0);
        int y2 = MHelper.floor((double)pos.getY() + radius + 1.0);
        int z2 = MHelper.floor((double)pos.getZ() + radius + 1.0);
        radius *= radius;
        for (int x = x1; x <= x2; ++x) {
            int px2 = x - pos.getX();
            px2 *= px2;
            for (int z = z1; z <= z2; ++z) {
                int pz2 = z - pos.getZ();
                pz2 *= pz2;
                for (int y = y1; y <= y2; ++y) {
                    int py2 = y - pos.getY();
                    if (!((double)(px2 + pz2 + (py2 *= py2)) <= radius)) continue;
                    context.BLOCKS.add(new BlockPos(x, y, z));
                }
            }
        }
    }

    private void crown(LevelAccessor world, BlockPos pos, float radius, RandomSource random, BoundingBox bounds) {
        int start;
        BlockPos.MutableBlockPos POS = new BlockPos.MutableBlockPos();
        BlockState leaves = (BlockState)NetherBlocks.WILLOW_LEAVES.defaultBlockState().setValue((Property)BlockWillowLeaves.NATURAL, (Comparable)Boolean.valueOf(false));
        BlockState vine = NetherBlocks.MAT_WILLOW.getBranch().defaultBlockState();
        float halfR = radius * 0.5f;
        float r2 = radius * radius;
        int cy = start = (int)Math.floor(-radius);
        while ((float)cy <= radius) {
            int cy2_out = cy * cy;
            float cy2_in = (float)cy + halfR;
            cy2_in *= cy2_in;
            POS.setY((int)((float)(pos.getY() + cy) - halfR));
            int cx = start;
            while ((float)cx <= radius) {
                int cx2 = cx * cx * 2;
                POS.setX(pos.getX() + cx);
                int cz = start;
                while ((float)cz <= radius) {
                    block5: {
                        block8: {
                            block6: {
                                int length;
                                block7: {
                                    int cz2 = cz * cz * 2;
                                    if (!((float)(cx2 + cy2_out + cz2) < r2) || !((float)cx2 + cy2_in + (float)cz2 > r2)) break block5;
                                    POS.setZ(pos.getZ() + cz);
                                    if (!world.getBlockState((BlockPos)POS).canBeReplaced()) break block5;
                                    if (!random.nextBoolean()) break block6;
                                    length = BlocksHelper.downRay(world, (BlockPos)POS, 12);
                                    if (length >= 3) break block7;
                                    BlocksHelper.setWithUpdate(world, (BlockPos)POS, leaves, bounds);
                                    break block5;
                                }
                                length = MHelper.randRange(3, length, random);
                                for (int i = 1; i < length - 1; ++i) {
                                    BlocksHelper.setWithUpdate(world, POS.below(i), vine, bounds);
                                }
                                BlocksHelper.setWithUpdate(world, POS.below(length - 1), (BlockState)vine.setValue(BlockWillowBranch.SHAPE, (Comparable)((Object)BNBlockProperties.WillowBranchShape.END)), bounds);
                                break block8;
                            }
                            if (random.nextBoolean() && world.getBlockState(POS.below()).canBeReplaced()) {
                                BlocksHelper.setWithUpdate(world, POS.below(), leaves, bounds);
                            }
                        }
                        BlocksHelper.setWithUpdate(world, (BlockPos)POS, leaves, bounds);
                    }
                    ++cz;
                }
                ++cx;
            }
            ++cy;
        }
    }

    public boolean grow(ServerLevelAccessor level, BlockPos pos, RandomSource random, NaturalTreeConfiguration configuration) {
        return this.grow(level, pos, random, new NaturalTreeConfiguration(false, configuration.distance), NetherThreadDataStorage.generatorForThread().context);
    }
}

