/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BNBlockProperties;
import org.betterx.betternether.blocks.BlockWillowBranch;
import org.betterx.betternether.blocks.BlockWillowLeaves;
import org.betterx.betternether.blocks.BlockWillowTrunk;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.ContextFeature;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;
import org.betterx.wover.block.api.BlockProperties;
import org.betterx.wover.feature.api.features.GrowableFeature;

public class WillowTreeFeature
extends ContextFeature<NoneFeatureConfiguration>
implements GrowableFeature<NoneFeatureConfiguration> {
    private static final Direction[] HOR = HorizontalDirectionalBlock.FACING.getPossibleValues().toArray(new Direction[0]);

    public WillowTreeFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    @Override
    protected boolean place(ServerLevelAccessor world, BlockPos pos, RandomSource random, NoneFeatureConfiguration config, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        if (!BlocksHelper.isNetherGround(world.getBlockState(pos.below()))) {
            return false;
        }
        return this.grow(world, pos, random);
    }

    protected boolean grow(ServerLevelAccessor world, BlockPos pos, RandomSource random) {
        int i;
        int h2 = 5 + random.nextInt(3);
        int mh = BlocksHelper.upRay((LevelAccessor)world, pos.above(), h2);
        if (mh < 5) {
            return false;
        }
        h2 = Math.min(h2, mh);
        Block trunk = NetherBlocks.MAT_WILLOW.getTrunk();
        BlocksHelper.setWithUpdate((LevelAccessor)world, pos, (BlockState)trunk.defaultBlockState().setValue(BlockWillowTrunk.SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM));
        for (int h = 1; h < h2; ++h) {
            if (!world.isEmptyBlock(pos.above(h))) continue;
            BlocksHelper.setWithUpdate((LevelAccessor)world, pos.above(h), (BlockState)trunk.defaultBlockState().setValue(BlockWillowTrunk.SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE));
        }
        if (world.isEmptyBlock(pos.above(h2))) {
            BlocksHelper.setWithUpdate((LevelAccessor)world, pos.above(h2), (BlockState)trunk.defaultBlockState().setValue(BlockWillowTrunk.SHAPE, (Comparable)BlockProperties.TripleShape.TOP));
        }
        for (i = 0; i < 4; ++i) {
            this.branch(world, pos.above(h2).relative(HOR[i]), 3 + random.nextInt(2), random, HOR[i], pos.above(h2), 0);
        }
        BlocksHelper.setWithUpdate((LevelAccessor)world, pos.above(h2 + 1), (BlockState)((BlockState)NetherBlocks.WILLOW_LEAVES.defaultBlockState().setValue((Property)BlockWillowLeaves.FACING, (Comparable)Direction.UP)).setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)));
        for (i = 0; i < 4; ++i) {
            BlocksHelper.setWithUpdate((LevelAccessor)world, pos.above(h2 + 1).relative(HOR[i]), (BlockState)((BlockState)NetherBlocks.WILLOW_LEAVES.defaultBlockState().setValue((Property)BlockWillowLeaves.FACING, (Comparable)HOR[i])).setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)));
        }
        return true;
    }

    private void branch(ServerLevelAccessor world, BlockPos pos, int length, RandomSource random, Direction direction, BlockPos center, int level) {
        if (level > 5) {
            return;
        }
        BlockPos.MutableBlockPos bpos = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)bpos, (BlockState)((BlockState)NetherBlocks.WILLOW_LEAVES.defaultBlockState().setValue((Property)BlockWillowLeaves.FACING, (Comparable)direction)).setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)));
        this.vine(world, pos.below(), 1 + random.nextInt(1));
        Direction preDir = direction;
        int l2 = length * length;
        for (int i = 0; i < l2; ++i) {
            Direction dir2;
            BlockPos p2;
            Direction dir = random.nextInt(3) > 0 ? preDir : (random.nextBoolean() ? preDir.getClockWise() : preDir.getCounterClockWise());
            BlockPos p = bpos.relative(dir);
            if (!world.isEmptyBlock(p)) continue;
            bpos.set((Vec3i)p);
            if (bpos.distManhattan((Vec3i)center) > length) break;
            BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)bpos, (BlockState)((BlockState)NetherBlocks.WILLOW_LEAVES.defaultBlockState().setValue((Property)BlockWillowLeaves.FACING, (Comparable)dir)).setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)));
            if (random.nextBoolean()) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, bpos.above(), (BlockState)((BlockState)NetherBlocks.WILLOW_LEAVES.defaultBlockState().setValue((Property)BlockWillowLeaves.FACING, (Comparable)Direction.UP)).setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)));
            }
            if (random.nextInt(3) == 0) {
                bpos.setY(bpos.getY() - 1);
                BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)bpos, (BlockState)((BlockState)NetherBlocks.WILLOW_LEAVES.defaultBlockState().setValue((Property)BlockWillowLeaves.FACING, (Comparable)Direction.DOWN)).setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)));
            }
            if (random.nextBoolean()) {
                this.vine(world, bpos.below(), 1 + random.nextInt(4));
            }
            if (random.nextBoolean()) {
                Direction right = dir.getClockWise();
                p2 = bpos.relative(right);
                if (world.isEmptyBlock(p2)) {
                    this.branch(world, p2, length, random, right, center, level + 1);
                }
                if (world.isEmptyBlock(p2 = bpos.relative(right = right.getOpposite()))) {
                    this.branch(world, p2, length, random, right, center, level + 1);
                }
            }
            if (world.isEmptyBlock(p2 = bpos.relative(dir2 = HOR[random.nextInt(4)]))) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, p2, (BlockState)((BlockState)NetherBlocks.WILLOW_LEAVES.defaultBlockState().setValue((Property)BlockWillowLeaves.FACING, (Comparable)dir2)).setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)));
            }
            preDir = dir;
        }
        if (random.nextBoolean() && world.isEmptyBlock((BlockPos)bpos)) {
            BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)bpos, (BlockState)NetherBlocks.WILLOW_LEAVES.defaultBlockState().setValue((Property)BlockWillowLeaves.FACING, (Comparable)preDir));
        }
    }

    private void vine(ServerLevelAccessor world, BlockPos pos, int length) {
        if (!world.isEmptyBlock(pos)) {
            return;
        }
        Block branch = NetherBlocks.MAT_WILLOW.getBranch();
        for (int i = 0; i < length; ++i) {
            BlockPos p = pos.below(i);
            if (!world.isEmptyBlock(p.below())) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, p, (BlockState)branch.defaultBlockState().setValue(BlockWillowBranch.SHAPE, (Comparable)((Object)BNBlockProperties.WillowBranchShape.END)));
                return;
            }
            BlocksHelper.setWithUpdate((LevelAccessor)world, p, (BlockState)branch.defaultBlockState().setValue(BlockWillowBranch.SHAPE, (Comparable)((Object)BNBlockProperties.WillowBranchShape.MIDDLE)));
        }
        BlocksHelper.setWithUpdate((LevelAccessor)world, pos.below(length), (BlockState)branch.defaultBlockState().setValue(BlockWillowBranch.SHAPE, (Comparable)((Object)BNBlockProperties.WillowBranchShape.END)));
    }

    public boolean grow(ServerLevelAccessor level, BlockPos pos, RandomSource random, NoneFeatureConfiguration configuration) {
        return this.grow(level, pos, random);
    }
}

