/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.structures;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.betternether.world.features.NetherThreadDataStorage;
import org.betterx.betternether.world.structures.IStructure;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public abstract class StructureFuncScatter
implements IStructure {
    final int distance;
    final int manDist;

    public StructureFuncScatter(int distance) {
        this.distance = distance;
        this.manDist = (int)Math.ceil((double)distance * 1.5);
    }

    @Override
    public void generate(ServerLevelAccessor world, BlockPos pos, RandomSource random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        if (this.isGround(world.getBlockState(pos.below())) && this.noObjNear((LevelAccessor)world, pos)) {
            this.grow(world, pos, random, true, context);
        }
    }

    public void grow(ServerLevelAccessor world, BlockPos pos, RandomSource random) {
        this.grow(world, pos, random, false, NetherThreadDataStorage.generatorForThread().context);
    }

    public abstract void grow(ServerLevelAccessor var1, BlockPos var2, RandomSource var3, boolean var4, StructureGeneratorThreadContext var5);

    protected abstract boolean isStructure(BlockState var1);

    protected abstract boolean isGround(BlockState var1);

    private boolean noObjNear(LevelAccessor world, BlockPos pos) {
        BlockPos.MutableBlockPos POS = new BlockPos.MutableBlockPos();
        int x1 = pos.getX() - this.distance;
        int z1 = pos.getZ() - this.distance;
        int x2 = pos.getX() + this.distance;
        int z2 = pos.getZ() + this.distance;
        POS.setY(pos.getY());
        for (int x = x1; x <= x2; ++x) {
            POS.setX(x);
            for (int z = z1; z <= z2; ++z) {
                POS.setZ(z);
                if (!this.isInside(x - pos.getX(), z - pos.getZ()) || !this.isStructure(world.getBlockState((BlockPos)POS))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isInside(int x, int z) {
        return Math.abs(x) + Math.abs(z) <= this.manDist;
    }
}

