/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.structures;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.noise.OpenSimplexNoise;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.structures.IStructure;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public class StructurePath
implements IStructure {
    private final OpenSimplexNoise heightNoise;
    private final OpenSimplexNoise rigidNoise;
    private final OpenSimplexNoise distortX;
    private final OpenSimplexNoise distortY;

    public StructurePath(long seed) {
        LegacyRandomSource random = new LegacyRandomSource(seed);
        this.heightNoise = new OpenSimplexNoise(random.nextLong());
        this.rigidNoise = new OpenSimplexNoise(random.nextLong());
        this.distortX = new OpenSimplexNoise(random.nextLong());
        this.distortY = new OpenSimplexNoise(random.nextLong());
    }

    @Override
    public void generate(ServerLevelAccessor world, BlockPos pos, RandomSource random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        for (int x = 0; x < 16; ++x) {
            int wx = pos.getX() + x;
            context.POS.setX(wx);
            for (int z = 0; z < 16; ++z) {
                int wz = pos.getZ() + z;
                context.POS.setZ(wz);
                double rigid = this.getRigid(wx, wz) + (double)MHelper.randRange(0.0f, 0.015f, random);
                if (!(rigid < 0.015)) continue;
                int height = this.getHeight(wx, wz);
                context.POS.setY(height);
                height -= BlocksHelper.downRay((LevelAccessor)world, (BlockPos)context.POS, height);
                context.POS.setY(height);
                if (!world.isEmptyBlock((BlockPos)context.POS) || !world.getBlockState((BlockPos)context.POS.move(Direction.DOWN)).isCollisionShapeFullBlock((BlockGetter)world, (BlockPos)context.POS) || !this.isHeightValid((LevelAccessor)world, context.POS.above())) continue;
                Holder biome = world.getBiome((BlockPos)context.POS);
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)context.POS, this.getRoadMaterial(world, (BlockPos)context.POS, (Holder<Biome>)biome));
                if (this.needsSlab(world, context.POS.above())) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, context.POS.above(), this.getSlabMaterial(world, (BlockPos)context.POS, (Holder<Biome>)biome));
                    continue;
                }
                if (!(rigid > 0.01) || (x & 3) != 0 || (z & 3) != 0 || random.nextInt(8) != 0) continue;
                this.makeLantern((LevelAccessor)world, context.POS.above());
            }
        }
    }

    private int getHeight(int x, int z) {
        return (int)(this.heightNoise.eval((double)x * 0.001, (double)z * 0.001) * 32.0 + 64.0);
    }

    private double getRigid(double x, double z) {
        return Math.abs(this.rigidNoise.eval((x *= 0.1) * 0.02 + this.distortX.eval(x * 0.05, (z *= 0.1) * 0.05) * 0.2, z * 0.02 + this.distortY.eval(x * 0.05, z * 0.05) * 0.2));
    }

    private boolean isHeightValid(LevelAccessor world, BlockPos pos) {
        return Math.abs(BlocksHelper.downRay(world, pos.north(2), 5) - BlocksHelper.downRay(world, pos.south(2), 5)) < 3 && Math.abs(BlocksHelper.downRay(world, pos.east(2), 5) - BlocksHelper.downRay(world, pos.west(2), 5)) < 3;
    }

    private void makeLantern(LevelAccessor world, BlockPos pos) {
        BlocksHelper.setWithoutUpdate(world, pos, NetherBlocks.NETHER_BRICK_WALL.defaultBlockState());
        BlocksHelper.setWithoutUpdate(world, pos.above(), Blocks.NETHER_BRICK_FENCE.defaultBlockState());
        BlocksHelper.setWithoutUpdate(world, pos.above(2), Blocks.NETHER_BRICK_FENCE.defaultBlockState());
        Direction dir = Direction.NORTH;
        double d = 1000.0;
        double v = this.getRigid(pos.getX(), pos.getZ());
        for (Direction face : BlocksHelper.HORIZONTAL) {
            BlockPos p = pos.relative(face);
            double v2 = this.getRigid(p.getX(), p.getZ());
            double d2 = v - v2;
            if (!(d2 < d)) continue;
            d = d2;
            dir = face;
        }
        BlockPos p = pos.above(3);
        BlocksHelper.setWithoutUpdate(world, p, Blocks.NETHER_BRICK_FENCE.defaultBlockState());
        world.getChunk(p).markPosForPostprocessing(new BlockPos(p.getX() & 0xF, p.getY(), p.getZ() & 0xF));
        p = p.relative(dir.getOpposite());
        BlocksHelper.setWithoutUpdate(world, p, Blocks.NETHER_BRICK_FENCE.defaultBlockState());
        world.getChunk(p).markPosForPostprocessing(new BlockPos(p.getX() & 0xF, p.getY(), p.getZ() & 0xF));
        BlocksHelper.setWithoutUpdate(world, p.below(), (BlockState)Blocks.LANTERN.defaultBlockState().setValue((Property)LanternBlock.HANGING, (Comparable)Boolean.valueOf(true)));
    }

    private BlockState getRoadMaterial(ServerLevelAccessor world, BlockPos pos, Holder<Biome> biome) {
        return Blocks.BASALT.defaultBlockState();
    }

    private BlockState getSlabMaterial(ServerLevelAccessor world, BlockPos pos, Holder<Biome> biome) {
        return NetherBlocks.BASALT_SLAB.defaultBlockState();
    }

    private boolean needsSlab(ServerLevelAccessor world, BlockPos pos) {
        for (Direction dir : BlocksHelper.HORIZONTAL) {
            BlockState state = world.getBlockState(pos.relative(dir));
            if (!BlocksHelper.isNetherGround(state) && state.getBlock() != Blocks.BASALT && state.getBlock() != NetherBlocks.SOUL_SANDSTONE || world.getBlockState(pos.below().relative(dir.getOpposite())).isAir()) continue;
            return true;
        }
        return false;
    }
}

