/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.structures.city;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import org.betterx.betternether.world.structures.city.BoundingBox2D;
import org.betterx.betternether.world.structures.city.StructureCityBuilding;
import org.betterx.betternether.world.structures.city.palette.CityPalette;
import org.betterx.betternether.world.structures.piece.CityPiece;

public class CityGenerator {
    private final List<StructureCityBuilding> centers = new ArrayList<StructureCityBuilding>();
    private final List<StructureCityBuilding> buildings = new ArrayList<StructureCityBuilding>();
    private final List<StructureCityBuilding> roadEnds = new ArrayList<StructureCityBuilding>();
    private final List<StructureCityBuilding> total = new ArrayList<StructureCityBuilding>();
    private final List<BoundingBox2D> bounds = new ArrayList<BoundingBox2D>();
    private final List<BlockPos> ends = new ArrayList<BlockPos>();
    private final List<BlockPos> add = new ArrayList<BlockPos>();
    private final List<BlockPos> rem = new ArrayList<BlockPos>();

    public CityGenerator() {
        this.addBuildingToList("city_center_01", -10, this.centers);
        this.addBuildingToList("city_center_02", -10, this.centers);
        this.addBuildingToList("city_center_03", -10, this.centers);
        this.addBuildingToList("city_center_04", -10, this.centers);
        this.addBuildingToList("city_library_01", this.buildings);
        this.addBuildingToList("city_library_02", this.buildings);
        this.addBuildingToList("city_tower_01", this.buildings);
        this.addBuildingToList("city_tower_02", this.buildings);
        this.addBuildingToList("city_tower_03", this.buildings);
        this.addBuildingToList("city_tower_04", this.buildings);
        this.addBuildingToList("city_building_01", this.buildings);
        this.addBuildingToList("city_building_02", this.buildings);
        this.addBuildingToList("city_building_03", this.buildings);
        this.addBuildingToList("city_building_04", this.buildings);
        this.addBuildingToList("city_building_05", this.buildings);
        this.addBuildingToList("city_building_06", this.buildings);
        this.addBuildingToList("city_building_07", this.buildings);
        this.addBuildingToList("city_building_08", this.buildings);
        this.addBuildingToList("city_building_09", this.buildings);
        this.addBuildingToList("city_building_10", this.buildings);
        this.addBuildingToList("city_building_11", this.buildings);
        this.addBuildingToList("city_building_12", this.buildings);
        this.addBuildingToList("city_building_13", this.buildings);
        this.addBuildingToList("city_building_14", this.buildings);
        this.addBuildingToList("city_building_15", this.buildings);
        this.addBuildingToList("city_enchanter_01", this.buildings);
        this.addBuildingToList("city_enchanter_02", this.buildings);
        this.addBuildingToList("city_park_01", this.buildings);
        this.addBuildingToList("city_park_02", this.buildings);
        this.addBuildingToList("city_park_03", this.buildings);
        this.addBuildingToList("city_bridge_01", this.buildings);
        this.addBuildingToList("ramp_01", this.buildings);
        this.addBuildingToList("road_cross_01", this.buildings);
        this.addBuildingToList("road_end_01", this.roadEnds);
        this.addBuildingToList("road_end_02", -2, this.roadEnds);
        this.total.addAll(this.centers);
        this.total.addAll(this.buildings);
        this.total.addAll(this.roadEnds);
    }

    private void addBuildingToList(String name, List<StructureCityBuilding> buildings) {
        this.addBuildingToList(name, 0, buildings);
    }

    private void addBuildingToList(String name, int offsetY, List<StructureCityBuilding> buildings) {
        StructureCityBuilding building = new StructureCityBuilding("city/" + name, offsetY);
        buildings.add(building);
        buildings.add(building.getRotated(Rotation.CLOCKWISE_90));
        buildings.add(building.getRotated(Rotation.CLOCKWISE_180));
        buildings.add(building.getRotated(Rotation.COUNTERCLOCKWISE_90));
    }

    private void placeCenterBuilding(BlockPos pos, StructureCityBuilding building, ArrayList<CityPiece> city, RandomSource random, CityPalette palette) {
        BoundingBox2D bb = building.getBoungingBox().offset(pos);
        this.bounds.add(bb);
        city.add(new CityPiece(building, pos.offset(0, building.getYOffset(), 0), random.nextInt(), palette));
        for (int i = 0; i < building.getEndsCount(); ++i) {
            this.ends.add(pos.offset((Vec3i)building.getOffsettedPos(i).offset(0, building.getYOffset(), 0)));
        }
    }

    private void attachBuildings(RandomSource random, ArrayList<CityPiece> city, CityPalette palette) {
        for (BlockPos pos : this.ends) {
            boolean generate = true;
            for (int n = 0; n < 8 && generate; ++n) {
                int b = random.nextInt(this.buildings.size() >> 2) << 2;
                for (int r = 0; r < 4 && generate; ++r) {
                    int i;
                    StructureCityBuilding building = this.buildings.get(b | r);
                    int index = random.nextInt(building.getEndsCount());
                    BlockPos offset = building.getPos(index);
                    BoundingBox2D bb = building.getBoungingBox().offset(pos).offsetNegative(offset);
                    if (!this.noCollisions(bb)) continue;
                    boolean validHeight = true;
                    BlockPos npos = new BlockPos(bb.x1, pos.getY() - offset.getY() + building.getYOffset(), bb.z1);
                    for (i = 0; i < building.getEndsCount(); ++i) {
                        if (i == index || npos.getY() + building.getOffsettedPos(i).getY() >= 32) continue;
                        validHeight = false;
                        break;
                    }
                    if (!validHeight) continue;
                    this.bounds.add(bb);
                    this.rem.add(pos);
                    for (i = 0; i < building.getEndsCount(); ++i) {
                        if (i == index) continue;
                        this.add.add(npos.offset((Vec3i)building.getOffsettedPos(i)));
                    }
                    city.add(new CityPiece(building, npos, random.nextInt(), palette));
                    generate = false;
                }
            }
        }
        this.ends.removeAll(this.rem);
        this.ends.addAll(this.add);
        this.rem.clear();
        this.add.clear();
    }

    private void closeRoads(ArrayList<CityPiece> city, RandomSource random, CityPalette palette) {
        block0: for (BlockPos pos : this.ends) {
            for (int n = 0; n < this.roadEnds.size(); ++n) {
                StructureCityBuilding building = this.roadEnds.get(n);
                BlockPos offset = building.getPos(0);
                BoundingBox2D bb = building.getBoungingBox().offset(pos).offsetNegative(offset);
                if (!this.noCollisions(bb)) continue;
                BlockPos npos = new BlockPos(bb.x1, pos.getY() - offset.getY() + building.getYOffset(), bb.z1);
                this.bounds.add(bb);
                city.add(new CityPiece(building, npos, random.nextInt(), palette));
                continue block0;
            }
        }
        this.ends.clear();
        this.bounds.clear();
        this.rem.clear();
        this.add.clear();
    }

    public ArrayList<CityPiece> generate(BlockPos pos, RandomSource random, CityPalette palette) {
        ArrayList<CityPiece> city = new ArrayList<CityPiece>();
        this.placeCenterBuilding(pos, this.centers.get(random.nextInt(this.centers.size())), city, random, palette);
        float rnd = random.nextFloat();
        rnd *= rnd;
        rnd *= rnd;
        int iterations = Math.round(2.0f + rnd * 2.0f);
        for (int i = 0; i < iterations; ++i) {
            this.attachBuildings(random, city, palette);
        }
        this.closeRoads(city, random, palette);
        return city;
    }

    private boolean noCollisions(BoundingBox2D bb) {
        for (BoundingBox2D b : this.bounds) {
            if (!bb.isColliding(b)) continue;
            return false;
        }
        return true;
    }

    public List<StructureCityBuilding> getBuildings() {
        return this.total;
    }
}

