/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.datagen.betternether.advancements;

import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.ChangeDimensionTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.betterx.bclib.api.v2.advancement.AdvancementManager;
import org.betterx.bclib.api.v3.datagen.AdvancementDataProvider;
import org.betterx.bclib.complexmaterials.WoodenComplexMaterial;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.advancements.BNCriterion;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.registry.NetherItems;
import org.betterx.betternether.registry.NetherStructures;
import org.betterx.betternether.registry.NetherTemplates;
import org.betterx.wover.complex.api.equipment.ArmorSlot;
import org.betterx.wover.complex.api.equipment.ToolSlot;

public class NetherAdvancementDataProvider
extends AdvancementDataProvider {
    public NetherAdvancementDataProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registryLookup) {
        super(List.of(BetterNether.C.modId), output, registryLookup);
    }

    protected void bootstrap(HolderLookup.Provider registryLookup) {
        HolderLookup.RegistryLookup biomeLookup = registryLookup.lookupOrThrow(Registries.BIOME);
        HolderLookup.RegistryLookup structureLookup = registryLookup.lookupOrThrow(Registries.STRUCTURE);
        ResourceLocation root = AdvancementManager.Builder.create((ResourceLocation)BetterNether.C.id("root")).startDisplay((ItemLike)NetherBlocks.CINCINNASITE_LANTERN).task().hideFromChat().background(ResourceLocation.withDefaultNamespace((String)"textures/gui/advancements/backgrounds/nether.png")).endDisplay().addCriterion("welcome", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.location())).requireOne().build();
        ResourceLocation enterNether = AdvancementManager.Builder.create((ResourceLocation)BetterNether.C.id("enter_nether")).parent(root).startDisplay((ItemLike)NetherBlocks.JUNGLE_MOSS).endDisplay().addCriterion("entered_nether", ChangeDimensionTrigger.TriggerInstance.changedDimensionTo((ResourceKey)Level.NETHER)).requireOne().build();
        ResourceLocation blueObsidian = AdvancementManager.Builder.create((ResourceLocation)BetterNether.C.id("blue_obsidian")).parent(root).startDisplay((ItemLike)NetherBlocks.BLUE_OBSIDIAN).endDisplay().addCriterion("brew_blue", BNCriterion.BREW_BLUE_CRITERION).requireOne().build();
        ResourceLocation obsidianBlocks = AdvancementManager.Builder.create((ResourceLocation)BetterNether.C.id("obsidian_blocks")).parent(blueObsidian).startDisplay((ItemLike)NetherBlocks.BLUE_OBSIDIAN_BRICKS).endDisplay().addInventoryChangedCriterion("made_brick", new ItemLike[]{NetherBlocks.OBSIDIAN_BRICKS}).addInventoryChangedCriterion("made_tile", new ItemLike[]{NetherBlocks.OBSIDIAN_TILE}).addInventoryChangedCriterion("made_small_tile", new ItemLike[]{NetherBlocks.OBSIDIAN_TILE_SMALL}).addInventoryChangedCriterion("made_rods", new ItemLike[]{NetherBlocks.OBSIDIAN_ROD_TILES}).addInventoryChangedCriterion("made_blue_brick", new ItemLike[]{NetherBlocks.BLUE_OBSIDIAN_BRICKS}).addInventoryChangedCriterion("made_blue_tile", new ItemLike[]{NetherBlocks.BLUE_OBSIDIAN_TILE}).addInventoryChangedCriterion("made_small_blue_tile", new ItemLike[]{NetherBlocks.BLUE_OBSIDIAN_TILE_SMALL}).addInventoryChangedCriterion("made_blue_rods", new ItemLike[]{NetherBlocks.BLUE_OBSIDIAN_ROD_TILES}).requireAll().build();
        ResourceLocation makeCrying = AdvancementManager.Builder.create((ResourceLocation)BetterNether.C.id("make_crying")).parent(blueObsidian).startDisplay((ItemLike)NetherBlocks.BLUE_WEEPING_OBSIDIAN).challenge().endDisplay().addCriterion("made_blue_crying", BNCriterion.CONVERT_BY_LIGHTNING.match((ItemLike)NetherBlocks.BLUE_CRYING_OBSIDIAN)).addCriterion("made_crying", BNCriterion.CONVERT_BY_LIGHTNING.match((ItemLike)NetherBlocks.BLUE_WEEPING_OBSIDIAN)).addCriterion("made_blue_weeping", BNCriterion.CONVERT_BY_LIGHTNING.match((ItemLike)Blocks.CRYING_OBSIDIAN)).addCriterion("made_weeping", BNCriterion.CONVERT_BY_LIGHTNING.match((ItemLike)NetherBlocks.WEEPING_OBSIDIAN)).requireAll().rewardXP(500).build();
        ResourceLocation city = null;
        Holder cityHolder = NetherStructures.CITY_STRUCTURE.getHolder((HolderGetter)structureLookup);
        if (cityHolder != null) {
            city = AdvancementManager.Builder.create((ResourceLocation)BetterNether.C.id("city")).parent(enterNether).startDisplay((ItemLike)NetherBlocks.CINCINNASITE_CARVED).endDisplay().addAtStructureCriterion("ncity", cityHolder).requireOne().build();
        }
        ResourceLocation rubyOre = AdvancementManager.Builder.create((ResourceLocation)BetterNether.C.id("ruby_ore")).parent(enterNether).startDisplay((ItemLike)NetherItems.NETHER_RUBY).endDisplay().addInventoryChangedCriterion("ruby_ore", new ItemLike[]{NetherItems.NETHER_RUBY}).requireOne().build();
        ResourceLocation flames = AdvancementManager.Builder.create((ResourceLocation)BetterNether.C.id("flaming_ruby")).parent(rubyOre).startDisplay((ItemLike)NetherTemplates.FLAMING_RUBY_TEMPLATE).goal().endDisplay().addInventoryChangedCriterion("flaming_ruby", new ItemLike[]{NetherTemplates.FLAMING_RUBY_TEMPLATE}).requireAll().build();
        ResourceLocation flamingTools = NetherItems.FLAMING_RUBY_SET.addToolSetCriterion(AdvancementManager.Builder.create((ResourceLocation)BetterNether.C.id("flaming_tools")).parent(flames).startDisplay((ItemLike)NetherItems.FLAMING_RUBY_SET.get(ToolSlot.PICKAXE_SLOT)).goal().endDisplay()).requireAll().build();
        ResourceLocation flamingArmor = NetherItems.FLAMING_RUBY_SET.addArmorSetCriterion(AdvancementManager.Builder.create((ResourceLocation)BetterNether.C.id("flaming_armor")).parent(flames).startDisplay((ItemLike)NetherItems.FLAMING_RUBY_SET.get(ArmorSlot.CHESTPLATE_SLOT)).goal().endDisplay()).requireAll().build();
        ResourceLocation rubyTools = NetherItems.NETHER_RUBY_SET.addToolSetCriterion(AdvancementManager.Builder.create((ResourceLocation)BetterNether.C.id("ruby_tools")).parent(rubyOre).startDisplay((ItemLike)NetherItems.NETHER_RUBY_SET.get(ToolSlot.PICKAXE_SLOT)).endDisplay()).requireOne().build();
        ResourceLocation rubyGear = NetherItems.NETHER_RUBY_SET.addArmorSetCriterion(AdvancementManager.Builder.create((ResourceLocation)BetterNether.C.id("ruby_gear")).parent(rubyTools).startDisplay((ItemLike)NetherItems.NETHER_RUBY_SET.get(ArmorSlot.CHESTPLATE_SLOT)).endDisplay()).requireAll().build();
        ResourceLocation cincinnasiteOre = AdvancementManager.Builder.create((ResourceLocation)BetterNether.C.id("cincinnasite_ore")).parent(enterNether).startDisplay((ItemLike)NetherItems.CINCINNASITE_INGOT).endDisplay().addInventoryChangedCriterion("cincinnasite_ore", new ItemLike[]{NetherItems.CINCINNASITE_INGOT}).requireOne().build();
        ResourceLocation cincinnasiteTools = NetherItems.CINCINNASITE_SET.addToolSetCriterion(AdvancementManager.Builder.create((ResourceLocation)BetterNether.C.id("cincinnasite_tools")).parent(cincinnasiteOre).startDisplay((ItemLike)NetherItems.CINCINNASITE_SET.get(ToolSlot.PICKAXE_SLOT)).endDisplay()).requireOne().build();
        ResourceLocation cincinnasiteGear = NetherItems.CINCINNASITE_SET.addArmorSetCriterion(AdvancementManager.Builder.create((ResourceLocation)BetterNether.C.id("cincinnasite_gear")).parent(cincinnasiteTools).startDisplay((ItemLike)NetherItems.CINCINNASITE_SET.get(ArmorSlot.CHESTPLATE_SLOT)).endDisplay()).requireAll().build();
        ResourceLocation cincinnasiteDiamond = AdvancementManager.Builder.create((ResourceLocation)BetterNether.C.id("cincinnasite_diamond")).parent(cincinnasiteTools).startDisplay((ItemLike)NetherTemplates.CINCINNASITE_DIAMOND_TEMPLATE).goal().endDisplay().addInventoryChangedCriterion("cincinnasite_diamond", new ItemLike[]{NetherTemplates.CINCINNASITE_DIAMOND_TEMPLATE}).requireAll().build();
        ResourceLocation cincinnasiteDiamondTools = NetherItems.CINCINNASITE_DIAMOND_SET.addToolSetCriterion(AdvancementManager.Builder.create((ResourceLocation)BetterNether.C.id("cincinnasite_diamond_tools")).parent(cincinnasiteDiamond).startDisplay((ItemLike)NetherItems.CINCINNASITE_DIAMOND_SET.get(ToolSlot.PICKAXE_SLOT)).goal().endDisplay()).requireAll().build();
        ResourceLocation forge = AdvancementManager.Builder.create((ResourceLocation)BetterNether.C.id("cincinnasite_forge")).parent(cincinnasiteOre).startDisplay((ItemLike)NetherBlocks.CINCINNASITE_FORGE).goal().endDisplay().addCriterion("use_forge", BNCriterion.USED_FORGE_ANY_CRITERION).requireOne().build();
        ResourceLocation netherWood = AdvancementManager.Builder.create((ResourceLocation)BetterNether.C.id("nether_wood")).parent(enterNether).startDisplay((ItemLike)NetherBlocks.MAT_WILLOW.getLog()).endDisplay().addWoodCriterion((WoodenComplexMaterial)NetherBlocks.MAT_WILLOW).addWoodCriterion((WoodenComplexMaterial)NetherBlocks.MAT_STALAGNATE).addWoodCriterion((WoodenComplexMaterial)NetherBlocks.MAT_RUBEUS).addWoodCriterion((WoodenComplexMaterial)NetherBlocks.MAT_WART).addWoodCriterion((WoodenComplexMaterial)NetherBlocks.MAT_MUSHROOM_FIR).addWoodCriterion((WoodenComplexMaterial)NetherBlocks.MAT_ANCHOR_TREE).addWoodCriterion((WoodenComplexMaterial)NetherBlocks.MAT_NETHER_SAKURA).addInventoryChangedAnyCriterion("got_nether_reed", new ItemLike[]{NetherBlocks.MAT_REED.getStem(), NetherBlocks.MAT_REED.getPlanks()}).addInventoryChangedAnyCriterion("got_nether_mushroom", new ItemLike[]{NetherBlocks.MAT_NETHER_MUSHROOM.getStem(), NetherBlocks.MAT_NETHER_MUSHROOM.getPlanks()}).addInventoryChangedAnyCriterion("got_crimson", new ItemLike[]{Blocks.CRIMSON_STEM, Blocks.CRIMSON_HYPHAE, Blocks.CRIMSON_PLANKS}).addInventoryChangedAnyCriterion("got_warped", new ItemLike[]{Blocks.WARPED_STEM, Blocks.WARPED_HYPHAE, Blocks.WARPED_PLANKS}).requireAll().build();
        List<ResourceKey> biomes = biomeLookup.listElementIds().filter(id -> id.location().getNamespace().equals(BetterNether.C.modId)).toList();
        if (!biomes.isEmpty()) {
            ResourceLocation resourceLocation = AdvancementManager.Builder.create((ResourceLocation)BetterNether.C.id("all_the_biomes")).parent(city).startDisplay((ItemLike)NetherItems.NETHER_RUBY_SET.get(ArmorSlot.BOOTS_SLOT)).challenge().endDisplay().addVisitBiomesCriterion(biomes.stream().sorted(Comparator.comparing(ResourceKey::location)).map(key -> (Holder)biomeLookup.get(key).orElseThrow()).toList()).requireAll().rewardXP(1500).build();
        }
    }
}

