/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.datagen.betternether.recipes;

import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.betterx.betternether.loot.BNLoot;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.registry.NetherItems;
import org.betterx.betternether.registry.NetherTemplates;
import org.betterx.wover.complex.api.equipment.ArmorSlot;
import org.betterx.wover.complex.api.equipment.EquipmentSet;
import org.betterx.wover.complex.api.equipment.ToolSlot;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.datagen.api.provider.WoverLootTableProvider;
import org.jetbrains.annotations.NotNull;

public class NetherChestLootTableProvider
extends WoverLootTableProvider {
    public NetherChestLootTableProvider(ModCore modCore) {
        super(modCore, "BetterNether Loot Table", LootContextParamSets.CHEST);
    }

    public void boostrap(@NotNull HolderLookup.Provider lookup, @NotNull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> biConsumer) {
        HolderLookup.RegistryLookup enchantments = lookup.lookupOrThrow(Registries.ENCHANTMENT);
        biConsumer.accept(BNLoot.CITY_LOOT, LootTable.lootTable().withPool(this.simpleCityLoot()).withPool(this.simpleOreLoot()).withPool(this.simpleTemplates(1, 0.2f)).withPool(this.netherFiller()));
        biConsumer.accept(BNLoot.CITY_LOOT_COMMON, LootTable.lootTable().withPool(this.simpleCityLoot()).withPool(this.netherFiller()).withPool(this.netherObsidian()).withPool(this.simpleOreLoot().when(LootItemRandomChanceCondition.randomChance((float)0.4f))).withPool(this.simpleTemplates(1, 0.1f)));
        biConsumer.accept(BNLoot.CITY_LOOT_SURPRISE, LootTable.lootTable().withPool(this.simpleCityLoot()).withPool(this.netherFiller()).withPool(this.netherObsidian()).withPool(this.simpleOreLoot().when(LootItemRandomChanceCondition.randomChance((float)0.4f))).withPool(this.surpriseItem()));
        biConsumer.accept(BNLoot.LIBRARY_LOOT, LootTable.lootTable().withPool(this.simpleCityLoot()).withPool(this.enchantedTools((HolderLookup.RegistryLookup<Enchantment>)enchantments)).withPool(this.allTemplates()).withPool(this.workstations()).withPool(this.books()).withPool(this.netherFiller()));
        biConsumer.accept(BNLoot.WITHER_TOWER_LOOT, LootTable.lootTable().withPool(this.netherFiller()).withPool(this.simpleTemplates(3, 0.3f)).withPool(this.bonusOreLoot()).withPool(this.simpleSwords((HolderLookup.RegistryLookup<Enchantment>)enchantments)).withPool(this.hoes((HolderLookup.RegistryLookup<Enchantment>)enchantments)).withPool(this.flamingTemplate(2, 0.2f)).withPool(this.armor((HolderLookup.RegistryLookup<Enchantment>)enchantments, NetherItems.NETHER_RUBY_SET, 1, 0.2f)).withPool(this.armor((HolderLookup.RegistryLookup<Enchantment>)enchantments, NetherItems.CINCINNASITE_SET, 1, 0.2f)));
        biConsumer.accept(BNLoot.WITHER_TOWER_BONUS_LOOT, LootTable.lootTable().withPool(this.netherFiller()).withPool(this.bonusSwords((HolderLookup.RegistryLookup<Enchantment>)enchantments, 0.3f)).withPool(this.flamingTemplate(4, 0.99f)).withPool(this.armor((HolderLookup.RegistryLookup<Enchantment>)enchantments, NetherItems.NETHER_RUBY_SET, 2, 0.6f)).withPool(this.armor((HolderLookup.RegistryLookup<Enchantment>)enchantments, NetherItems.FLAMING_RUBY_SET, 1, 0.4f)).withPool(this.superBonusOreLoot()));
        biConsumer.accept(BNLoot.GHAST_HIVE, LootTable.lootTable().withPool(this.ghastHive()));
    }

    private LootPool.Builder surpriseItem() {
        return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherBlocks.NETHER_RUBY_BLOCK).setWeight(15)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherBlocks.NETHER_RUBY_BLOCK).setWeight(15)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Blocks.NETHERITE_BLOCK).setWeight(3)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherItems.FLAMING_RUBY_SET.get(ArmorSlot.CHESTPLATE_SLOT)).setWeight(1)).when(LootItemRandomChanceCondition.randomChance((float)0.1f));
    }

    private LootPool.Builder ghastHive() {
        return LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)8.0f, (float)12.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DIAMOND).setWeight(40).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Blocks.SKELETON_SKULL).setWeight(20)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Blocks.WITHER_SKELETON_SKULL).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BROWN_MUSHROOM).setWeight(60).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.RED_MUSHROOM).setWeight(60).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BONE).setWeight(60).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.QUARTZ).setWeight(50).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GHAST_TEAR).setWeight(45).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLD_INGOT).setWeight(55).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLDEN_APPLE).setWeight(20)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherItems.BLACK_APPLE).setWeight(40));
    }

    private LootPool.Builder books() {
        return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Blocks.BOOKSHELF).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BOOK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)4.0f, (float)8.0f)))).when(LootItemRandomChanceCondition.randomChance((float)0.7f));
    }

    private LootPool.Builder workstations() {
        return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Blocks.LECTERN).setWeight(4)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherBlocks.NETHER_BREWING_STAND).setWeight(2)).when(LootItemRandomChanceCondition.randomChance((float)0.7f));
    }

    private LootPool.Builder armor(HolderLookup.RegistryLookup<Enchantment> lookup, EquipmentSet set, int max, float chance) {
        return LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)max)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)set.get(ArmorSlot.HELMET_SLOT)).setWeight(3).apply((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder().withEnchantment((Holder)lookup.getOrThrow(Enchantments.FIRE_PROTECTION)).withEnchantment((Holder)lookup.getOrThrow(Enchantments.MENDING)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)set.get(ArmorSlot.CHESTPLATE_SLOT)).setWeight(3).apply((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder().withEnchantment((Holder)lookup.getOrThrow(Enchantments.FIRE_PROTECTION)).withEnchantment((Holder)lookup.getOrThrow(Enchantments.MENDING)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)set.get(ArmorSlot.LEGGINGS_SLOT)).setWeight(3).apply((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder().withEnchantment((Holder)lookup.getOrThrow(Enchantments.FIRE_PROTECTION)).withEnchantment((Holder)lookup.getOrThrow(Enchantments.MENDING)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)set.get(ArmorSlot.BOOTS_SLOT)).setWeight(2).apply((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder().withEnchantment((Holder)lookup.getOrThrow(Enchantments.FIRE_PROTECTION)).withEnchantment((Holder)lookup.getOrThrow(Enchantments.FEATHER_FALLING)).withEnchantment((Holder)lookup.getOrThrow(Enchantments.MENDING)))).when(LootItemRandomChanceCondition.randomChance((float)chance));
    }

    private LootPool.Builder simpleTemplates(int max, float chance) {
        return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherTemplates.NETHER_BOWL_SMITHING_TEMPLATE).setWeight(3)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherTemplates.CINCINNASITE_DIAMOND_TEMPLATE).setWeight(3 * max).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)max)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE).setWeight(2)).when(LootItemRandomChanceCondition.randomChance((float)chance));
    }

    private LootPool.Builder flamingTemplate(int max, float chance) {
        return LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)max)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherTemplates.FLAMING_RUBY_TEMPLATE).setWeight(1)).when(LootItemRandomChanceCondition.randomChance((float)chance));
    }

    private LootPool.Builder allTemplates() {
        return LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)2.0f, (float)3.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherTemplates.FLAMING_RUBY_TEMPLATE).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherTemplates.NETHER_BOWL_SMITHING_TEMPLATE).setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherTemplates.CINCINNASITE_DIAMOND_TEMPLATE).setWeight(4)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE).setWeight(3));
    }

    private LootPool.Builder bonusSwords(HolderLookup.RegistryLookup<Enchantment> lookup, float chance) {
        return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherItems.FLAMING_RUBY_SET.get(ToolSlot.SWORD_SLOT)).apply((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder().withEnchantment((Holder)lookup.getOrThrow(Enchantments.SHARPNESS)).withEnchantment((Holder)lookup.getOrThrow(Enchantments.LOOTING)).withEnchantment((Holder)lookup.getOrThrow(Enchantments.MENDING)))).when(LootItemRandomChanceCondition.randomChance((float)chance));
    }

    private LootPool.Builder simpleSwords(HolderLookup.RegistryLookup<Enchantment> lookup) {
        return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherItems.NETHER_RUBY_SET.get(ToolSlot.SWORD_SLOT)).apply((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder().withEnchantment((Holder)lookup.getOrThrow(Enchantments.SHARPNESS)).withEnchantment((Holder)lookup.getOrThrow(Enchantments.LOOTING)).withEnchantment((Holder)lookup.getOrThrow(Enchantments.MENDING)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherItems.CINCINNASITE_SET.get(ToolSlot.SWORD_SLOT)).apply((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder().withEnchantment((Holder)lookup.getOrThrow(Enchantments.SHARPNESS)).withEnchantment((Holder)lookup.getOrThrow(Enchantments.LOOTING)).withEnchantment((Holder)lookup.getOrThrow(Enchantments.MENDING)))).when(LootItemRandomChanceCondition.randomChance((float)0.2f));
    }

    private LootPool.Builder hoes(HolderLookup.RegistryLookup<Enchantment> lookup) {
        return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherItems.NETHER_RUBY_SET.get(ToolSlot.HOE_SLOT)).apply((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder().withEnchantment((Holder)lookup.getOrThrow(Enchantments.EFFICIENCY)).withEnchantment((Holder)lookup.getOrThrow(Enchantments.SILK_TOUCH)).withEnchantment((Holder)lookup.getOrThrow(Enchantments.UNBREAKING)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherItems.CINCINNASITE_SET.get(ToolSlot.HOE_SLOT)).apply((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder().withEnchantment((Holder)lookup.getOrThrow(Enchantments.EFFICIENCY)).withEnchantment((Holder)lookup.getOrThrow(Enchantments.SILK_TOUCH)).withEnchantment((Holder)lookup.getOrThrow(Enchantments.UNBREAKING)))).when(LootItemRandomChanceCondition.randomChance((float)0.4f));
    }

    private LootPool.Builder enchantedTools(HolderLookup.RegistryLookup<Enchantment> lookup) {
        return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Blocks.LAPIS_BLOCK).setWeight(8).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)6.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherItems.FLAMING_RUBY_SET.get(ToolSlot.PICKAXE_SLOT)).apply((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder().withEnchantment((Holder)lookup.getOrThrow(Enchantments.EFFICIENCY)).withEnchantment((Holder)lookup.getOrThrow(Enchantments.SILK_TOUCH)).withEnchantment((Holder)lookup.getOrThrow(Enchantments.UNBREAKING))).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherItems.NETHER_RUBY_SET.get(ToolSlot.PICKAXE_SLOT)).apply((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder().withEnchantment((Holder)lookup.getOrThrow(Enchantments.EFFICIENCY)).withEnchantment((Holder)lookup.getOrThrow(Enchantments.SILK_TOUCH)).withEnchantment((Holder)lookup.getOrThrow(Enchantments.UNBREAKING)).withEnchantment((Holder)lookup.getOrThrow(Enchantments.MENDING))).setWeight(4)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.NETHERITE_PICKAXE).apply((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder().withEnchantment((Holder)lookup.getOrThrow(Enchantments.EFFICIENCY)).withEnchantment((Holder)lookup.getOrThrow(Enchantments.SILK_TOUCH)).withEnchantment((Holder)lookup.getOrThrow(Enchantments.UNBREAKING)).withEnchantment((Holder)lookup.getOrThrow(Enchantments.MENDING))).setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DIAMOND_PICKAXE).apply((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder().withEnchantment((Holder)lookup.getOrThrow(Enchantments.EFFICIENCY)).withEnchantment((Holder)lookup.getOrThrow(Enchantments.SILK_TOUCH)).withEnchantment((Holder)lookup.getOrThrow(Enchantments.UNBREAKING)).withEnchantment((Holder)lookup.getOrThrow(Enchantments.MENDING))).setWeight(8));
    }

    private LootPool.Builder netherObsidian() {
        return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)3.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Blocks.OBSIDIAN).setWeight(9).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)8.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherBlocks.BLUE_OBSIDIAN).setWeight(9).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)8.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Blocks.CRYING_OBSIDIAN).setWeight(3).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherBlocks.BLUE_CRYING_OBSIDIAN).setWeight(3).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherBlocks.WEEPING_OBSIDIAN).setWeight(1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherBlocks.BLUE_WEEPING_OBSIDIAN).setWeight(1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))));
    }

    private LootPool.Builder netherFiller() {
        return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)2.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Blocks.NETHERRACK).setWeight(12).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)4.0f, (float)12.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.NETHER_WART).setWeight(3).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)8.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.FLINT_AND_STEEL).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.QUARTZ).setWeight(8).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)12.0f))));
    }

    private LootPool.Builder superBonusOreLoot() {
        return LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)3.0f, (float)6.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Blocks.GOLD_BLOCK).setWeight(6).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLD_INGOT).setWeight(8).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)6.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherItems.NETHER_RUBY).setWeight(8).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)8.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.NETHERITE_SCRAP).setWeight(6).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)5.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Blocks.NETHERITE_BLOCK).setWeight(4).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))));
    }

    private LootPool.Builder bonusOreLoot() {
        return LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DIAMOND).setWeight(15).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherItems.NETHER_RUBY).setWeight(12).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.NETHERITE_SCRAP).setWeight(8).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))));
    }

    private LootPool.Builder simpleOreLoot() {
        return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherItems.CINCINNASITE_INGOT).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherItems.NETHER_RUBY).setWeight(2)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)6.0f)));
    }

    private LootPool.Builder simpleCityLoot() {
        return LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherBlocks.BLUE_CRYING_OBSIDIAN).setWeight(3).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherBlocks.BLUE_WEEPING_OBSIDIAN).setWeight(2).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Blocks.CRYING_OBSIDIAN).setWeight(3).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherBlocks.WEEPING_OBSIDIAN).setWeight(2).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)NetherBlocks.BLUE_OBSIDIAN).setWeight(4).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Blocks.OBSIDIAN).setWeight(4).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))));
    }
}

