/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.block;

import com.mojang.serialization.MapCodec;
import com.theplumteam.block.PopBlockColor;
import com.theplumteam.blockentity.BoxBlockEntity;
import com.theplumteam.figure.FigureDefinition;
import com.theplumteam.figure.FigureType;
import com.theplumteam.platform.PlatformHelper;
import com.theplumteam.registry.ModBlockEntities;
import com.theplumteam.registry.ModItems;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BoxBlock
extends BaseEntityBlock {
    public static final MapCodec<BoxBlock> CODEC = BoxBlock.simpleCodec(BoxBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0);

    public BoxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape baseShape = SHAPE;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BoxBlockEntity) {
            BoxBlockEntity boxBlockEntity = (BoxBlockEntity)blockEntity;
            double localOffsetX = boxBlockEntity.getHitboxOffsetX();
            double localOffsetY = boxBlockEntity.getHitboxOffsetY();
            double localOffsetZ = boxBlockEntity.getHitboxOffsetZ();
            double hitboxScaleX = boxBlockEntity.getHitboxScaleX();
            double hitboxScaleY = boxBlockEntity.getHitboxScaleY();
            double hitboxScaleZ = boxBlockEntity.getHitboxScaleZ();
            Direction facing = (Direction)state.getValue((Property)FACING);
            VoxelShape scaledShape = baseShape;
            if (hitboxScaleX != 1.0 || hitboxScaleY != 1.0 || hitboxScaleZ != 1.0) {
                double centerX = 8.0;
                double centerY = 7.0;
                double centerZ = 8.0;
                double effectiveScaleX = hitboxScaleX;
                double effectiveScaleZ = hitboxScaleZ;
                if (facing == Direction.EAST || facing == Direction.WEST) {
                    effectiveScaleX = hitboxScaleZ;
                    effectiveScaleZ = hitboxScaleX;
                }
                double minX = centerX + (3.0 - centerX) * effectiveScaleX;
                double minY = 0.0;
                double minZ = centerZ + (3.0 - centerZ) * effectiveScaleZ;
                double maxX = centerX + (13.0 - centerX) * effectiveScaleX;
                double maxY = 14.0 * hitboxScaleY;
                double maxZ = centerZ + (13.0 - centerZ) * effectiveScaleZ;
                scaledShape = Block.box((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            }
            if (localOffsetX != 0.0 || localOffsetY != 0.0 || localOffsetZ != 0.0) {
                double worldOffsetX = 0.0;
                double worldOffsetZ = 0.0;
                switch (facing) {
                    case NORTH: {
                        worldOffsetX = localOffsetX;
                        worldOffsetZ = -localOffsetZ;
                        break;
                    }
                    case SOUTH: {
                        worldOffsetX = -localOffsetX;
                        worldOffsetZ = localOffsetZ;
                        break;
                    }
                    case EAST: {
                        worldOffsetX = localOffsetZ;
                        worldOffsetZ = localOffsetX;
                        break;
                    }
                    case WEST: {
                        worldOffsetX = -localOffsetZ;
                        worldOffsetZ = -localOffsetX;
                    }
                }
                return scaledShape.move(worldOffsetX, localOffsetY, worldOffsetZ);
            }
            return scaledShape;
        }
        return baseShape;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BoxBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? BoxBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.BOX_BLOCK.get()), BoxBlockEntity::tick) : null;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected ItemInteractionResult useItemOn(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof BoxBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BoxBlockEntity boxBlockEntity = (BoxBlockEntity)blockEntity;
        if (player.isShiftKeyDown()) {
            if (boxBlockEntity.isOpen() && !level.isClientSide) {
                boxBlockEntity.toggleOpen();
                return ItemInteractionResult.SUCCESS;
            }
            if (!boxBlockEntity.isOpen() && level.isClientSide && PlatformHelper.isDevelopmentEnvironment()) {
                PlatformHelper.openBoxFigureScreen(pos, boxBlockEntity);
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (!level.isClientSide) {
            if (boxBlockEntity.isOpen()) {
                if (heldItem.getItem() == ModItems.FIGURE_BLOCK_ITEM.get() && boxBlockEntity.isFigureExtracted()) {
                    CustomData customData = (CustomData)heldItem.get(DataComponents.BLOCK_ENTITY_DATA);
                    if (customData != null) {
                        CompoundTag blockEntityTag = customData.copyTag();
                        String heldFigureId = blockEntityTag.getString("FigureId");
                        String heldCollectionId = blockEntityTag.getString("CollectionId");
                        if (heldFigureId.equals(boxBlockEntity.getFigureId()) && heldCollectionId.equals(boxBlockEntity.getCollectionId())) {
                            if (blockEntityTag.contains("QuickSkinId")) {
                                boxBlockEntity.setQuickSkinId(blockEntityTag.getString("QuickSkinId"));
                            }
                            if (blockEntityTag.contains("SkinSnapshot")) {
                                boxBlockEntity.setSkinSnapshot(blockEntityTag.getString("SkinSnapshot"));
                            }
                            boxBlockEntity.setFigureExtracted(false);
                            boxBlockEntity.toggleOpen();
                            heldItem.shrink(1);
                            level.playSound(null, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
                            return ItemInteractionResult.SUCCESS;
                        }
                    }
                } else if (boxBlockEntity.hasFigure() && !boxBlockEntity.isFigureExtracted()) {
                    ItemStack figureBlockItem = new ItemStack((ItemLike)ModItems.FIGURE_BLOCK_ITEM.get());
                    CompoundTag blockEntityTag = new CompoundTag();
                    blockEntityTag.putString("FigureId", boxBlockEntity.getFigureId());
                    blockEntityTag.putString("CollectionId", boxBlockEntity.getCollectionId());
                    blockEntityTag.putInt("AlternativeSkinIndex", boxBlockEntity.getAlternativeSkinIndex());
                    blockEntityTag.putInt("PoseIndex", boxBlockEntity.getPoseIndex());
                    blockEntityTag.putDouble("FigureOffsetX", boxBlockEntity.getFigureOffsetX());
                    blockEntityTag.putDouble("FigureOffsetY", boxBlockEntity.getFigureOffsetY());
                    blockEntityTag.putDouble("FigureOffsetZ", boxBlockEntity.getFigureOffsetZ());
                    blockEntityTag.putDouble("FigureScale", boxBlockEntity.getFigureScale());
                    FigureDefinition figureDef = boxBlockEntity.getFigureDefinition();
                    if (figureDef != null && figureDef.getType() == FigureType.PLAYER) {
                        String quickSkinId;
                        String snapshot = boxBlockEntity.getSkinSnapshot();
                        if (snapshot != null && !snapshot.isEmpty()) {
                            blockEntityTag.putString("SkinSnapshot", snapshot);
                        }
                        if ((quickSkinId = boxBlockEntity.getQuickSkinId()) != null && !quickSkinId.isEmpty()) {
                            blockEntityTag.putString("QuickSkinId", quickSkinId);
                        }
                    }
                    blockEntityTag.putString("id", "blockpops:figure_block");
                    figureBlockItem.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)blockEntityTag));
                    if (!player.getInventory().add(figureBlockItem)) {
                        player.drop(figureBlockItem, false);
                    }
                    boxBlockEntity.setFigureExtracted(true);
                    level.playSound(null, pos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return ItemInteractionResult.SUCCESS;
                }
            } else {
                if (heldItem.getItem() == Items.SHEARS) {
                    boxBlockEntity.toggleOpen();
                    level.playSound(null, pos, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return ItemInteractionResult.SUCCESS;
                }
                player.displayClientMessage((Component)Component.literal((String)"Use Shears to open").withStyle(ChatFormatting.GRAY), true);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof BoxBlockEntity)) {
            return InteractionResult.PASS;
        }
        BoxBlockEntity boxBlockEntity = (BoxBlockEntity)blockEntity;
        if (player.isShiftKeyDown()) {
            if (boxBlockEntity.isOpen() && !level.isClientSide) {
                boxBlockEntity.toggleOpen();
                return InteractionResult.SUCCESS;
            }
            if (!boxBlockEntity.isOpen() && level.isClientSide && PlatformHelper.isDevelopmentEnvironment()) {
                PlatformHelper.openBoxFigureScreen(pos, boxBlockEntity);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction playerFacing = context.getHorizontalDirection();
        Direction blockFacing = playerFacing.getOpposite();
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)blockFacing);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof BoxBlockEntity) {
            BoxBlockEntity boxBlockEntity = (BoxBlockEntity)blockEntity;
            CustomData customData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
            if (customData != null) {
                CompoundTag tag = customData.copyTag();
                if (tag.contains("QuickSkinId")) {
                    boxBlockEntity.setQuickSkinId(tag.getString("QuickSkinId"));
                }
                if (tag.contains("SkinSnapshot")) {
                    boxBlockEntity.setSkinSnapshot(tag.getString("SkinSnapshot"));
                }
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof BoxBlockEntity) {
            BoxBlockEntity boxBlockEntity = (BoxBlockEntity)blockEntity;
            String collectionId = boxBlockEntity.getCollectionId();
            PopBlockColor color = boxBlockEntity.getColor();
            ItemStack dropStack = color != null ? new ItemStack((ItemLike)ModItems.DEFAULT_BOX_BLOCK_ITEMS.get((Object)color).get()) : (collectionId != null && !collectionId.isEmpty() ? new ItemStack((ItemLike)ModItems.BOX_BLOCK_ITEMS.get(collectionId).get()) : new ItemStack((ItemLike)this.asItem()));
            boxBlockEntity.saveToItem(dropStack);
            BoxBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)dropStack);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        ItemStack stack = super.getCloneItemStack(level, pos, state);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BoxBlockEntity) {
            BoxBlockEntity boxBlockEntity = (BoxBlockEntity)blockEntity;
            boxBlockEntity.saveToItem(stack);
        }
        return stack;
    }
}

