/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.block;

import com.mojang.serialization.MapCodec;
import com.theplumteam.blockentity.FigureBlockEntity;
import com.theplumteam.registry.ModBlockEntities;
import com.theplumteam.registry.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FigureBlock
extends BaseEntityBlock {
    public static final MapCodec<FigureBlock> CODEC = FigureBlock.simpleCodec(FigureBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0);

    public FigureBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FigureBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? FigureBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.FIGURE_BLOCK.get()), FigureBlockEntity::tick) : null;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!player.isShiftKeyDown()) {
            FigureBlockEntity figureBlockEntity;
            BlockEntity blockEntity;
            if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof FigureBlockEntity && (figureBlockEntity = (FigureBlockEntity)blockEntity).hasFigure()) {
                figureBlockEntity.cycleAlternativeSkin();
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction playerFacing = context.getHorizontalDirection();
        Direction blockFacing = playerFacing.getOpposite();
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)blockFacing);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof FigureBlockEntity) {
            FigureBlockEntity figureBlockEntity = (FigureBlockEntity)blockEntity;
            CustomData customData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
            if (customData != null) {
                CompoundTag tag = customData.copyTag();
                if (tag.contains("QuickSkinId")) {
                    figureBlockEntity.setQuickSkinId(tag.getString("QuickSkinId"));
                }
                if (tag.contains("SkinSnapshot")) {
                    figureBlockEntity.setSkinSnapshot(tag.getString("SkinSnapshot"));
                }
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof FigureBlockEntity) {
            FigureBlockEntity figureBlockEntity = (FigureBlockEntity)blockEntity;
            ItemStack dropStack = new ItemStack((ItemLike)ModItems.FIGURE_BLOCK_ITEM.get());
            figureBlockEntity.saveToItem(dropStack);
            FigureBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)dropStack);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        ItemStack stack = super.getCloneItemStack(level, pos, state);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FigureBlockEntity) {
            FigureBlockEntity figureBlockEntity = (FigureBlockEntity)blockEntity;
            figureBlockEntity.saveToItem(stack);
        }
        return stack;
    }
}

