/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.theplumteam.block.PopBlockColor;
import com.theplumteam.client.config.ClientConfig;
import com.theplumteam.client.gui.StarPatternCache;
import com.theplumteam.client.gui.util.GuiScaleManager;
import com.theplumteam.client.gui.widget.ColorSelectionButton;
import com.theplumteam.network.SetFavoriteColorPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FavoriteColorSelectionScreen
extends Screen {
    private static final Logger LOGGER = LoggerFactory.getLogger(FavoriteColorSelectionScreen.class);
    @Nullable
    private PopBlockColor selectedColor = null;
    private Button doneButton;
    private Button toggleFigureButton;
    private boolean showFigureInBox = true;
    private final List<ColorSelectionButton> colorButtons = new ArrayList<ColorSelectionButton>();
    private int panelX;
    private int panelY;
    private int panelWidth;
    private int panelHeight;
    private static final int MIN_PANEL_WIDTH = 400;
    private static final int MAX_PANEL_WIDTH = 600;
    private static final int MIN_PANEL_HEIGHT = 450;
    private float rotationX = 342.3f;
    private float rotationY = 335.9f;
    private float rotationZ = 0.0f;
    private float scale = 1.2f;
    private float offsetX = 198.0f;
    private float offsetY = -134.0f;
    private float offsetZ = 0.0f;
    private float containerScale = 1.2f;
    private boolean guiScaleForced = false;
    private boolean isClosing = false;

    public FavoriteColorSelectionScreen() {
        super((Component)Component.literal((String)"Choose Your Favorite Color"));
        LOGGER.info("FavoriteColorSelectionScreen created");
    }

    protected void init() {
        if (this.isClosing) {
            super.init();
            return;
        }
        if (!this.guiScaleForced && GuiScaleManager.setMenuGuiScale(GuiScaleManager.getOptimalMenuScale(), true)) {
            this.guiScaleForced = true;
            return;
        }
        super.init();
        this.clearWidgets();
        this.colorButtons.clear();
        this.calculatePanelDimensions();
        int scaledPadding = 20;
        int scaledSpacing = 10;
        int scaledComponentHeight = 24;
        int titleY = this.panelY + scaledPadding;
        int buttonSize = (int)(60.0f * this.containerScale);
        int gridCols = 4;
        int gridRows = 4;
        int gridWidth = gridCols * buttonSize + (gridCols - 1) * scaledSpacing;
        int gridHeight = gridRows * buttonSize + (gridRows - 1) * scaledSpacing;
        int gridStartX = this.panelX + (this.panelWidth - gridWidth) / 2;
        Objects.requireNonNull(this.font);
        int descriptionHeight = 9 * 3;
        int gridStartY = titleY + descriptionHeight + scaledPadding;
        PopBlockColor[] colors = PopBlockColor.values();
        for (int i = 0; i < colors.length; ++i) {
            PopBlockColor color = colors[i];
            int row = i / gridCols;
            int col = i % gridCols;
            int x = gridStartX + col * (buttonSize + scaledSpacing);
            int y = gridStartY + row * (buttonSize + scaledSpacing);
            ColorSelectionButton colorButton = new ColorSelectionButton(x, y, buttonSize, color, this);
            this.addRenderableWidget((GuiEventListener)colorButton);
            this.colorButtons.add(colorButton);
        }
        int buttonWidth = 200;
        int toggleButtonWidth = 120;
        int buttonSpacing = 10;
        int totalButtonWidth = buttonWidth + toggleButtonWidth + buttonSpacing;
        int buttonsStartX = this.panelX + (this.panelWidth - totalButtonWidth) / 2;
        int doneButtonY = this.panelY + this.panelHeight - scaledPadding - scaledComponentHeight;
        this.toggleFigureButton = Button.builder((Component)Component.literal((String)(this.showFigureInBox ? "Figure: ON" : "Figure: OFF")), button -> {
            this.showFigureInBox = !this.showFigureInBox;
            button.setMessage((Component)Component.literal((String)(this.showFigureInBox ? "Figure: ON" : "Figure: OFF")));
            this.updateFigureVisibility();
        }).bounds(buttonsStartX, doneButtonY, toggleButtonWidth, scaledComponentHeight).build();
        this.addRenderableWidget((GuiEventListener)this.toggleFigureButton);
        int doneButtonX = buttonsStartX + toggleButtonWidth + buttonSpacing;
        this.doneButton = Button.builder((Component)Component.literal((String)"Done"), button -> {
            if (this.selectedColor != null) {
                LOGGER.info("Player confirmed favorite color choice: {}", (Object)this.selectedColor.getSerializedName());
                SetFavoriteColorPacket packet = new SetFavoriteColorPacket(this.selectedColor.getSerializedName());
                packet.sendToServer();
                this.onClose();
            }
        }).bounds(doneButtonX, doneButtonY, buttonWidth, scaledComponentHeight).build();
        this.doneButton.active = false;
        this.addRenderableWidget((GuiEventListener)this.doneButton);
        this.updateButtonTransforms();
    }

    private void updateButtonTransforms() {
        for (ColorSelectionButton button : this.colorButtons) {
            button.setTransforms(this.rotationX, this.rotationY, this.rotationZ, this.scale, this.offsetX, this.offsetY, this.offsetZ);
        }
    }

    private void updateFigureVisibility() {
        for (ColorSelectionButton button : this.colorButtons) {
            button.setShowFigure(this.showFigureInBox);
        }
    }

    private void calculatePanelDimensions() {
        int desiredWidth = (int)((float)this.width * 0.5f);
        int desiredHeight = (int)((float)this.height * 0.7f);
        this.panelWidth = Mth.clamp((int)desiredWidth, (int)400, (int)Math.min(600, this.width - 60));
        this.panelHeight = Mth.clamp((int)desiredHeight, (int)450, (int)(this.height - 60));
        this.panelX = (this.width - this.panelWidth) / 2;
        this.panelY = (this.height - this.panelHeight) / 2;
    }

    public void setSelectedColor(PopBlockColor color) {
        this.selectedColor = color;
        this.doneButton.active = true;
        for (ColorSelectionButton button : this.colorButtons) {
            button.setSelected(button.getColor() == color);
        }
        LOGGER.debug("Selected color: {}", (Object)color.getSerializedName());
    }

    public void onClose() {
        this.isClosing = true;
        this.restoreGuiScaleIfNeeded();
        super.onClose();
    }

    public void removed() {
        this.isClosing = true;
        this.restoreGuiScaleIfNeeded();
        super.removed();
    }

    private void restoreGuiScaleIfNeeded() {
        if (this.guiScaleForced) {
            this.guiScaleForced = false;
            GuiScaleManager.restoreOriginalGuiScale();
            LOGGER.info("Restored original GUI scale");
        }
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackgroundEffects(graphics, partialTick);
        this.renderPanel(graphics);
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTitleAndDescription(graphics);
    }

    private void renderBackgroundEffects(GuiGraphics graphics, float partialTick) {
        int bgColor = -16777216;
        graphics.fill(0, 0, this.width, this.height, bgColor);
        this.renderStarPattern(graphics, partialTick);
    }

    private void renderStarPattern(GuiGraphics graphics, float partialTick) {
        double pixelsPerSecond = 5.0;
        int tileSize = StarPatternCache.getTileSize();
        int tickCount = this.minecraft != null ? this.minecraft.gui.getGuiTicks() : 0;
        double smoothTime = (double)((float)tickCount + partialTick) / 20.0;
        double offsetX = smoothTime * pixelsPerSecond % (double)tileSize;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        ClientConfig config = ClientConfig.getInstance();
        RenderSystem.setShaderColor((float)config.starColorR, (float)config.starColorG, (float)config.starColorB, (float)config.starOpacity);
        ResourceLocation cacheTexture = StarPatternCache.getTextureLocation();
        int cacheWidth = StarPatternCache.getTextureWidth();
        int cacheHeight = StarPatternCache.getTextureHeight();
        float u0 = (float)offsetX / (float)cacheWidth;
        float v0 = 0.0f;
        float u1 = u0 + (float)this.width / (float)cacheWidth;
        float v1 = (float)this.height / (float)cacheHeight;
        PoseStack pose = graphics.pose();
        pose.pushPose();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)cacheTexture);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex(pose.last().pose(), 0.0f, (float)this.height, 0.0f).setUv(u0, v1);
        bufferBuilder.addVertex(pose.last().pose(), (float)this.width, (float)this.height, 0.0f).setUv(u1, v1);
        bufferBuilder.addVertex(pose.last().pose(), (float)this.width, 0.0f, 0.0f).setUv(u1, v0);
        bufferBuilder.addVertex(pose.last().pose(), 0.0f, 0.0f, 0.0f).setUv(u0, v0);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        pose.popPose();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderPanel(GuiGraphics graphics) {
        ClientConfig config = ClientConfig.getInstance();
        int alpha = (int)(config.panelOpacity * 255.0f);
        int panelBgColor = alpha << 24 | 0;
        graphics.fill(this.panelX, this.panelY, this.panelX + this.panelWidth, this.panelY + this.panelHeight, panelBgColor);
        graphics.fill(this.panelX, this.panelY, this.panelX + this.panelWidth, this.panelY + 1, 0x60FFFFFF);
        graphics.fill(this.panelX, this.panelY + this.panelHeight - 1, this.panelX + this.panelWidth, this.panelY + this.panelHeight, 0x60FFFFFF);
        graphics.fill(this.panelX, this.panelY + 1, this.panelX + 1, this.panelY + this.panelHeight - 1, 0x60FFFFFF);
        graphics.fill(this.panelX + this.panelWidth - 1, this.panelY + 1, this.panelX + this.panelWidth, this.panelY + this.panelHeight - 1, 0x60FFFFFF);
    }

    private void renderTitleAndDescription(GuiGraphics graphics) {
        int scaledPadding = 20;
        int titleY = this.panelY + scaledPadding;
        String title = "Choose Your Favorite Color";
        int titleWidth = this.font.width(title);
        int titleX = this.panelX + (this.panelWidth - titleWidth) / 2;
        graphics.drawString(this.font, title, titleX, titleY, 0xFFFFFF, false);
        Objects.requireNonNull(this.font);
        String desc1 = "This color will be used for your figure box";
        int desc1Width = this.font.width(desc1);
        int desc1X = this.panelX + (this.panelWidth - desc1Width) / 2;
        graphics.drawString(this.font, desc1, desc1X, titleY += 9 + 8, 0xAAAAAA, false);
        Objects.requireNonNull(this.font);
        String desc2 = "in the World Players collection.";
        int desc2Width = this.font.width(desc2);
        int desc2X = this.panelX + (this.panelWidth - desc2Width) / 2;
        graphics.drawString(this.font, desc2, desc2X, titleY += 9 + 2, 0xAAAAAA, false);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public void renderBlurredBackground(float partialTick) {
    }
}

