/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.gui;

import com.mojang.authlib.GameProfile;
import com.theplumteam.blockentity.BoxBlockEntity;
import com.theplumteam.blockentity.FigureBlockEntity;
import com.theplumteam.figure.FigureDefinition;
import com.theplumteam.figure.FigureType;
import com.theplumteam.network.FigurePositionPacket;
import com.theplumteam.util.SkinModelDetector;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FigurePositionScreen
extends Screen {
    private static final Logger LOGGER = LoggerFactory.getLogger(FigurePositionScreen.class);
    private static final Map<UUID, GameProfile> profileCache = new ConcurrentHashMap<UUID, GameProfile>();
    private static final Set<UUID> registeredSkins = Collections.newSetFromMap(new ConcurrentHashMap());
    private static boolean checkedQuickSkin = false;
    private static boolean quickSkinAvailable = false;
    private static Method getSkinLocationMethod;
    private static Object playerAppearanceServiceInstance;
    private final BlockPos blockPos;
    private double offsetX;
    private double offsetY;
    private double offsetZ;
    private double scale;
    private double hitboxOffsetX;
    private double hitboxOffsetY;
    private double hitboxOffsetZ;
    private double hitboxScaleX;
    private double hitboxScaleY;
    private double hitboxScaleZ;
    private Double logoPositionX;
    private Double logoPositionY;
    private Double logoPositionZ;
    private Double logoScaleX;
    private Double logoScaleY;
    private Double logoScaleZ;

    private static ResourceLocation getQuickSkinLocation(UUID uuid) {
        if (!checkedQuickSkin) {
            try {
                Class<?> serviceClass = Class.forName("com.quickskin.mod.client.services.PlayerAppearanceService");
                Method getInstanceMethod = serviceClass.getMethod("getInstance", new Class[0]);
                playerAppearanceServiceInstance = getInstanceMethod.invoke(null, new Object[0]);
                getSkinLocationMethod = serviceClass.getMethod("getSkinLocation", UUID.class);
                quickSkinAvailable = true;
            }
            catch (Exception e) {
                quickSkinAvailable = false;
            }
            checkedQuickSkin = true;
        }
        if (quickSkinAvailable && playerAppearanceServiceInstance != null) {
            try {
                return (ResourceLocation)getSkinLocationMethod.invoke(playerAppearanceServiceInstance, uuid);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public FigurePositionScreen(BlockPos blockPos, double offsetX, double offsetY, double offsetZ, double scale, double hitboxOffsetX, double hitboxOffsetY, double hitboxOffsetZ, double hitboxScaleX, double hitboxScaleY, double hitboxScaleZ, Double logoPositionX, Double logoPositionY, Double logoPositionZ, Double logoScaleX, Double logoScaleY, Double logoScaleZ) {
        super((Component)Component.literal((String)"Adjust Figure, Hitbox & Logo"));
        this.blockPos = blockPos;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.scale = scale;
        this.hitboxOffsetX = hitboxOffsetX;
        this.hitboxOffsetY = hitboxOffsetY;
        this.hitboxOffsetZ = hitboxOffsetZ;
        this.hitboxScaleX = hitboxScaleX;
        this.hitboxScaleY = hitboxScaleY;
        this.hitboxScaleZ = hitboxScaleZ;
        this.logoPositionX = logoPositionX;
        this.logoPositionY = logoPositionY;
        this.logoPositionZ = logoPositionZ;
        this.logoScaleX = logoScaleX;
        this.logoScaleY = logoScaleY;
        this.logoScaleZ = logoScaleZ;
    }

    private void addFineTuneButtons(int x, int y, Runnable decrementAction, Runnable incrementAction) {
        int buttonWidth = 18;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"-"), button -> {
            decrementAction.run();
            this.rebuildWidgets();
        }).bounds(x, y, buttonWidth, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"+"), button -> {
            incrementAction.run();
            this.rebuildWidgets();
        }).bounds(x + buttonWidth + 2, y, buttonWidth, 20).build());
    }

    protected void init() {
        super.init();
        int centerX = this.width / 2;
        int startY = 50;
        int sliderWidth = 140;
        int columnSpacing = 200;
        int col1X = centerX - columnSpacing - 70;
        int col2X = centerX - 70;
        int col3X = centerX + columnSpacing - 70;
        this.addRenderableWidget((GuiEventListener)new AbstractSliderButton(col1X, startY, sliderWidth, 20, (Component)Component.literal((String)("X Offset: " + String.format("%.2f", this.offsetX))), (this.offsetX + 1.0) / 2.0){

            protected void updateMessage() {
                FigurePositionScreen.this.offsetX = this.value * 2.0 - 1.0;
                this.setMessage((Component)Component.literal((String)("X Offset: " + String.format("%.2f", FigurePositionScreen.this.offsetX))));
                FigurePositionScreen.this.sendUpdate();
            }

            protected void applyValue() {
                FigurePositionScreen.this.offsetX = this.value * 2.0 - 1.0;
                FigurePositionScreen.this.sendUpdate();
            }
        });
        this.addFineTuneButtons(col1X + sliderWidth + 2, startY, () -> {
            this.offsetX = Math.max(-1.0, this.offsetX - 0.001);
            this.sendUpdate();
        }, () -> {
            this.offsetX = Math.min(1.0, this.offsetX + 0.001);
            this.sendUpdate();
        });
        this.addRenderableWidget((GuiEventListener)new AbstractSliderButton(col1X, startY + 25, sliderWidth, 20, (Component)Component.literal((String)("Y Offset: " + String.format("%.2f", this.offsetY))), (this.offsetY + 1.0) / 2.0){

            protected void updateMessage() {
                FigurePositionScreen.this.offsetY = this.value * 2.0 - 1.0;
                this.setMessage((Component)Component.literal((String)("Y Offset: " + String.format("%.2f", FigurePositionScreen.this.offsetY))));
                FigurePositionScreen.this.sendUpdate();
            }

            protected void applyValue() {
                FigurePositionScreen.this.offsetY = this.value * 2.0 - 1.0;
                FigurePositionScreen.this.sendUpdate();
            }
        });
        this.addFineTuneButtons(col1X + sliderWidth + 2, startY + 25, () -> {
            this.offsetY = Math.max(-1.0, this.offsetY - 0.001);
            this.sendUpdate();
        }, () -> {
            this.offsetY = Math.min(1.0, this.offsetY + 0.001);
            this.sendUpdate();
        });
        this.addRenderableWidget((GuiEventListener)new AbstractSliderButton(col1X, startY + 50, sliderWidth, 20, (Component)Component.literal((String)("Z Offset: " + String.format("%.2f", this.offsetZ))), (this.offsetZ + 1.0) / 2.0){

            protected void updateMessage() {
                FigurePositionScreen.this.offsetZ = this.value * 2.0 - 1.0;
                this.setMessage((Component)Component.literal((String)("Z Offset: " + String.format("%.2f", FigurePositionScreen.this.offsetZ))));
                FigurePositionScreen.this.sendUpdate();
            }

            protected void applyValue() {
                FigurePositionScreen.this.offsetZ = this.value * 2.0 - 1.0;
                FigurePositionScreen.this.sendUpdate();
            }
        });
        this.addFineTuneButtons(col1X + sliderWidth + 2, startY + 50, () -> {
            this.offsetZ = Math.max(-1.0, this.offsetZ - 0.001);
            this.sendUpdate();
        }, () -> {
            this.offsetZ = Math.min(1.0, this.offsetZ + 0.001);
            this.sendUpdate();
        });
        this.addRenderableWidget((GuiEventListener)new AbstractSliderButton(col1X, startY + 75, sliderWidth, 20, (Component)Component.literal((String)("Scale: " + String.format("%.2f", this.scale))), (this.scale - 0.1) / 1.9){

            protected void updateMessage() {
                FigurePositionScreen.this.scale = 0.1 + this.value * 1.9;
                this.setMessage((Component)Component.literal((String)("Scale: " + String.format("%.2f", FigurePositionScreen.this.scale))));
                FigurePositionScreen.this.sendUpdate();
            }

            protected void applyValue() {
                FigurePositionScreen.this.scale = 0.1 + this.value * 1.9;
                FigurePositionScreen.this.sendUpdate();
            }
        });
        this.addFineTuneButtons(col1X + sliderWidth + 2, startY + 75, () -> {
            this.scale = Math.max(0.1, this.scale - 0.001);
            this.sendUpdate();
        }, () -> {
            this.scale = Math.min(2.0, this.scale + 0.001);
            this.sendUpdate();
        });
        this.addRenderableWidget((GuiEventListener)new AbstractSliderButton(col2X, startY, sliderWidth, 20, (Component)Component.literal((String)("Hitbox X: " + String.format("%.2f", this.hitboxOffsetX))), (this.hitboxOffsetX + 1.0) / 2.0){

            protected void updateMessage() {
                FigurePositionScreen.this.hitboxOffsetX = this.value * 2.0 - 1.0;
                this.setMessage((Component)Component.literal((String)("Hitbox X: " + String.format("%.2f", FigurePositionScreen.this.hitboxOffsetX))));
                FigurePositionScreen.this.sendUpdate();
            }

            protected void applyValue() {
                FigurePositionScreen.this.hitboxOffsetX = this.value * 2.0 - 1.0;
                FigurePositionScreen.this.sendUpdate();
            }
        });
        this.addFineTuneButtons(col2X + sliderWidth + 2, startY, () -> {
            this.hitboxOffsetX = Math.max(-1.0, this.hitboxOffsetX - 0.001);
            this.sendUpdate();
        }, () -> {
            this.hitboxOffsetX = Math.min(1.0, this.hitboxOffsetX + 0.001);
            this.sendUpdate();
        });
        this.addRenderableWidget((GuiEventListener)new AbstractSliderButton(col2X, startY + 25, sliderWidth, 20, (Component)Component.literal((String)("Hitbox Y: " + String.format("%.2f", this.hitboxOffsetY))), (this.hitboxOffsetY + 1.0) / 2.0){

            protected void updateMessage() {
                FigurePositionScreen.this.hitboxOffsetY = this.value * 2.0 - 1.0;
                this.setMessage((Component)Component.literal((String)("Hitbox Y: " + String.format("%.2f", FigurePositionScreen.this.hitboxOffsetY))));
                FigurePositionScreen.this.sendUpdate();
            }

            protected void applyValue() {
                FigurePositionScreen.this.hitboxOffsetY = this.value * 2.0 - 1.0;
                FigurePositionScreen.this.sendUpdate();
            }
        });
        this.addFineTuneButtons(col2X + sliderWidth + 2, startY + 25, () -> {
            this.hitboxOffsetY = Math.max(-1.0, this.hitboxOffsetY - 0.001);
            this.sendUpdate();
        }, () -> {
            this.hitboxOffsetY = Math.min(1.0, this.hitboxOffsetY + 0.001);
            this.sendUpdate();
        });
        this.addRenderableWidget((GuiEventListener)new AbstractSliderButton(col2X, startY + 50, sliderWidth, 20, (Component)Component.literal((String)("Hitbox Z: " + String.format("%.2f", this.hitboxOffsetZ))), (this.hitboxOffsetZ + 1.0) / 2.0){

            protected void updateMessage() {
                FigurePositionScreen.this.hitboxOffsetZ = this.value * 2.0 - 1.0;
                this.setMessage((Component)Component.literal((String)("Hitbox Z: " + String.format("%.2f", FigurePositionScreen.this.hitboxOffsetZ))));
                FigurePositionScreen.this.sendUpdate();
            }

            protected void applyValue() {
                FigurePositionScreen.this.hitboxOffsetZ = this.value * 2.0 - 1.0;
                FigurePositionScreen.this.sendUpdate();
            }
        });
        this.addFineTuneButtons(col2X + sliderWidth + 2, startY + 50, () -> {
            this.hitboxOffsetZ = Math.max(-1.0, this.hitboxOffsetZ - 0.001);
            this.sendUpdate();
        }, () -> {
            this.hitboxOffsetZ = Math.min(1.0, this.hitboxOffsetZ + 0.001);
            this.sendUpdate();
        });
        this.addRenderableWidget((GuiEventListener)new AbstractSliderButton(col2X, startY + 75, sliderWidth, 20, (Component)Component.literal((String)("Hitbox Scale X: " + String.format("%.2f", this.hitboxScaleX))), (this.hitboxScaleX - 0.5) / 1.5){

            protected void updateMessage() {
                FigurePositionScreen.this.hitboxScaleX = 0.5 + this.value * 1.5;
                this.setMessage((Component)Component.literal((String)("Hitbox Scale X: " + String.format("%.2f", FigurePositionScreen.this.hitboxScaleX))));
                FigurePositionScreen.this.sendUpdate();
            }

            protected void applyValue() {
                FigurePositionScreen.this.hitboxScaleX = 0.5 + this.value * 1.5;
                FigurePositionScreen.this.sendUpdate();
            }
        });
        this.addFineTuneButtons(col2X + sliderWidth + 2, startY + 75, () -> {
            this.hitboxScaleX = Math.max(0.5, this.hitboxScaleX - 0.01);
            this.sendUpdate();
        }, () -> {
            this.hitboxScaleX = Math.min(2.0, this.hitboxScaleX + 0.01);
            this.sendUpdate();
        });
        this.addRenderableWidget((GuiEventListener)new AbstractSliderButton(col2X, startY + 100, sliderWidth, 20, (Component)Component.literal((String)("Hitbox Scale Y: " + String.format("%.2f", this.hitboxScaleY))), (this.hitboxScaleY - 0.5) / 1.5){

            protected void updateMessage() {
                FigurePositionScreen.this.hitboxScaleY = 0.5 + this.value * 1.5;
                this.setMessage((Component)Component.literal((String)("Hitbox Scale Y: " + String.format("%.2f", FigurePositionScreen.this.hitboxScaleY))));
                FigurePositionScreen.this.sendUpdate();
            }

            protected void applyValue() {
                FigurePositionScreen.this.hitboxScaleY = 0.5 + this.value * 1.5;
                FigurePositionScreen.this.sendUpdate();
            }
        });
        this.addFineTuneButtons(col2X + sliderWidth + 2, startY + 100, () -> {
            this.hitboxScaleY = Math.max(0.5, this.hitboxScaleY - 0.01);
            this.sendUpdate();
        }, () -> {
            this.hitboxScaleY = Math.min(2.0, this.hitboxScaleY + 0.01);
            this.sendUpdate();
        });
        this.addRenderableWidget((GuiEventListener)new AbstractSliderButton(col2X, startY + 125, sliderWidth, 20, (Component)Component.literal((String)("Hitbox Scale Z: " + String.format("%.2f", this.hitboxScaleZ))), (this.hitboxScaleZ - 0.5) / 1.5){

            protected void updateMessage() {
                FigurePositionScreen.this.hitboxScaleZ = 0.5 + this.value * 1.5;
                this.setMessage((Component)Component.literal((String)("Hitbox Scale Z: " + String.format("%.2f", FigurePositionScreen.this.hitboxScaleZ))));
                FigurePositionScreen.this.sendUpdate();
            }

            protected void applyValue() {
                FigurePositionScreen.this.hitboxScaleZ = 0.5 + this.value * 1.5;
                FigurePositionScreen.this.sendUpdate();
            }
        });
        this.addFineTuneButtons(col2X + sliderWidth + 2, startY + 125, () -> {
            this.hitboxScaleZ = Math.max(0.5, this.hitboxScaleZ - 0.01);
            this.sendUpdate();
        }, () -> {
            this.hitboxScaleZ = Math.min(2.0, this.hitboxScaleZ + 0.01);
            this.sendUpdate();
        });
        double logoX = this.logoPositionX != null ? this.logoPositionX : 0.0;
        this.addRenderableWidget((GuiEventListener)new AbstractSliderButton(col3X, startY, sliderWidth, 20, (Component)Component.literal((String)("Logo X (Depth): " + String.format("%.2f", logoX))), (logoX + 10.0) / 20.0){

            protected void updateMessage() {
                FigurePositionScreen.this.logoPositionX = this.value * 20.0 - 10.0;
                this.setMessage((Component)Component.literal((String)("Logo X (Depth): " + String.format("%.2f", FigurePositionScreen.this.logoPositionX))));
                FigurePositionScreen.this.sendUpdate();
            }

            protected void applyValue() {
                FigurePositionScreen.this.logoPositionX = this.value * 20.0 - 10.0;
                FigurePositionScreen.this.sendUpdate();
            }
        });
        this.addFineTuneButtons(col3X + sliderWidth + 2, startY, () -> {
            this.logoPositionX = Math.max(-10.0, (this.logoPositionX != null ? this.logoPositionX : 0.0) - 0.001);
            this.sendUpdate();
        }, () -> {
            this.logoPositionX = Math.min(10.0, (this.logoPositionX != null ? this.logoPositionX : 0.0) + 0.001);
            this.sendUpdate();
        });
        double logoY = this.logoPositionY != null ? this.logoPositionY : 0.0;
        this.addRenderableWidget((GuiEventListener)new AbstractSliderButton(col3X, startY + 25, sliderWidth, 20, (Component)Component.literal((String)("Logo Y (Vertical): " + String.format("%.2f", logoY))), (logoY + 10.0) / 20.0){

            protected void updateMessage() {
                FigurePositionScreen.this.logoPositionY = this.value * 20.0 - 10.0;
                this.setMessage((Component)Component.literal((String)("Logo Y (Vertical): " + String.format("%.2f", FigurePositionScreen.this.logoPositionY))));
                FigurePositionScreen.this.sendUpdate();
            }

            protected void applyValue() {
                FigurePositionScreen.this.logoPositionY = this.value * 20.0 - 10.0;
                FigurePositionScreen.this.sendUpdate();
            }
        });
        this.addFineTuneButtons(col3X + sliderWidth + 2, startY + 25, () -> {
            this.logoPositionY = Math.max(-10.0, (this.logoPositionY != null ? this.logoPositionY : 0.0) - 0.001);
            this.sendUpdate();
        }, () -> {
            this.logoPositionY = Math.min(10.0, (this.logoPositionY != null ? this.logoPositionY : 0.0) + 0.001);
            this.sendUpdate();
        });
        double logoZ = this.logoPositionZ != null ? this.logoPositionZ : 0.0;
        this.addRenderableWidget((GuiEventListener)new AbstractSliderButton(col3X, startY + 50, sliderWidth, 20, (Component)Component.literal((String)("Logo Z (Horizontal): " + String.format("%.2f", logoZ))), (logoZ + 10.0) / 20.0){

            protected void updateMessage() {
                FigurePositionScreen.this.logoPositionZ = this.value * 20.0 - 10.0;
                this.setMessage((Component)Component.literal((String)("Logo Z (Horizontal): " + String.format("%.2f", FigurePositionScreen.this.logoPositionZ))));
                FigurePositionScreen.this.sendUpdate();
            }

            protected void applyValue() {
                FigurePositionScreen.this.logoPositionZ = this.value * 20.0 - 10.0;
                FigurePositionScreen.this.sendUpdate();
            }
        });
        this.addFineTuneButtons(col3X + sliderWidth + 2, startY + 50, () -> {
            this.logoPositionZ = Math.max(-10.0, (this.logoPositionZ != null ? this.logoPositionZ : 0.0) - 0.001);
            this.sendUpdate();
        }, () -> {
            this.logoPositionZ = Math.min(10.0, (this.logoPositionZ != null ? this.logoPositionZ : 0.0) + 0.001);
            this.sendUpdate();
        });
        double scaleX = this.logoScaleX != null ? this.logoScaleX : 5.0;
        this.addRenderableWidget((GuiEventListener)new AbstractSliderButton(col3X, startY + 75, sliderWidth, 20, (Component)Component.literal((String)("Logo Width (X): " + String.format("%.2f", scaleX))), (scaleX - 0.5) / 9.5){

            protected void updateMessage() {
                FigurePositionScreen.this.logoScaleX = 0.5 + this.value * 9.5;
                this.setMessage((Component)Component.literal((String)("Logo Width (X): " + String.format("%.2f", FigurePositionScreen.this.logoScaleX))));
                FigurePositionScreen.this.sendUpdate();
            }

            protected void applyValue() {
                FigurePositionScreen.this.logoScaleX = 0.5 + this.value * 9.5;
                FigurePositionScreen.this.sendUpdate();
            }
        });
        this.addFineTuneButtons(col3X + sliderWidth + 2, startY + 75, () -> {
            this.logoScaleX = Math.max(0.5, (this.logoScaleX != null ? this.logoScaleX : 5.0) - 0.001);
            this.sendUpdate();
        }, () -> {
            this.logoScaleX = Math.min(10.0, (this.logoScaleX != null ? this.logoScaleX : 5.0) + 0.001);
            this.sendUpdate();
        });
        double scaleY = this.logoScaleY != null ? this.logoScaleY : 5.0;
        this.addRenderableWidget((GuiEventListener)new AbstractSliderButton(col3X, startY + 100, sliderWidth, 20, (Component)Component.literal((String)("Logo Height (Y): " + String.format("%.2f", scaleY))), (scaleY - 0.5) / 9.5){

            protected void updateMessage() {
                FigurePositionScreen.this.logoScaleY = 0.5 + this.value * 9.5;
                this.setMessage((Component)Component.literal((String)("Logo Height (Y): " + String.format("%.2f", FigurePositionScreen.this.logoScaleY))));
                FigurePositionScreen.this.sendUpdate();
            }

            protected void applyValue() {
                FigurePositionScreen.this.logoScaleY = 0.5 + this.value * 9.5;
                FigurePositionScreen.this.sendUpdate();
            }
        });
        this.addFineTuneButtons(col3X + sliderWidth + 2, startY + 100, () -> {
            this.logoScaleY = Math.max(0.5, (this.logoScaleY != null ? this.logoScaleY : 5.0) - 0.001);
            this.sendUpdate();
        }, () -> {
            this.logoScaleY = Math.min(10.0, (this.logoScaleY != null ? this.logoScaleY : 5.0) + 0.001);
            this.sendUpdate();
        });
        double scaleZ = this.logoScaleZ != null ? this.logoScaleZ : 1.0;
        this.addRenderableWidget((GuiEventListener)new AbstractSliderButton(col3X, startY + 125, sliderWidth, 20, (Component)Component.literal((String)("Logo Depth (Z): " + String.format("%.2f", scaleZ))), (scaleZ - 0.5) / 9.5){

            protected void updateMessage() {
                FigurePositionScreen.this.logoScaleZ = 0.5 + this.value * 9.5;
                this.setMessage((Component)Component.literal((String)("Logo Depth (Z): " + String.format("%.2f", FigurePositionScreen.this.logoScaleZ))));
                FigurePositionScreen.this.sendUpdate();
            }

            protected void applyValue() {
                FigurePositionScreen.this.logoScaleZ = 0.5 + this.value * 9.5;
                FigurePositionScreen.this.sendUpdate();
            }
        });
        this.addFineTuneButtons(col3X + sliderWidth + 2, startY + 125, () -> {
            this.logoScaleZ = Math.max(0.5, (this.logoScaleZ != null ? this.logoScaleZ : 1.0) - 0.001);
            this.sendUpdate();
        }, () -> {
            this.logoScaleZ = Math.min(10.0, (this.logoScaleZ != null ? this.logoScaleZ : 1.0) + 0.001);
            this.sendUpdate();
        });
        int copyButtonY = startY + 160;
        int copyButtonWidth = 95;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Copy Figure"), button -> {
            String data = String.format("Figure: X=%.3f Y=%.3f Z=%.3f Scale=%.3f", this.offsetX, this.offsetY, this.offsetZ, this.scale);
            this.minecraft.keyboardHandler.setClipboard(data);
        }).bounds(centerX - 100, copyButtonY, copyButtonWidth, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Copy Hitbox"), button -> {
            String data = String.format("Hitbox: X=%.3f Y=%.3f Z=%.3f", this.hitboxOffsetX, this.hitboxOffsetY, this.hitboxOffsetZ);
            this.minecraft.keyboardHandler.setClipboard(data);
        }).bounds(centerX + 5, copyButtonY, copyButtonWidth, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Copy Logo"), button -> {
            String data = String.format("Logo: X=%.3f Y=%.3f Z=%.3f Width=%.3f Height=%.3f Depth=%.3f", this.logoPositionX != null ? this.logoPositionX : 0.0, this.logoPositionY != null ? this.logoPositionY : 0.0, this.logoPositionZ != null ? this.logoPositionZ : 0.0, this.logoScaleX != null ? this.logoScaleX : 5.0, this.logoScaleY != null ? this.logoScaleY : 5.0, this.logoScaleZ != null ? this.logoScaleZ : 1.0);
            this.minecraft.keyboardHandler.setClipboard(data);
        }).bounds(centerX - 45, copyButtonY + 25, copyButtonWidth, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Reset All"), button -> {
            this.offsetX = 0.0;
            this.offsetY = 0.1;
            this.offsetZ = 0.0;
            this.scale = 1.0;
            this.hitboxOffsetX = -0.03;
            this.hitboxOffsetY = 0.0;
            this.hitboxOffsetZ = -0.06;
            this.logoPositionX = null;
            this.logoPositionY = null;
            this.logoPositionZ = null;
            this.logoScaleX = null;
            this.logoScaleY = null;
            this.logoScaleZ = null;
            this.rebuildWidgets();
            this.sendUpdate();
        }).bounds(centerX - 100, copyButtonY + 50, 95, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Done"), button -> this.onClose()).bounds(centerX + 5, copyButtonY + 50, 95, 20).build());
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int skinTypeColor;
        String skinTypeText;
        block11: {
            this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
            super.render(guiGraphics, mouseX, mouseY, partialTick);
            guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
            skinTypeText = "Skin Type: Unknown";
            skinTypeColor = 0xAAAAAA;
            if (this.minecraft != null && this.minecraft.level != null) {
                FigureBlockEntity figureBlockEntity;
                BoxBlockEntity boxBlockEntity;
                BlockEntity blockEntity = this.minecraft.level.getBlockEntity(this.blockPos);
                FigureDefinition figureDefinition = null;
                int skinIndex = 0;
                if (blockEntity instanceof BoxBlockEntity && (boxBlockEntity = (BoxBlockEntity)blockEntity).hasFigure()) {
                    figureDefinition = boxBlockEntity.getFigureDefinition();
                    skinIndex = boxBlockEntity.getAlternativeSkinIndex();
                } else if (blockEntity instanceof FigureBlockEntity && (figureBlockEntity = (FigureBlockEntity)blockEntity).hasFigure()) {
                    figureDefinition = figureBlockEntity.getFigureDefinition();
                    skinIndex = figureBlockEntity.getAlternativeSkinIndex();
                }
                if (figureDefinition != null) {
                    try {
                        ResourceLocation texture = this.getTextureForFigure(figureDefinition, skinIndex);
                        if (texture != null) {
                            SkinModelDetector.SkinModel skinModel = SkinModelDetector.detectSkinModel(texture);
                            if (skinModel == SkinModelDetector.SkinModel.SLIM) {
                                skinTypeText = "Skin Type: SLIM (Alex)";
                                skinTypeColor = 16739229;
                            } else {
                                skinTypeText = "Skin Type: CLASSIC (Steve)";
                                skinTypeColor = 6139362;
                            }
                            break block11;
                        }
                        skinTypeText = "Skin Type: No Texture";
                    }
                    catch (Exception e) {
                        skinTypeText = "Skin Type: Detection Error";
                        skinTypeColor = 0xFF0000;
                    }
                } else {
                    skinTypeText = "Skin Type: No Figure";
                }
            }
        }
        guiGraphics.drawCenteredString(this.font, skinTypeText, this.width / 2, 30, skinTypeColor);
        int centerX = this.width / 2;
        int columnSpacing = 200;
        int headerY = 35;
        guiGraphics.drawCenteredString(this.font, "FIGURE", centerX - columnSpacing, headerY, 16766720);
        guiGraphics.drawCenteredString(this.font, "HITBOX", centerX, headerY, 65280);
        guiGraphics.drawCenteredString(this.font, "LOGO", centerX + columnSpacing, headerY, 49151);
    }

    private ResourceLocation getTextureForFigure(FigureDefinition figure, int skinIndex) {
        int altListIndex;
        if (figure == null) {
            return null;
        }
        if (skinIndex > 0 && figure.hasAlternatives() && (altListIndex = skinIndex - 1) < figure.getAlternatives().size()) {
            return figure.getAlternatives().get(altListIndex).texture();
        }
        if (figure.getType() == FigureType.PLAYER && figure.getPlayerUUID() != null) {
            PlayerInfo playerInfo;
            ResourceLocation quickSkinLoc = FigurePositionScreen.getQuickSkinLocation(figure.getPlayerUUID());
            if (quickSkinLoc != null) {
                return quickSkinLoc;
            }
            if (Minecraft.getInstance().getConnection() != null && (playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(figure.getPlayerUUID())) != null) {
                return playerInfo.getSkin().texture();
            }
            return ResourceLocation.withDefaultNamespace((String)"textures/entity/player/wide/steve.png");
        }
        return figure.getTexturePath();
    }

    private void sendUpdate() {
        new FigurePositionPacket(this.blockPos, this.offsetX, this.offsetY, this.offsetZ, this.scale, this.hitboxOffsetX, this.hitboxOffsetY, this.hitboxOffsetZ, this.hitboxScaleX, this.hitboxScaleY, this.hitboxScaleZ, this.logoPositionX, this.logoPositionY, this.logoPositionZ, this.logoScaleX, this.logoScaleY, this.logoScaleZ).sendToServer();
    }

    public boolean isPauseScreen() {
        return false;
    }
}

