/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.theplumteam.client.config.ClientConfig;
import com.theplumteam.client.gui.util.ButtonFactory;
import com.theplumteam.client.gui.widget.TabButton;
import com.theplumteam.figure.CollectionRegistry;
import com.theplumteam.figure.FigureCollection;
import com.theplumteam.network.ReloadTokensPacket;
import com.theplumteam.network.UnlockCollectionPacket;
import com.theplumteam.network.UpdateGuaranteedResetHourPacket;
import com.theplumteam.server.config.ServerConfig;
import dev.architectury.platform.Platform;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class SettingsScreen
extends Screen {
    private final Screen parent;
    private static final int PANEL_BG = -1342177280;
    private static final int PANEL_OUTLINE = 0x60FFFFFF;
    private static final int TITLE_COLOR = 0xFFFFFF;
    private static final int TAB_HEIGHT = 30;
    private static final int TAB_WIDTH = 100;
    private static final int TAB_SPACING = 2;
    private int panelWidth = 650;
    private int panelHeight = 350;
    private int panelX;
    private int panelY;
    private Tab activeTab = Tab.SERVER;
    private TabButton serverTabButton;
    private TabButton developTabButton;
    private TabButton cheatsTabButton;
    private final List<AbstractWidget> serverSettingWidgets = new ArrayList<AbstractWidget>();
    private final List<AbstractWidget> developSettingWidgets = new ArrayList<AbstractWidget>();
    private final List<AbstractWidget> cheatsSettingWidgets = new ArrayList<AbstractWidget>();
    private Button closeButton;
    private Button actionButton;
    private Button colorTransitionToggle;
    private HourSlider resetHourSlider;
    private int loadedServerHourLocal;
    private int pendingServerHourLocal;
    private ColorSlider starRedSlider;
    private ColorSlider starGreenSlider;
    private ColorSlider starBlueSlider;
    private OpacitySlider starOpacitySlider;
    private ColorSlider bgRedSlider;
    private ColorSlider bgGreenSlider;
    private ColorSlider bgBlueSlider;
    private OpacitySlider panelOpacitySlider;

    public SettingsScreen(Screen parent) {
        super((Component)Component.literal((String)"Settings"));
        this.parent = parent;
    }

    protected void init() {
        super.init();
        this.serverSettingWidgets.clear();
        this.developSettingWidgets.clear();
        this.cheatsSettingWidgets.clear();
        this.panelX = (this.width - this.panelWidth) / 2;
        int tabY = this.panelY = (this.height - this.panelHeight) / 2;
        int tabStartX = this.panelX;
        this.serverTabButton = (TabButton)ButtonFactory.createTab(tabStartX, tabY, 100, 30, (Component)Component.literal((String)Tab.SERVER.getDisplayName()), this.activeTab == Tab.SERVER, btn -> this.switchTab(Tab.SERVER));
        this.addRenderableWidget((GuiEventListener)this.serverTabButton);
        int nextTabX = tabStartX + 100 + 2;
        if (SettingsScreen.isDevelopmentMode()) {
            this.developTabButton = (TabButton)ButtonFactory.createTab(nextTabX, tabY, 100, 30, (Component)Component.literal((String)Tab.DEVELOP.getDisplayName()), this.activeTab == Tab.DEVELOP, btn -> this.switchTab(Tab.DEVELOP));
            this.addRenderableWidget((GuiEventListener)this.developTabButton);
            nextTabX += 102;
        }
        if (this.canAccessCheats()) {
            this.cheatsTabButton = (TabButton)ButtonFactory.createTab(nextTabX, tabY, 100, 30, (Component)Component.literal((String)Tab.CHEATS.getDisplayName()), this.activeTab == Tab.CHEATS, btn -> this.switchTab(Tab.CHEATS));
            this.addRenderableWidget((GuiEventListener)this.cheatsTabButton);
        }
        int buttonWidth = 100;
        int buttonHeight = 20;
        int buttonY = this.panelY + this.panelHeight - buttonHeight - 20;
        int buttonSpacing = 10;
        int totalButtonWidth = buttonWidth * 2 + buttonSpacing;
        int buttonsStartX = this.panelX + (this.panelWidth - totalButtonWidth) / 2;
        this.closeButton = Button.builder((Component)Component.literal((String)"Close"), button -> this.onClose()).bounds(buttonsStartX, buttonY, buttonWidth, buttonHeight).build();
        this.addRenderableWidget((GuiEventListener)this.closeButton);
        this.actionButton = Button.builder((Component)Component.literal((String)"Action"), button -> this.handleActionClick()).bounds(buttonsStartX + buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight).build();
        this.addRenderableWidget((GuiEventListener)this.actionButton);
        this.createServerSettings();
        if (SettingsScreen.isDevelopmentMode()) {
            this.createDevelopSettings();
        }
        if (this.canAccessCheats()) {
            this.createCheatsSettings();
        }
        this.switchTab(this.activeTab);
    }

    private void handleActionClick() {
        if (this.activeTab == Tab.SERVER) {
            int utcValue = SettingsScreen.convertLocalToUtc(this.pendingServerHourLocal);
            ServerConfig.getInstance().setGuaranteedTokenResetHour(utcValue);
            new UpdateGuaranteedResetHourPacket(utcValue).sendToServer();
            this.loadedServerHourLocal = this.pendingServerHourLocal;
            this.updateActionButtonState();
        } else if (this.activeTab == Tab.DEVELOP) {
            ClientConfig.getInstance().resetColors();
            this.starRedSlider.setValue(1.0);
            this.starGreenSlider.setValue(1.0);
            this.starBlueSlider.setValue(1.0);
            this.starOpacitySlider.setValue(0.2);
            this.bgRedSlider.setValue(0.0);
            this.bgGreenSlider.setValue(0.0);
            this.bgBlueSlider.setValue(0.0);
            this.panelOpacitySlider.setValue(0.9);
            this.colorTransitionToggle.setMessage((Component)Component.literal((String)"Transition: ON"));
        }
    }

    private void updateActionButtonState() {
        if (this.activeTab == Tab.SERVER) {
            this.actionButton.setMessage((Component)Component.literal((String)"Change time"));
            this.actionButton.active = this.pendingServerHourLocal != this.loadedServerHourLocal;
            this.actionButton.visible = true;
        } else if (this.activeTab == Tab.DEVELOP) {
            this.actionButton.setMessage((Component)Component.literal((String)"Reset Colors"));
            this.actionButton.active = true;
            this.actionButton.visible = true;
        } else {
            this.actionButton.visible = false;
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int lineWidth;
        int i;
        int explanationY;
        int headerY;
        if (this.parent != null) {
            this.parent.render(graphics, -1, -1, partialTicks);
        }
        graphics.flush();
        RenderSystem.disableScissor();
        RenderSystem.enableDepthTest();
        RenderSystem.clear((int)256, (boolean)false);
        graphics.fill(0, 0, this.width, this.height, 0x70000000);
        int contentPanelY = this.panelY + 30;
        int contentPanelHeight = this.panelHeight - 30;
        ClientConfig config = ClientConfig.getInstance();
        int alpha = (int)(config.panelOpacity * 255.0f);
        int panelBgColor = alpha << 24 | 0;
        graphics.fill(this.panelX, contentPanelY, this.panelX + this.panelWidth, contentPanelY + contentPanelHeight, panelBgColor);
        graphics.fill(this.panelX, contentPanelY, this.panelX + this.panelWidth, contentPanelY + 1, 0x60FFFFFF);
        graphics.fill(this.panelX, contentPanelY + contentPanelHeight - 1, this.panelX + this.panelWidth, contentPanelY + contentPanelHeight, 0x60FFFFFF);
        graphics.fill(this.panelX, contentPanelY, this.panelX + 1, contentPanelY + contentPanelHeight, 0x60FFFFFF);
        graphics.fill(this.panelX + this.panelWidth - 1, contentPanelY, this.panelX + this.panelWidth, contentPanelY + contentPanelHeight, 0x60FFFFFF);
        if (SettingsScreen.isDevelopmentMode() && this.activeTab == Tab.DEVELOP) {
            int padding = 20;
            int columnSpacing = 15;
            int availableWidth = this.panelWidth - padding * 2 - columnSpacing * 2;
            int columnWidth = availableWidth / 3;
            int col1X = this.panelX + padding;
            int col2X = col1X + columnWidth + columnSpacing;
            int col3X = col2X + columnWidth + columnSpacing;
            int headerY2 = this.panelY + 30 + 5;
            graphics.drawString(this.font, "Star Color", col1X, headerY2, 0xFFFFFF);
            graphics.drawString(this.font, "Background Color", col2X, headerY2, 0xFFFFFF);
            graphics.drawString(this.font, "Panel & Animation", col3X, headerY2, 0xFFFFFF);
        }
        if (this.activeTab == Tab.SERVER) {
            headerY = this.panelY + 30 + 10;
            graphics.drawCenteredString(this.font, "Token Reset Settings", this.panelX + this.panelWidth / 2, headerY, 0xFFFFFF);
            explanationY = this.panelY + 30 + 80;
            String[] explanationLines = new String[]{"The guaranteed token grants an undiscovered figure from the collection.", "This token resets daily at the hour specified above (in your local time).", "Set this to a time that works best for your server's player base."};
            for (i = 0; i < explanationLines.length; ++i) {
                lineWidth = this.font.width(explanationLines[i]);
                graphics.drawString(this.font, explanationLines[i], this.panelX + (this.panelWidth - lineWidth) / 2, explanationY + i * 12, 0xAAAAAA);
            }
        }
        if (this.activeTab == Tab.CHEATS) {
            headerY = this.panelY + 30 + 10;
            graphics.drawCenteredString(this.font, "Collection Cheats", this.panelX + this.panelWidth / 2, headerY, 0xFFFFFF);
            explanationY = this.panelY + 30 + 30;
            String[] explanationLines = new String[]{"Use the token reload buttons to restore your tokens.", "Click a collection button to unlock all figures and receive all boxes."};
            for (i = 0; i < explanationLines.length; ++i) {
                lineWidth = this.font.width(explanationLines[i]);
                graphics.drawString(this.font, explanationLines[i], this.panelX + (this.panelWidth - lineWidth) / 2, explanationY + i * 12, 0xAAAAAA);
            }
        }
        if (SettingsScreen.isDevelopmentMode() && this.activeTab == Tab.DEVELOP) {
            int previewSize = 35;
            int previewSpacing = 50;
            int previewStartX = this.panelX + (this.panelWidth - (previewSize * 2 + previewSpacing)) / 2;
            int previewY = this.panelY + 210;
            int starRed = (int)(config.starColorR * 255.0f);
            int starGreen = (int)(config.starColorG * 255.0f);
            int starBlue = (int)(config.starColorB * 255.0f);
            int starColor = 0xFF000000 | starRed << 16 | starGreen << 8 | starBlue;
            graphics.fill(previewStartX - 1, previewY - 1, previewStartX + previewSize + 1, previewY + previewSize + 1, -1);
            graphics.fill(previewStartX, previewY, previewStartX + previewSize, previewY + previewSize, starColor);
            graphics.drawCenteredString(this.font, "Stars", previewStartX + previewSize / 2, previewY + previewSize + 5, 0xAAAAAA);
            int bgPreviewX = previewStartX + previewSize + previewSpacing;
            int bgRed = (int)(config.backgroundColorR * 255.0f);
            int bgGreen = (int)(config.backgroundColorG * 255.0f);
            int bgBlue = (int)(config.backgroundColorB * 255.0f);
            int bgColor = 0xFF000000 | bgRed << 16 | bgGreen << 8 | bgBlue;
            graphics.fill(bgPreviewX - 1, previewY - 1, bgPreviewX + previewSize + 1, previewY + previewSize + 1, -1);
            graphics.fill(bgPreviewX, previewY, bgPreviewX + previewSize, previewY + previewSize, bgColor);
            graphics.drawCenteredString(this.font, "Background", bgPreviewX + previewSize / 2, previewY + previewSize + 5, 0xAAAAAA);
        }
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (mouseX < (double)this.panelX || mouseX > (double)(this.panelX + this.panelWidth) || mouseY < (double)this.panelY || mouseY > (double)(this.panelY + this.panelHeight)) {
            this.onClose();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    public boolean isPauseScreen() {
        return false;
    }

    private static boolean isDevelopmentMode() {
        return Platform.isDevelopmentEnvironment();
    }

    private boolean canAccessCheats() {
        if (SettingsScreen.isDevelopmentMode()) {
            return true;
        }
        if (this.minecraft != null && this.minecraft.player != null) {
            return this.minecraft.player.hasPermissions(2);
        }
        return false;
    }

    private void createServerSettings() {
        int localHour;
        ServerConfig config = ServerConfig.getInstance();
        int sliderHeight = 20;
        int sliderWidth = 400;
        int sliderX = this.panelX + (this.panelWidth - sliderWidth) / 2;
        int startY = this.panelY + 30 + 50;
        ZoneId localZone = ZoneId.systemDefault();
        String timezoneName = localZone.getDisplayName(TextStyle.SHORT, Locale.getDefault());
        int utcHour = config.getGuaranteedTokenResetHour();
        this.loadedServerHourLocal = localHour = SettingsScreen.convertUtcToLocal(utcHour);
        this.pendingServerHourLocal = localHour;
        this.resetHourSlider = new HourSlider(sliderX, startY, sliderWidth, sliderHeight, (Component)Component.literal((String)("Guaranteed Token Reset Hour (" + timezoneName + "): ")), localHour, localValue -> {
            this.pendingServerHourLocal = localValue;
            this.updateActionButtonState();
        });
        this.serverSettingWidgets.add((AbstractWidget)this.resetHourSlider);
    }

    private static int convertUtcToLocal(int utcHour) {
        ZonedDateTime utcTime = ZonedDateTime.now(ZoneId.of("UTC")).withHour(utcHour).withMinute(0).withSecond(0).withNano(0);
        ZonedDateTime localTime = utcTime.withZoneSameInstant(ZoneId.systemDefault());
        return localTime.getHour();
    }

    private static int convertLocalToUtc(int localHour) {
        ZonedDateTime localTime = ZonedDateTime.now(ZoneId.systemDefault()).withHour(localHour).withMinute(0).withSecond(0).withNano(0);
        ZonedDateTime utcTime = localTime.withZoneSameInstant(ZoneId.of("UTC"));
        return utcTime.getHour();
    }

    private void createDevelopSettings() {
        int startY;
        ClientConfig config = ClientConfig.getInstance();
        config.backgroundColorR = 0.0f;
        config.backgroundColorG = 0.0f;
        config.backgroundColorB = 0.0f;
        int padding = 20;
        int columnSpacing = 15;
        int sliderHeight = 20;
        int verticalSpacing = 28;
        int availableWidth = this.panelWidth - padding * 2 - columnSpacing * 2;
        int columnWidth = availableWidth / 3;
        int col1X = this.panelX + padding;
        int col2X = col1X + columnWidth + columnSpacing;
        int col3X = col2X + columnWidth + columnSpacing;
        int col1Y = startY = this.panelY + (SettingsScreen.isDevelopmentMode() ? 50 : 50);
        this.starRedSlider = new ColorSlider(col1X, col1Y, columnWidth, sliderHeight, (Component)Component.literal((String)"Red: "), config.starColorR, value -> {
            config.starColorR = value.floatValue();
        });
        this.developSettingWidgets.add((AbstractWidget)this.starRedSlider);
        this.starGreenSlider = new ColorSlider(col1X, col1Y += verticalSpacing, columnWidth, sliderHeight, (Component)Component.literal((String)"Green: "), config.starColorG, value -> {
            config.starColorG = value.floatValue();
        });
        this.developSettingWidgets.add((AbstractWidget)this.starGreenSlider);
        this.starBlueSlider = new ColorSlider(col1X, col1Y += verticalSpacing, columnWidth, sliderHeight, (Component)Component.literal((String)"Blue: "), config.starColorB, value -> {
            config.starColorB = value.floatValue();
        });
        this.developSettingWidgets.add((AbstractWidget)this.starBlueSlider);
        this.starOpacitySlider = new OpacitySlider(col1X, col1Y += verticalSpacing, columnWidth, sliderHeight, (Component)Component.literal((String)"Opacity: "), config.starOpacity, value -> {
            config.starOpacity = value.floatValue();
        });
        this.developSettingWidgets.add((AbstractWidget)this.starOpacitySlider);
        int col2Y = startY;
        this.bgRedSlider = new ColorSlider(col2X, col2Y, columnWidth, sliderHeight, (Component)Component.literal((String)"Red: "), config.backgroundColorR, value -> {
            config.backgroundColorR = value.floatValue();
        });
        this.developSettingWidgets.add((AbstractWidget)this.bgRedSlider);
        this.bgGreenSlider = new ColorSlider(col2X, col2Y += verticalSpacing, columnWidth, sliderHeight, (Component)Component.literal((String)"Green: "), config.backgroundColorG, value -> {
            config.backgroundColorG = value.floatValue();
        });
        this.developSettingWidgets.add((AbstractWidget)this.bgGreenSlider);
        this.bgBlueSlider = new ColorSlider(col2X, col2Y += verticalSpacing, columnWidth, sliderHeight, (Component)Component.literal((String)"Blue: "), config.backgroundColorB, value -> {
            config.backgroundColorB = value.floatValue();
        });
        this.developSettingWidgets.add((AbstractWidget)this.bgBlueSlider);
        int col3Y = startY;
        this.panelOpacitySlider = new OpacitySlider(col3X, col3Y, columnWidth, sliderHeight, (Component)Component.literal((String)"Panel Opacity: "), config.panelOpacity, value -> {
            config.panelOpacity = value.floatValue();
        });
        this.developSettingWidgets.add((AbstractWidget)this.panelOpacitySlider);
        this.colorTransitionToggle = Button.builder((Component)Component.literal((String)("Transition: " + (config.enableColorTransition ? "ON" : "OFF"))), button -> {
            config.enableColorTransition = !config.enableColorTransition;
            button.setMessage((Component)Component.literal((String)("Transition: " + (config.enableColorTransition ? "ON" : "OFF"))));
        }).bounds(col3X, col3Y += verticalSpacing, columnWidth, sliderHeight).build();
        this.developSettingWidgets.add((AbstractWidget)this.colorTransitionToggle);
    }

    private void createCheatsSettings() {
        int padding = 20;
        int buttonWidth = 180;
        int buttonHeight = 24;
        int verticalSpacing = 30;
        int horizontalSpacing = 15;
        int buttonsPerRow = 3;
        int startY = this.panelY + 30 + 50;
        int startX = this.panelX + padding;
        int tokenButtonWidth = 200;
        int tokenButtonSpacing = 15;
        int tokenButtonsStartX = this.panelX + (this.panelWidth - (tokenButtonWidth * 2 + tokenButtonSpacing)) / 2;
        int tokenButtonY = startY;
        Button reloadRegularButton = Button.builder((Component)Component.literal((String)"Reload Regular Tokens"), button -> {
            ReloadTokensPacket packet = new ReloadTokensPacket(true, false);
            packet.sendToServer();
            button.setMessage((Component)Component.literal((String)"Reloading..."));
            button.active = false;
            new Thread(() -> {
                try {
                    Thread.sleep(500L);
                    this.minecraft.execute(() -> {
                        button.setMessage((Component)Component.literal((String)"Reload Regular Tokens"));
                        button.active = true;
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }).start();
        }).bounds(tokenButtonsStartX, tokenButtonY, tokenButtonWidth, buttonHeight).build();
        this.cheatsSettingWidgets.add((AbstractWidget)reloadRegularButton);
        Button reloadGuaranteedButton = Button.builder((Component)Component.literal((String)"Reload Guaranteed Token"), button -> {
            ReloadTokensPacket packet = new ReloadTokensPacket(false, true);
            packet.sendToServer();
            button.setMessage((Component)Component.literal((String)"Reloading..."));
            button.active = false;
            new Thread(() -> {
                try {
                    Thread.sleep(500L);
                    this.minecraft.execute(() -> {
                        button.setMessage((Component)Component.literal((String)"Reload Guaranteed Token"));
                        button.active = true;
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }).start();
        }).bounds(tokenButtonsStartX + tokenButtonWidth + tokenButtonSpacing, tokenButtonY, tokenButtonWidth, buttonHeight).build();
        this.cheatsSettingWidgets.add((AbstractWidget)reloadGuaranteedButton);
        startY += verticalSpacing + 20;
        Collection<FigureCollection> collections = CollectionRegistry.getAllCollections();
        List filteredCollections = collections.stream().filter(collection -> !collection.getId().equals("default")).collect(Collectors.toList());
        int row = 0;
        int col = 0;
        for (FigureCollection collection2 : filteredCollections) {
            int buttonX = startX + col * (buttonWidth + horizontalSpacing);
            int buttonY = startY + row * verticalSpacing;
            Button unlockButton = Button.builder((Component)Component.literal((String)("Unlock " + collection2.getName())), button -> {
                UnlockCollectionPacket packet = new UnlockCollectionPacket(collection2.getId());
                packet.sendToServer();
                button.setMessage((Component)Component.literal((String)"Unlocking..."));
                button.active = false;
                new Thread(() -> {
                    try {
                        Thread.sleep(1000L);
                        this.minecraft.execute(() -> {
                            button.setMessage((Component)Component.literal((String)("Unlock " + collection2.getName())));
                            button.active = true;
                        });
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }).start();
            }).bounds(buttonX, buttonY, buttonWidth, buttonHeight).build();
            this.cheatsSettingWidgets.add((AbstractWidget)unlockButton);
            if (++col < buttonsPerRow) continue;
            col = 0;
            ++row;
        }
    }

    private void switchTab(Tab tab) {
        this.activeTab = tab;
        for (AbstractWidget widget : this.serverSettingWidgets) {
            this.removeWidget((GuiEventListener)widget);
        }
        for (AbstractWidget widget : this.developSettingWidgets) {
            this.removeWidget((GuiEventListener)widget);
        }
        for (AbstractWidget widget : this.cheatsSettingWidgets) {
            this.removeWidget((GuiEventListener)widget);
        }
        List<AbstractWidget> activeWidgets = tab == Tab.SERVER ? this.serverSettingWidgets : (tab == Tab.DEVELOP ? this.developSettingWidgets : (tab == Tab.CHEATS ? this.cheatsSettingWidgets : new ArrayList<AbstractWidget>()));
        for (AbstractWidget widget : activeWidgets) {
            this.addRenderableWidget((GuiEventListener)widget);
        }
        this.serverTabButton.setSelected(tab == Tab.SERVER);
        if (this.developTabButton != null) {
            this.developTabButton.setSelected(tab == Tab.DEVELOP);
        }
        if (this.cheatsTabButton != null) {
            this.cheatsTabButton.setSelected(tab == Tab.CHEATS);
        }
        this.updateActionButtonState();
    }

    public void renderBlurredBackground(float partialTick) {
    }

    private static enum Tab {
        SERVER("Server"),
        DEVELOP("Develop"),
        CHEATS("Cheats");

        private final String displayName;

        private Tab(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    private static class ColorSlider
    extends AbstractSliderButton {
        private final Component prefix;
        private final Consumer<Double> onValueChange;

        public ColorSlider(int x, int y, int width, int height, Component prefix, double initialValue, Consumer<Double> onValueChange) {
            super(x, y, width, height, (Component)Component.empty(), initialValue);
            this.prefix = prefix;
            this.onValueChange = onValueChange;
            this.updateMessage();
        }

        protected void updateMessage() {
            int intValue = (int)(this.value * 255.0);
            this.setMessage((Component)Component.literal((String)(this.prefix.getString() + intValue)));
        }

        protected void applyValue() {
            this.onValueChange.accept(this.value);
        }

        public void setValue(double newValue) {
            this.value = newValue;
            this.updateMessage();
        }
    }

    private static class OpacitySlider
    extends AbstractSliderButton {
        private final Component prefix;
        private final Consumer<Double> onValueChange;

        public OpacitySlider(int x, int y, int width, int height, Component prefix, double initialValue, Consumer<Double> onValueChange) {
            super(x, y, width, height, (Component)Component.empty(), initialValue);
            this.prefix = prefix;
            this.onValueChange = onValueChange;
            this.updateMessage();
        }

        protected void updateMessage() {
            int percentage = (int)(this.value * 100.0);
            this.setMessage((Component)Component.literal((String)(this.prefix.getString() + percentage + "%")));
        }

        protected void applyValue() {
            this.onValueChange.accept(this.value);
        }

        public void setValue(double newValue) {
            this.value = newValue;
            this.updateMessage();
        }
    }

    private static class HourSlider
    extends AbstractSliderButton {
        private final Component prefix;
        private final Consumer<Integer> onValueChange;

        public HourSlider(int x, int y, int width, int height, Component prefix, int initialValue, Consumer<Integer> onValueChange) {
            super(x, y, width, height, (Component)Component.empty(), (double)initialValue / 23.0);
            this.prefix = prefix;
            this.onValueChange = onValueChange;
            this.updateMessage();
        }

        protected void updateMessage() {
            int hour = (int)(this.value * 23.0);
            this.setMessage((Component)Component.literal((String)(this.prefix.getString() + String.format("%02d:00", hour))));
        }

        protected void applyValue() {
            int hour = (int)(this.value * 23.0);
            this.onValueChange.accept(hour);
        }

        public void setValue(int newValue) {
            this.value = (double)newValue / 23.0;
            this.updateMessage();
        }
    }
}

