/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.gui.widget;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.theplumteam.BlockPopsMod;
import com.theplumteam.blockentity.BoxBlockEntity;
import com.theplumteam.client.discovery.ClientDiscoveryManager;
import com.theplumteam.client.gui.util.GuiScaleManager;
import com.theplumteam.client.model.FigureModel;
import com.theplumteam.client.renderer.FigureWidgetRenderer;
import com.theplumteam.figure.FigureDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

public class FigureEntry
extends ObjectSelectionList.Entry<FigureEntry> {
    private final Minecraft mc = Minecraft.getInstance();
    private final List<FigureDefinition> figures;
    private final String collectionId;
    private float modelScale = 1.0f;
    private float xRotation = 0.0f;
    private float yRotation = 70.0f;
    private float zRotation = 0.0f;
    private float xOffset = -60.0f;
    private float yOffset = 15.0f;
    private float zOffset = 0.0f;
    private static final int FIGURE_SIZE = 80;
    private static final int GRID_SPACING = 4;

    public FigureEntry(List<FigureDefinition> figures, String collectionId) {
        this.figures = new ArrayList<FigureDefinition>(figures);
        this.collectionId = collectionId;
    }

    public void setConfiguration(float modelScale, float xRotation, float yRotation, float zRotation, float xOffset, float yOffset, float zOffset) {
        this.modelScale = modelScale;
        this.xRotation = xRotation;
        this.yRotation = yRotation;
        this.zRotation = zRotation;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
    }

    public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
        int effectiveFigureSize = 80;
        int effectiveSpacing = 4;
        if (GuiScaleManager.isUsingInverseScale()) {
            float scale = GuiScaleManager.getRenderScaleFactor();
            effectiveFigureSize = (int)(80.0f * scale);
            effectiveSpacing = (int)(4.0f * scale);
        }
        int totalFiguresWidth = this.figures.size() * effectiveFigureSize + (this.figures.size() - 1) * effectiveSpacing;
        int startX = x + (entryWidth - totalFiguresWidth) / 2;
        for (int i = 0; i < this.figures.size(); ++i) {
            boolean isFigureHovered;
            FigureDefinition figure = this.figures.get(i);
            int figureX = startX + i * (effectiveFigureSize + effectiveSpacing);
            String uniqueFigureId = this.collectionId + ":" + figure.getId();
            boolean isDiscovered = ClientDiscoveryManager.isDiscovered(uniqueFigureId);
            if (isDiscovered) {
                graphics.fill(figureX, y, figureX + effectiveFigureSize, y + effectiveFigureSize, 0x30FFFFFF);
            } else {
                graphics.fill(figureX, y, figureX + effectiveFigureSize, y + effectiveFigureSize, 0x50000000);
            }
            boolean bl = isFigureHovered = mouseX >= figureX && mouseX < figureX + effectiveFigureSize && mouseY >= y && mouseY < y + effectiveFigureSize;
            if (isFigureHovered) {
                if (isDiscovered) {
                    graphics.fill(figureX, y, figureX + effectiveFigureSize, y + effectiveFigureSize, 0x40FFFFFF);
                } else {
                    graphics.fill(figureX, y, figureX + effectiveFigureSize, y + effectiveFigureSize, 0x60000000);
                }
            }
            int borderColor = isDiscovered ? -2130706433 : 0x60808080;
            graphics.fill(figureX, y, figureX + effectiveFigureSize, y + 1, borderColor);
            graphics.fill(figureX, y + effectiveFigureSize - 1, figureX + effectiveFigureSize, y + effectiveFigureSize, borderColor);
            graphics.fill(figureX, y, figureX + 1, y + effectiveFigureSize, borderColor);
            graphics.fill(figureX + effectiveFigureSize - 1, y, figureX + effectiveFigureSize, y + effectiveFigureSize, borderColor);
            if (isDiscovered) {
                this.render3DFigure(graphics, figure, figureX, y, effectiveFigureSize, partialTick);
                int guiScale = (Integer)this.mc.options.guiScale().get();
                if (guiScale >= 3) continue;
                MutableComponent figureName = Component.literal((String)figure.getName());
                int nameWidth = this.mc.font.width((FormattedText)figureName);
                if (nameWidth > effectiveFigureSize - 4) {
                    String truncated = figure.getName();
                    while (this.mc.font.width(truncated + "...") > effectiveFigureSize - 4 && truncated.length() > 0) {
                        truncated = truncated.substring(0, truncated.length() - 1);
                    }
                    figureName = Component.literal((String)(truncated + "..."));
                }
                int nameX = figureX + (effectiveFigureSize - this.mc.font.width((FormattedText)figureName)) / 2;
                Objects.requireNonNull(this.mc.font);
                int nameY = y + effectiveFigureSize - 9 - 2;
                graphics.drawString(this.mc.font, (Component)figureName, nameX, nameY, 0xFFFFFF, true);
                continue;
            }
            MutableComponent questionMark = Component.literal((String)"?");
            int qmWidth = this.mc.font.width((FormattedText)questionMark);
            int qmX = figureX + (effectiveFigureSize - qmWidth) / 2;
            Objects.requireNonNull(this.mc.font);
            int qmY = y + (effectiveFigureSize - 9) / 2;
            graphics.drawString(this.mc.font, (Component)questionMark, qmX, qmY, 0x808080, false);
        }
    }

    private void render3DFigure(GuiGraphics graphics, FigureDefinition figure, int x, int y, int size, float partialTick) {
        BlockPopsMod.LOGGER.info("render3DFigure called for figure: {} in collection: {}", (Object)figure.getId(), (Object)this.collectionId);
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        BoxBlockEntity renderEntity = FigureWidgetRenderer.getOrCreateRenderEntity(figure, this.collectionId);
        if (renderEntity == null) {
            BlockPopsMod.LOGGER.warn("renderEntity is null for figure: {} in collection: {}", (Object)figure.getId(), (Object)this.collectionId);
            poseStack.popPose();
            return;
        }
        graphics.enableScissor(x, y, x + size, y + size);
        RenderSystem.disableDepthTest();
        float centerX = (float)x + (float)size / 2.0f + this.xOffset;
        float centerY = (float)y + (float)size * 0.6f + this.yOffset;
        float baseZ = 100.0f + this.zOffset;
        float centerZ = baseZ * ((float)size / 80.0f);
        Lighting.setupForFlatItems();
        poseStack.translate(centerX, centerY, centerZ);
        float scale = (float)size * this.modelScale;
        poseStack.scale(scale, -scale, scale);
        poseStack.mulPose(Axis.YP.rotationDegrees(this.yRotation));
        poseStack.mulPose(Axis.XP.rotationDegrees(this.xRotation));
        poseStack.mulPose(Axis.ZP.rotationDegrees(this.zRotation));
        MultiBufferSource.BufferSource bufferSource = this.mc.renderBuffers().bufferSource();
        FigureModel figureModel = FigureWidgetRenderer.getModel();
        GeoBlockRenderer<BoxBlockEntity> figureRenderer = FigureWidgetRenderer.getRenderer();
        try {
            ResourceLocation modelResource = figureModel.getModelResource(renderEntity);
            if (modelResource == null) {
                BlockPopsMod.LOGGER.warn("FigureEntry: modelResource is null");
                RenderSystem.enableDepthTest();
                graphics.disableScissor();
                poseStack.popPose();
                return;
            }
            BakedGeoModel bakedModel = figureModel.getBakedModel(modelResource);
            ResourceLocation textureResource = figureModel.getTextureResource(renderEntity);
            if (textureResource == null) {
                RenderSystem.enableDepthTest();
                graphics.disableScissor();
                poseStack.popPose();
                return;
            }
            RenderType renderType = figureModel.getRenderType(renderEntity, textureResource);
            VertexConsumer buffer = bufferSource.getBuffer(renderType);
            figureRenderer.actuallyRender(poseStack, (BlockEntity)renderEntity, bakedModel, renderType, (MultiBufferSource)bufferSource, buffer, false, partialTick, 0xF000F0, OverlayTexture.NO_OVERLAY, -1);
            bufferSource.endBatch();
        }
        catch (Exception e) {
            BlockPopsMod.LOGGER.error("FigureEntry: Exception rendering figure: {}", (Object)e.getMessage());
        }
        RenderSystem.enableDepthTest();
        graphics.disableScissor();
        Lighting.setupFor3DItems();
        poseStack.popPose();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }

    public Component getNarration() {
        if (this.figures.isEmpty()) {
            return Component.literal((String)"Empty row");
        }
        if (this.figures.size() == 1) {
            FigureDefinition figure = this.figures.get(0);
            String uniqueFigureId = this.collectionId + ":" + figure.getId();
            boolean isDiscovered = ClientDiscoveryManager.isDiscovered(uniqueFigureId);
            return Component.literal((String)(isDiscovered ? figure.getName() : "Undiscovered Figure"));
        }
        int discoveredCount = 0;
        for (FigureDefinition figure : this.figures) {
            String uniqueFigureId = this.collectionId + ":" + figure.getId();
            if (!ClientDiscoveryManager.isDiscovered(uniqueFigureId)) continue;
            ++discoveredCount;
        }
        return Component.literal((String)(discoveredCount + " of " + this.figures.size() + " figures discovered"));
    }

    public List<FigureDefinition> getFigures() {
        return this.figures;
    }
}

