/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.gui.widget;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class TabButton
extends Button {
    private boolean selected;
    private static final int SELECTED_BG = -1342177280;
    private static final int UNSELECTED_BG = 0x60000000;
    private static final int SELECTED_OUTLINE = -1;
    private static final int UNSELECTED_OUTLINE = 0x40FFFFFF;
    private static final int SELECTED_TEXT = 0xFFFFFF;
    private static final int UNSELECTED_TEXT = 0x999999;

    public TabButton(int x, int y, int width, int height, Component label, boolean selected, Button.OnPress onPress) {
        super(x, y, width, height, label, onPress, DEFAULT_NARRATION);
        this.selected = selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int textColor;
        int bgColor = this.selected ? -1342177280 : 0x60000000;
        int outlineColor = this.selected ? -1 : 0x40FFFFFF;
        int n = textColor = this.selected ? 0xFFFFFF : 0x999999;
        if (!this.selected && this.isHovered()) {
            bgColor = Integer.MIN_VALUE;
            textColor = 0xCCCCCC;
        }
        graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, bgColor);
        graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + 1, outlineColor);
        graphics.fill(this.getX(), this.getY(), this.getX() + 1, this.getY() + this.height, outlineColor);
        graphics.fill(this.getX() + this.width - 1, this.getY(), this.getX() + this.width, this.getY() + this.height, outlineColor);
        if (!this.selected) {
            graphics.fill(this.getX(), this.getY() + this.height - 1, this.getX() + this.width, this.getY() + this.height, outlineColor);
        }
        graphics.drawCenteredString(Minecraft.getInstance().font, this.getMessage(), this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, textColor);
    }

    protected boolean isValidClickButton(int button) {
        return button == 0;
    }
}

