/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.model;

import com.theplumteam.block.PopBlockColor;
import com.theplumteam.blockentity.BoxBlockEntity;
import com.theplumteam.figure.CollectionRegistry;
import com.theplumteam.figure.FigureCollection;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.model.GeoModel;

public class BoxBlockModel
extends GeoModel<BoxBlockEntity> {
    private static final ResourceLocation MODEL = ResourceLocation.fromNamespaceAndPath((String)"blockpops", (String)"geo/block/box_block.geo.json");
    private static final ResourceLocation ANIMATION = ResourceLocation.fromNamespaceAndPath((String)"blockpops", (String)"animations/block/box_block.animation.json");
    private static final ResourceLocation DEFAULT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"blockpops", (String)"textures/block/box/original.png");

    public ResourceLocation getModelResource(BoxBlockEntity animatable) {
        return MODEL;
    }

    public ResourceLocation getTextureResource(BoxBlockEntity animatable) {
        PopBlockColor color = animatable.getColor();
        if (color != null) {
            return ResourceLocation.fromNamespaceAndPath((String)"blockpops", (String)("textures/block/box/" + color.getTextureName().toLowerCase(Locale.ROOT) + ".png"));
        }
        String collectionId = animatable.getCollectionId();
        return CollectionRegistry.getCollection(collectionId).map(FigureCollection::getBoxTexture).orElse(DEFAULT_TEXTURE);
    }

    public ResourceLocation getAnimationResource(BoxBlockEntity animatable) {
        return ANIMATION;
    }
}

