/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.theplumteam.block.ClawMachineBlock;
import com.theplumteam.blockentity.ClawMachineBlockEntity;
import com.theplumteam.client.renderer.ClawMachineBlockRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;

public class ClawMachineBlockItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private final ClawMachineBlockRenderer renderer = new ClawMachineBlockRenderer();
    private ClawMachineBlockEntity renderEntity;

    public ClawMachineBlockItemRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Block block = Block.byItem((Item)stack.getItem());
        if (block instanceof ClawMachineBlock) {
            CustomData customData;
            ClawMachineBlock clawMachineBlock = (ClawMachineBlock)block;
            if (this.renderEntity == null || !this.renderEntity.getBlockState().is((Block)clawMachineBlock)) {
                this.renderEntity = new ClawMachineBlockEntity(BlockPos.ZERO, clawMachineBlock.defaultBlockState());
            }
            if ((customData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA)) != null) {
                CompoundTag blockEntityTag = customData.copyTag();
                this.renderEntity.loadFromItemNbt(blockEntityTag);
            }
            poseStack.pushPose();
            poseStack.translate(0.5, 0.0, 0.5);
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            poseStack.translate(-0.5, 0.0, -0.5);
            float baseScale = 0.33333334f;
            if (displayContext == ItemDisplayContext.GROUND) {
                poseStack.translate(0.5, 0.0, 0.5);
                poseStack.scale(baseScale * 0.7f, baseScale * 0.7f, baseScale * 0.7f);
                poseStack.translate(-0.5, 0.5, -0.5);
            } else if (displayContext == ItemDisplayContext.GUI) {
                poseStack.translate(0.5, 0.0, 0.5);
                poseStack.scale(baseScale, baseScale, baseScale);
                poseStack.translate(-0.5, 0.0, -0.5);
            } else if (displayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND || displayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
                poseStack.translate(0.5, 0.0, 0.5);
                poseStack.scale(baseScale * 0.8f, baseScale * 0.8f, baseScale * 0.8f);
                poseStack.translate(-0.5, 1.0, -0.5);
            } else if (displayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || displayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
                poseStack.translate(0.5, 0.0, 0.5);
                poseStack.scale(baseScale * 1.0f, baseScale * 1.0f, baseScale * 1.0f);
                poseStack.translate(-0.5, 0.0, -0.5);
            } else {
                poseStack.translate(0.5, 0.0, 0.5);
                poseStack.scale(baseScale, baseScale, baseScale);
                poseStack.translate(-0.5, 0.0, -0.5);
            }
            float partialTick = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
            this.renderer.render(this.renderEntity, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
            poseStack.popPose();
        }
    }
}

