/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.command;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.theplumteam.block.PopBlockColor;
import com.theplumteam.data.IPlayerDiscovery;
import com.theplumteam.data.PlayerDataManager;
import com.theplumteam.figure.CollectionRegistry;
import com.theplumteam.figure.FigureDefinition;
import com.theplumteam.figure.FigureType;
import com.theplumteam.network.TokenType;
import com.theplumteam.network.UnlockFigurePacket;
import com.theplumteam.registry.ModItems;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetBoxCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetBoxCommand.class);
    private static final SuggestionProvider<CommandSourceStack> COLLECTION_SUGGESTIONS = (context, builder) -> {
        Set<String> collectionIds = CollectionRegistry.getCollectionIds();
        return SharedSuggestionProvider.suggest(collectionIds.stream().filter(id -> !id.equals("default")), (SuggestionsBuilder)builder);
    };
    private static final SuggestionProvider<CommandSourceStack> TOKEN_TYPE_SUGGESTIONS = (context, builder) -> SharedSuggestionProvider.suggest((String[])new String[]{"regular", "guaranteed"}, (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"blockpops").then(((LiteralArgumentBuilder)Commands.literal((String)"getbox").requires(source -> source.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"collection_id", (ArgumentType)StringArgumentType.string()).suggests(COLLECTION_SUGGESTIONS).executes(context -> GetBoxCommand.executeCommand((CommandContext<CommandSourceStack>)context, TokenType.REGULAR))).then(Commands.argument((String)"token_type", (ArgumentType)StringArgumentType.string()).suggests(TOKEN_TYPE_SUGGESTIONS).executes(context -> {
            String tokenTypeStr = StringArgumentType.getString((CommandContext)context, (String)"token_type");
            TokenType tokenType = GetBoxCommand.parseTokenType(tokenTypeStr);
            if (tokenType == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Invalid token type. Use 'regular' or 'guaranteed'"));
                return 0;
            }
            return GetBoxCommand.executeCommand((CommandContext<CommandSourceStack>)context, tokenType);
        })))));
    }

    private static TokenType parseTokenType(String tokenTypeStr) {
        if (tokenTypeStr.equalsIgnoreCase("regular")) {
            return TokenType.REGULAR;
        }
        if (tokenTypeStr.equalsIgnoreCase("guaranteed")) {
            return TokenType.GUARANTEED;
        }
        return null;
    }

    private static int executeCommand(CommandContext<CommandSourceStack> context, TokenType tokenType) {
        String collectionId = StringArgumentType.getString(context, (String)"collection_id");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            ServerPlayer player = source.getPlayerOrException();
            if (!CollectionRegistry.getCollection(collectionId).isPresent()) {
                source.sendFailure((Component)Component.literal((String)("Collection '" + collectionId + "' does not exist")));
                return 0;
            }
            IPlayerDiscovery discovery = PlayerDataManager.getDiscovery((Player)player);
            GetBoxCommand.processBoxDrop(player, collectionId, tokenType, discovery);
            PlayerDataManager.saveDiscovery((Player)player);
            source.sendSuccess(() -> Component.literal((String)("Gave box from collection '" + collectionId + "' using " + tokenType.name().toLowerCase() + " token logic")), true);
            return 1;
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.literal((String)"This command can only be executed by a player"));
            LOGGER.error("Error executing getbox command", (Throwable)e);
            return 0;
        }
    }

    @Nullable
    private static GameProfile getFreshGameProfile(ServerPlayer player, FigureDefinition figure) {
        if (figure.getPlayerUUID() == null) {
            return null;
        }
        try {
            ProfileResult result = player.getServer().getSessionService().fetchProfile(figure.getPlayerUUID(), true);
            return result != null ? result.profile() : null;
        }
        catch (Exception e) {
            LOGGER.error("Failed to fetch fresh GameProfile for {}: {}", (Object)figure.getName(), (Object)e.getMessage());
            return null;
        }
    }

    @Nullable
    private static String getQuickSkinIdFromServer(UUID playerId) {
        try {
            Class<?> repoClass = Class.forName("com.quickskin.mod.server.data.ServerPlayerAppearanceRepository");
            Method getInstanceMethod = repoClass.getMethod("getInstance", new Class[0]);
            Object repoInstance = getInstanceMethod.invoke(null, new Object[0]);
            Method getAppearanceMethod = repoClass.getMethod("getAppearance", UUID.class);
            Object appearance = getAppearanceMethod.invoke(repoInstance, playerId);
            if (appearance != null) {
                Class<?> appearanceClass = appearance.getClass();
                Method getSkinIdMethod = appearanceClass.getMethod("getSkinId", new Class[0]);
                return (String)getSkinIdMethod.invoke(appearance, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static void processBoxDrop(ServerPlayer player, String collectionId, TokenType tokenType, IPlayerDiscovery discovery) {
        CollectionRegistry.getCollection(collectionId).ifPresent(collection -> {
            List<FigureDefinition> figures = collection.getFigures();
            if (!figures.isEmpty()) {
                FigureDefinition selectedFigure = GetBoxCommand.selectFigure(figures, tokenType, discovery, collectionId);
                ItemStack boxItem = null;
                if (collectionId.equals("world_players")) {
                    PopBlockColor color = selectedFigure.getFavoriteColor();
                    if (color == null) {
                        color = PopBlockColor.ORIGINAL;
                    }
                    boxItem = new ItemStack((ItemLike)ModItems.DEFAULT_BOX_BLOCK_ITEMS.get((Object)color).get());
                } else {
                    boxItem = ModItems.BOX_BLOCK_ITEMS.containsKey(collectionId) ? new ItemStack((ItemLike)ModItems.BOX_BLOCK_ITEMS.get(collectionId).get()) : new ItemStack((ItemLike)ModItems.DEFAULT_BOX_BLOCK_ITEMS.get((Object)PopBlockColor.ORIGINAL).get());
                }
                if (boxItem != null) {
                    String oldSnapshot;
                    String uniqueFigureId = collectionId + ":" + selectedFigure.getId();
                    String skinSnapshot = null;
                    String quickSkinSnapshot = null;
                    if (selectedFigure.getType() == FigureType.PLAYER) {
                        String qsId;
                        GameProfile freshProfile = GetBoxCommand.getFreshGameProfile(player, selectedFigure);
                        if (freshProfile != null && !freshProfile.getProperties().get((Object)"textures").isEmpty()) {
                            skinSnapshot = ((Property)freshProfile.getProperties().get((Object)"textures").iterator().next()).value();
                            discovery.saveFigureSkin(uniqueFigureId, skinSnapshot);
                            LOGGER.info("Saved/updated fresh skin snapshot for {}.", (Object)uniqueFigureId);
                        }
                        if (selectedFigure.getPlayerUUID() != null && (qsId = GetBoxCommand.getQuickSkinIdFromServer(selectedFigure.getPlayerUUID())) != null && !qsId.isEmpty()) {
                            quickSkinSnapshot = qsId;
                            discovery.saveFigureQuickSkin(uniqueFigureId, quickSkinSnapshot);
                            LOGGER.info("Captured & Saved Quick Skin ID for figure {}: {}", (Object)uniqueFigureId, (Object)qsId);
                        }
                    }
                    if (!discovery.isDiscovered(uniqueFigureId)) {
                        discovery.discover(uniqueFigureId);
                        UnlockFigurePacket.sendToPlayer(player, uniqueFigureId, selectedFigure.getName(), skinSnapshot, quickSkinSnapshot);
                    }
                    CompoundTag blockEntityTag = new CompoundTag();
                    blockEntityTag.putString("FigureId", selectedFigure.getId());
                    blockEntityTag.putString("CollectionId", collectionId);
                    if (collectionId.equals("world_players")) {
                        PopBlockColor color = selectedFigure.getFavoriteColor();
                        if (color == null) {
                            color = PopBlockColor.ORIGINAL;
                        }
                        blockEntityTag.putString("Color", color.name());
                    }
                    if (skinSnapshot != null && !skinSnapshot.isEmpty()) {
                        blockEntityTag.putString("SkinSnapshot", skinSnapshot);
                    } else if (selectedFigure.getType() == FigureType.PLAYER && (oldSnapshot = discovery.getFigureSkin(uniqueFigureId)) != null && !oldSnapshot.isEmpty()) {
                        blockEntityTag.putString("SkinSnapshot", oldSnapshot);
                    }
                    if (quickSkinSnapshot != null) {
                        blockEntityTag.putString("QuickSkinId", quickSkinSnapshot);
                    }
                    blockEntityTag.putString("id", "blockpops:box_block");
                    boxItem.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)blockEntityTag));
                    ItemEntity itemEntity = new ItemEntity(player.level(), player.getX(), player.getY() + 1.0, player.getZ(), boxItem);
                    itemEntity.setDeltaMovement(0.0, 0.2, 0.0);
                    player.level().addFreshEntity((Entity)itemEntity);
                }
            }
        });
    }

    private static FigureDefinition selectFigure(List<FigureDefinition> figures, TokenType tokenType, IPlayerDiscovery discovery, String collectionId) {
        Random random = new Random();
        if (tokenType == TokenType.GUARANTEED) {
            Set<String> discoveredSet = discovery.getDiscoveredSet();
            ArrayList<FigureDefinition> undiscoveredFigures = new ArrayList<FigureDefinition>();
            for (FigureDefinition figure : figures) {
                String figureId = collectionId + ":" + figure.getId();
                if (discoveredSet.contains(figureId)) continue;
                undiscoveredFigures.add(figure);
            }
            if (!undiscoveredFigures.isEmpty()) {
                return (FigureDefinition)undiscoveredFigures.get(random.nextInt(undiscoveredFigures.size()));
            }
            return figures.get(random.nextInt(figures.size()));
        }
        return figures.get(random.nextInt(figures.size()));
    }
}

